/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class PurgeCommand
extends AbstractJmxCommand {
    protected String[] helpFile = new String[]{"Task Usage: Main purge [browse-options] <destinations>", "Description: Delete selected destination's messages that matches the message selector.", "", "Purge Options:", "    --msgsel <msgsel1,msglsel2>   Add to the search list messages matched by the query similar to", "                                  the messages selector format.", "    --reset                       After the purge operation, reset the destination statistics.", "    --jmxurl <url>                Set the JMX URL to connect to.", "    --pid <pid>                   Set the pid to connect to (only on Sun JVM).", "    --jmxuser <user>              Set the JMX user used for authenticating.", "    --jmxpassword <password>      Set the JMX password used for authenticating.", "    --jmxlocal                    Use the local JMX server instead of a remote one.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the browse broker help information.", "", "Examples:", "    Main purge FOO.BAR", "        - Delete all the messages in queue FOO.BAR", "    Main purge --msgsel \"JMSMessageID='*:10',JMSPriority>5\" FOO.*", "        - Delete all the messages in the destinations that matches FOO.* and has a JMSMessageID in", "          the header field that matches the wildcard *:10, and has a JMSPriority field > 5 in the", "          queue FOO.BAR.", "          SLQ92 syntax is also supported.", "        * To use wildcard queries, the field must be a string and the query enclosed in ''", "          Use double quotes \"\" around the entire message selector string.", ""};
    private final List<String> queryAddObjects = new ArrayList<String>(10);
    private final List<String> querySubObjects = new ArrayList<String>(10);
    private boolean resetStatistics;

    @Override
    public String getName() {
        return "purge";
    }

    @Override
    public String getOneLineDescription() {
        return "Delete selected destination's messages that matches the message selector";
    }

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        if (tokens.isEmpty()) {
            tokens.add("*");
        }
        Iterator<String> i = tokens.iterator();
        while (i.hasNext()) {
            List queueList = JmxMBeansUtil.queryMBeans(this.createJmxConnection(), "type=Broker,brokerName=*,destinationType=Queue,destinationName=" + i.next());
            Iterator j = queueList.iterator();
            while (j.hasNext()) {
                ObjectName queueName = ((ObjectInstance)j.next()).getObjectName();
                if (this.queryAddObjects.isEmpty()) {
                    this.purgeQueue(queueName);
                    continue;
                }
                QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.createJmxConnection(), queueName, QueueViewMBean.class, true);
                int removed = 0;
                String sqlQuery = this.convertToSQL92(this.queryAddObjects);
                removed = proxy.removeMatchingMessages(sqlQuery);
                this.context.printInfo("Removed: " + removed + " messages for message selector " + sqlQuery);
                if (!this.resetStatistics) continue;
                proxy.resetStatistics();
            }
        }
    }

    public void purgeQueue(ObjectName queue) throws Exception {
        this.context.printInfo("Purging all messages in queue: " + queue.getKeyProperty("destinationName"));
        this.createJmxConnection().invoke(queue, "purge", new Object[0], new String[0]);
        if (this.resetStatistics) {
            this.createJmxConnection().invoke(queue, "resetStatistics", new Object[0], new String[0]);
        }
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.startsWith("--msgsel")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Message selector not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer(tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--xmsgsel")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Message selector not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer(tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--reset")) {
            this.resetStatistics = true;
        } else {
            super.handleOption(token, tokens);
        }
    }

    public String convertToSQL92(List<String> tokens) {
        StringBuilder selector = new StringBuilder();
        boolean isFirstToken = true;
        Iterator<String> i = tokens.iterator();
        while (i.hasNext()) {
            String token = i.next().toString();
            if (token.matches("^[^=]*='.*[\\*\\?].*'$")) {
                token = token.replace('?', '_').replace('*', '%').replaceFirst("=", " LIKE ");
            }
            if (isFirstToken) {
                isFirstToken = false;
            } else {
                selector.append(" AND ");
            }
            selector.append('(').append(token).append(')');
        }
        return selector.toString();
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

