/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "experimentModel_types.h"

#include <algorithm>

namespace apache { namespace airavata { namespace model { namespace workspace { namespace experiment {

int _kExperimentStateValues[] = {
  ExperimentState::CREATED,
  ExperimentState::VALIDATED,
  ExperimentState::SCHEDULED,
  ExperimentState::LAUNCHED,
  ExperimentState::EXECUTING,
  ExperimentState::CANCELING,
  ExperimentState::CANCELED,
  ExperimentState::SUSPENDED,
  ExperimentState::COMPLETED,
  ExperimentState::FAILED,
  ExperimentState::UNKNOWN
};
const char* _kExperimentStateNames[] = {
  "CREATED",
  "VALIDATED",
  "SCHEDULED",
  "LAUNCHED",
  "EXECUTING",
  "CANCELING",
  "CANCELED",
  "SUSPENDED",
  "COMPLETED",
  "FAILED",
  "UNKNOWN"
};
const std::map<int, const char*> _ExperimentState_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(11, _kExperimentStateValues, _kExperimentStateNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kExperimentSearchFieldsValues[] = {
  ExperimentSearchFields::EXPERIMENT_NAME,
  ExperimentSearchFields::EXPERIMENT_DESC,
  ExperimentSearchFields::APPLICATION_ID,
  ExperimentSearchFields::FROM_DATE,
  ExperimentSearchFields::TO_DATE,
  ExperimentSearchFields::STATUS
};
const char* _kExperimentSearchFieldsNames[] = {
  "EXPERIMENT_NAME",
  "EXPERIMENT_DESC",
  "APPLICATION_ID",
  "FROM_DATE",
  "TO_DATE",
  "STATUS"
};
const std::map<int, const char*> _ExperimentSearchFields_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(6, _kExperimentSearchFieldsValues, _kExperimentSearchFieldsNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kWorkflowNodeStateValues[] = {
  WorkflowNodeState::INVOKED,
  WorkflowNodeState::EXECUTING,
  WorkflowNodeState::CANCELING,
  WorkflowNodeState::CANCELED,
  WorkflowNodeState::SUSPENDED,
  WorkflowNodeState::COMPLETED,
  WorkflowNodeState::FAILED,
  WorkflowNodeState::UNKNOWN
};
const char* _kWorkflowNodeStateNames[] = {
  "INVOKED",
  "EXECUTING",
  "CANCELING",
  "CANCELED",
  "SUSPENDED",
  "COMPLETED",
  "FAILED",
  "UNKNOWN"
};
const std::map<int, const char*> _WorkflowNodeState_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kWorkflowNodeStateValues, _kWorkflowNodeStateNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kTaskStateValues[] = {
  TaskState::WAITING,
  TaskState::STARTED,
  TaskState::PRE_PROCESSING,
  TaskState::CONFIGURING_WORKSPACE,
  TaskState::INPUT_DATA_STAGING,
  TaskState::OUTPUT_DATA_STAGING,
  TaskState::POST_PROCESSING,
  TaskState::EXECUTING,
  TaskState::CANCELING,
  TaskState::CANCELED,
  TaskState::COMPLETED,
  TaskState::FAILED,
  TaskState::UNKNOWN
};
const char* _kTaskStateNames[] = {
  "WAITING",
  "STARTED",
  "PRE_PROCESSING",
  "CONFIGURING_WORKSPACE",
  "INPUT_DATA_STAGING",
  "OUTPUT_DATA_STAGING",
  "POST_PROCESSING",
  "EXECUTING",
  "CANCELING",
  "CANCELED",
  "COMPLETED",
  "FAILED",
  "UNKNOWN"
};
const std::map<int, const char*> _TaskState_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(13, _kTaskStateValues, _kTaskStateNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kJobStateValues[] = {
  JobState::SUBMITTED,
  JobState::UN_SUBMITTED,
  JobState::SETUP,
  JobState::QUEUED,
  JobState::ACTIVE,
  JobState::COMPLETE,
  JobState::CANCELING,
  JobState::CANCELED,
  JobState::FAILED,
  JobState::HELD,
  JobState::SUSPENDED,
  JobState::UNKNOWN
};
const char* _kJobStateNames[] = {
  "SUBMITTED",
  "UN_SUBMITTED",
  "SETUP",
  "QUEUED",
  "ACTIVE",
  "COMPLETE",
  "CANCELING",
  "CANCELED",
  "FAILED",
  "HELD",
  "SUSPENDED",
  "UNKNOWN"
};
const std::map<int, const char*> _JobState_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(12, _kJobStateValues, _kJobStateNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kTransferStateValues[] = {
  TransferState::DIRECTORY_SETUP,
  TransferState::UPLOAD,
  TransferState::DOWNLOAD,
  TransferState::ACTIVE,
  TransferState::COMPLETE,
  TransferState::STDOUT_DOWNLOAD,
  TransferState::STDERROR_DOWNLOAD,
  TransferState::CANCELING,
  TransferState::CANCELED,
  TransferState::FAILED,
  TransferState::HELD,
  TransferState::SUSPENDED,
  TransferState::UNKNOWN
};
const char* _kTransferStateNames[] = {
  "DIRECTORY_SETUP",
  "UPLOAD",
  "DOWNLOAD",
  "ACTIVE",
  "COMPLETE",
  "STDOUT_DOWNLOAD",
  "STDERROR_DOWNLOAD",
  "CANCELING",
  "CANCELED",
  "FAILED",
  "HELD",
  "SUSPENDED",
  "UNKNOWN"
};
const std::map<int, const char*> _TransferState_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(13, _kTransferStateValues, _kTransferStateNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kActionableGroupValues[] = {
  ActionableGroup::RESOURCE_ADMINS,
  ActionableGroup::AIRAVATA_ADMINS,
  ActionableGroup::GATEWAYS_ADMINS,
  ActionableGroup::USER,
  ActionableGroup::CANNOT_BE_DETERMINED
};
const char* _kActionableGroupNames[] = {
  "RESOURCE_ADMINS",
  "AIRAVATA_ADMINS",
  "GATEWAYS_ADMINS",
  "USER",
  "CANNOT_BE_DETERMINED"
};
const std::map<int, const char*> _ActionableGroup_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kActionableGroupValues, _kActionableGroupNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kErrorCategoryValues[] = {
  ErrorCategory::FILE_SYSTEM_FAILURE,
  ErrorCategory::APPLICATION_FAILURE,
  ErrorCategory::RESOURCE_NODE_FAILURE,
  ErrorCategory::DISK_FULL,
  ErrorCategory::INSUFFICIENT_ALLOCATION,
  ErrorCategory::SYSTEM_MAINTENANCE,
  ErrorCategory::AIRAVATA_INTERNAL_ERROR,
  ErrorCategory::CANNOT_BE_DETERMINED
};
const char* _kErrorCategoryNames[] = {
  "FILE_SYSTEM_FAILURE",
  "APPLICATION_FAILURE",
  "RESOURCE_NODE_FAILURE",
  "DISK_FULL",
  "INSUFFICIENT_ALLOCATION",
  "SYSTEM_MAINTENANCE",
  "AIRAVATA_INTERNAL_ERROR",
  "CANNOT_BE_DETERMINED"
};
const std::map<int, const char*> _ErrorCategory_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kErrorCategoryValues, _kErrorCategoryNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kCorrectiveActionValues[] = {
  CorrectiveAction::RETRY_SUBMISSION,
  CorrectiveAction::CONTACT_SUPPORT,
  CorrectiveAction::CANNOT_BE_DETERMINED
};
const char* _kCorrectiveActionNames[] = {
  "RETRY_SUBMISSION",
  "CONTACT_SUPPORT",
  "CANNOT_BE_DETERMINED"
};
const std::map<int, const char*> _CorrectiveAction_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kCorrectiveActionValues, _kCorrectiveActionNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kExecutionUnitValues[] = {
  ExecutionUnit::INPUT,
  ExecutionUnit::APPLICATION,
  ExecutionUnit::OUTPUT,
  ExecutionUnit::OTHER
};
const char* _kExecutionUnitNames[] = {
  "INPUT",
  "APPLICATION",
  "OUTPUT",
  "OTHER"
};
const std::map<int, const char*> _ExecutionUnit_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kExecutionUnitValues, _kExecutionUnitNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

const char* ExperimentStatus::ascii_fingerprint = "1662AAADFABAB647546029B578B3B69B";
const uint8_t ExperimentStatus::binary_fingerprint[16] = {0x16,0x62,0xAA,0xAD,0xFA,0xBA,0xB6,0x47,0x54,0x60,0x29,0xB5,0x78,0xB3,0xB6,0x9B};

uint32_t ExperimentStatus::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentState = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->experimentState = (ExperimentState::type)ecast0;
          isset_experimentState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->timeOfStateChange);
          this->__isset.timeOfStateChange = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentStatus::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ExperimentStatus");

  xfer += oprot->writeFieldBegin("experimentState", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->experimentState);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.timeOfStateChange) {
    xfer += oprot->writeFieldBegin("timeOfStateChange", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->timeOfStateChange);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentStatus &a, ExperimentStatus &b) {
  using ::std::swap;
  swap(a.experimentState, b.experimentState);
  swap(a.timeOfStateChange, b.timeOfStateChange);
  swap(a.__isset, b.__isset);
}

const char* WorkflowNodeStatus::ascii_fingerprint = "1662AAADFABAB647546029B578B3B69B";
const uint8_t WorkflowNodeStatus::binary_fingerprint[16] = {0x16,0x62,0xAA,0xAD,0xFA,0xBA,0xB6,0x47,0x54,0x60,0x29,0xB5,0x78,0xB3,0xB6,0x9B};

uint32_t WorkflowNodeStatus::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_workflowNodeState = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast1;
          xfer += iprot->readI32(ecast1);
          this->workflowNodeState = (WorkflowNodeState::type)ecast1;
          isset_workflowNodeState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->timeOfStateChange);
          this->__isset.timeOfStateChange = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_workflowNodeState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t WorkflowNodeStatus::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("WorkflowNodeStatus");

  xfer += oprot->writeFieldBegin("workflowNodeState", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->workflowNodeState);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.timeOfStateChange) {
    xfer += oprot->writeFieldBegin("timeOfStateChange", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->timeOfStateChange);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(WorkflowNodeStatus &a, WorkflowNodeStatus &b) {
  using ::std::swap;
  swap(a.workflowNodeState, b.workflowNodeState);
  swap(a.timeOfStateChange, b.timeOfStateChange);
  swap(a.__isset, b.__isset);
}

const char* TaskStatus::ascii_fingerprint = "1662AAADFABAB647546029B578B3B69B";
const uint8_t TaskStatus::binary_fingerprint[16] = {0x16,0x62,0xAA,0xAD,0xFA,0xBA,0xB6,0x47,0x54,0x60,0x29,0xB5,0x78,0xB3,0xB6,0x9B};

uint32_t TaskStatus::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_executionState = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast2;
          xfer += iprot->readI32(ecast2);
          this->executionState = (TaskState::type)ecast2;
          isset_executionState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->timeOfStateChange);
          this->__isset.timeOfStateChange = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_executionState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskStatus::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskStatus");

  xfer += oprot->writeFieldBegin("executionState", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->executionState);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.timeOfStateChange) {
    xfer += oprot->writeFieldBegin("timeOfStateChange", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->timeOfStateChange);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskStatus &a, TaskStatus &b) {
  using ::std::swap;
  swap(a.executionState, b.executionState);
  swap(a.timeOfStateChange, b.timeOfStateChange);
  swap(a.__isset, b.__isset);
}

const char* JobStatus::ascii_fingerprint = "1662AAADFABAB647546029B578B3B69B";
const uint8_t JobStatus::binary_fingerprint[16] = {0x16,0x62,0xAA,0xAD,0xFA,0xBA,0xB6,0x47,0x54,0x60,0x29,0xB5,0x78,0xB3,0xB6,0x9B};

uint32_t JobStatus::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobState = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast3;
          xfer += iprot->readI32(ecast3);
          this->jobState = (JobState::type)ecast3;
          isset_jobState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->timeOfStateChange);
          this->__isset.timeOfStateChange = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobStatus::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("JobStatus");

  xfer += oprot->writeFieldBegin("jobState", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->jobState);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.timeOfStateChange) {
    xfer += oprot->writeFieldBegin("timeOfStateChange", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->timeOfStateChange);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobStatus &a, JobStatus &b) {
  using ::std::swap;
  swap(a.jobState, b.jobState);
  swap(a.timeOfStateChange, b.timeOfStateChange);
  swap(a.__isset, b.__isset);
}

const char* TransferStatus::ascii_fingerprint = "1662AAADFABAB647546029B578B3B69B";
const uint8_t TransferStatus::binary_fingerprint[16] = {0x16,0x62,0xAA,0xAD,0xFA,0xBA,0xB6,0x47,0x54,0x60,0x29,0xB5,0x78,0xB3,0xB6,0x9B};

uint32_t TransferStatus::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_transferState = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast4;
          xfer += iprot->readI32(ecast4);
          this->transferState = (TransferState::type)ecast4;
          isset_transferState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->timeOfStateChange);
          this->__isset.timeOfStateChange = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_transferState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TransferStatus::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TransferStatus");

  xfer += oprot->writeFieldBegin("transferState", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->transferState);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.timeOfStateChange) {
    xfer += oprot->writeFieldBegin("timeOfStateChange", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->timeOfStateChange);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TransferStatus &a, TransferStatus &b) {
  using ::std::swap;
  swap(a.transferState, b.transferState);
  swap(a.timeOfStateChange, b.timeOfStateChange);
  swap(a.__isset, b.__isset);
}

const char* ApplicationStatus::ascii_fingerprint = "E17E126D15049701494262EE3246F603";
const uint8_t ApplicationStatus::binary_fingerprint[16] = {0xE1,0x7E,0x12,0x6D,0x15,0x04,0x97,0x01,0x49,0x42,0x62,0xEE,0x32,0x46,0xF6,0x03};

uint32_t ApplicationStatus::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_applicationState = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationState);
          isset_applicationState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->timeOfStateChange);
          this->__isset.timeOfStateChange = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_applicationState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ApplicationStatus::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ApplicationStatus");

  xfer += oprot->writeFieldBegin("applicationState", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->applicationState);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.timeOfStateChange) {
    xfer += oprot->writeFieldBegin("timeOfStateChange", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->timeOfStateChange);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ApplicationStatus &a, ApplicationStatus &b) {
  using ::std::swap;
  swap(a.applicationState, b.applicationState);
  swap(a.timeOfStateChange, b.timeOfStateChange);
  swap(a.__isset, b.__isset);
}

const char* ComputationalResourceScheduling::ascii_fingerprint = "F43E914A611D39345BCC729678C1C696";
const uint8_t ComputationalResourceScheduling::binary_fingerprint[16] = {0xF4,0x3E,0x91,0x4A,0x61,0x1D,0x39,0x34,0x5B,0xCC,0x72,0x96,0x78,0xC1,0xC6,0x96};

uint32_t ComputationalResourceScheduling::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->resourceHostId);
          this->__isset.resourceHostId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->totalCPUCount);
          this->__isset.totalCPUCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->nodeCount);
          this->__isset.nodeCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->numberOfThreads);
          this->__isset.numberOfThreads = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->queueName);
          this->__isset.queueName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->wallTimeLimit);
          this->__isset.wallTimeLimit = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->jobStartTime);
          this->__isset.jobStartTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->totalPhysicalMemory);
          this->__isset.totalPhysicalMemory = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->computationalProjectAccount);
          this->__isset.computationalProjectAccount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->chassisName);
          this->__isset.chassisName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t ComputationalResourceScheduling::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ComputationalResourceScheduling");

  if (this->__isset.resourceHostId) {
    xfer += oprot->writeFieldBegin("resourceHostId", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeString(this->resourceHostId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.totalCPUCount) {
    xfer += oprot->writeFieldBegin("totalCPUCount", ::apache::thrift::protocol::T_I32, 2);
    xfer += oprot->writeI32(this->totalCPUCount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.nodeCount) {
    xfer += oprot->writeFieldBegin("nodeCount", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(this->nodeCount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.numberOfThreads) {
    xfer += oprot->writeFieldBegin("numberOfThreads", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->numberOfThreads);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.queueName) {
    xfer += oprot->writeFieldBegin("queueName", ::apache::thrift::protocol::T_STRING, 5);
    xfer += oprot->writeString(this->queueName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.wallTimeLimit) {
    xfer += oprot->writeFieldBegin("wallTimeLimit", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32(this->wallTimeLimit);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobStartTime) {
    xfer += oprot->writeFieldBegin("jobStartTime", ::apache::thrift::protocol::T_I32, 7);
    xfer += oprot->writeI32(this->jobStartTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.totalPhysicalMemory) {
    xfer += oprot->writeFieldBegin("totalPhysicalMemory", ::apache::thrift::protocol::T_I32, 8);
    xfer += oprot->writeI32(this->totalPhysicalMemory);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.computationalProjectAccount) {
    xfer += oprot->writeFieldBegin("computationalProjectAccount", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->computationalProjectAccount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.chassisName) {
    xfer += oprot->writeFieldBegin("chassisName", ::apache::thrift::protocol::T_STRING, 10);
    xfer += oprot->writeString(this->chassisName);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ComputationalResourceScheduling &a, ComputationalResourceScheduling &b) {
  using ::std::swap;
  swap(a.resourceHostId, b.resourceHostId);
  swap(a.totalCPUCount, b.totalCPUCount);
  swap(a.nodeCount, b.nodeCount);
  swap(a.numberOfThreads, b.numberOfThreads);
  swap(a.queueName, b.queueName);
  swap(a.wallTimeLimit, b.wallTimeLimit);
  swap(a.jobStartTime, b.jobStartTime);
  swap(a.totalPhysicalMemory, b.totalPhysicalMemory);
  swap(a.computationalProjectAccount, b.computationalProjectAccount);
  swap(a.chassisName, b.chassisName);
  swap(a.__isset, b.__isset);
}

const char* AdvancedInputDataHandling::ascii_fingerprint = "6139039875942E8B25C483838DD664B7";
const uint8_t AdvancedInputDataHandling::binary_fingerprint[16] = {0x61,0x39,0x03,0x98,0x75,0x94,0x2E,0x8B,0x25,0xC4,0x83,0x83,0x8D,0xD6,0x64,0xB7};

uint32_t AdvancedInputDataHandling::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->stageInputFilesToWorkingDir);
          this->__isset.stageInputFilesToWorkingDir = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->parentWorkingDirectory);
          this->__isset.parentWorkingDirectory = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->uniqueWorkingDirectory);
          this->__isset.uniqueWorkingDirectory = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->cleanUpWorkingDirAfterJob);
          this->__isset.cleanUpWorkingDirAfterJob = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t AdvancedInputDataHandling::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("AdvancedInputDataHandling");

  if (this->__isset.stageInputFilesToWorkingDir) {
    xfer += oprot->writeFieldBegin("stageInputFilesToWorkingDir", ::apache::thrift::protocol::T_BOOL, 1);
    xfer += oprot->writeBool(this->stageInputFilesToWorkingDir);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.parentWorkingDirectory) {
    xfer += oprot->writeFieldBegin("parentWorkingDirectory", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->parentWorkingDirectory);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.uniqueWorkingDirectory) {
    xfer += oprot->writeFieldBegin("uniqueWorkingDirectory", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->uniqueWorkingDirectory);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.cleanUpWorkingDirAfterJob) {
    xfer += oprot->writeFieldBegin("cleanUpWorkingDirAfterJob", ::apache::thrift::protocol::T_BOOL, 4);
    xfer += oprot->writeBool(this->cleanUpWorkingDirAfterJob);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(AdvancedInputDataHandling &a, AdvancedInputDataHandling &b) {
  using ::std::swap;
  swap(a.stageInputFilesToWorkingDir, b.stageInputFilesToWorkingDir);
  swap(a.parentWorkingDirectory, b.parentWorkingDirectory);
  swap(a.uniqueWorkingDirectory, b.uniqueWorkingDirectory);
  swap(a.cleanUpWorkingDirAfterJob, b.cleanUpWorkingDirAfterJob);
  swap(a.__isset, b.__isset);
}

const char* AdvancedOutputDataHandling::ascii_fingerprint = "6EC898D3B5ECFF21200795BD22F73CD2";
const uint8_t AdvancedOutputDataHandling::binary_fingerprint[16] = {0x6E,0xC8,0x98,0xD3,0xB5,0xEC,0xFF,0x21,0x20,0x07,0x95,0xBD,0x22,0xF7,0x3C,0xD2};

uint32_t AdvancedOutputDataHandling::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->outputDataDir);
          this->__isset.outputDataDir = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataRegistryURL);
          this->__isset.dataRegistryURL = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->persistOutputData);
          this->__isset.persistOutputData = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t AdvancedOutputDataHandling::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("AdvancedOutputDataHandling");

  if (this->__isset.outputDataDir) {
    xfer += oprot->writeFieldBegin("outputDataDir", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->outputDataDir);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dataRegistryURL) {
    xfer += oprot->writeFieldBegin("dataRegistryURL", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->dataRegistryURL);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.persistOutputData) {
    xfer += oprot->writeFieldBegin("persistOutputData", ::apache::thrift::protocol::T_BOOL, 4);
    xfer += oprot->writeBool(this->persistOutputData);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(AdvancedOutputDataHandling &a, AdvancedOutputDataHandling &b) {
  using ::std::swap;
  swap(a.outputDataDir, b.outputDataDir);
  swap(a.dataRegistryURL, b.dataRegistryURL);
  swap(a.persistOutputData, b.persistOutputData);
  swap(a.__isset, b.__isset);
}

const char* QualityOfServiceParams::ascii_fingerprint = "35985D966603A273E8D7132543B44873";
const uint8_t QualityOfServiceParams::binary_fingerprint[16] = {0x35,0x98,0x5D,0x96,0x66,0x03,0xA2,0x73,0xE8,0xD7,0x13,0x25,0x43,0xB4,0x48,0x73};

uint32_t QualityOfServiceParams::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->startExecutionAt);
          this->__isset.startExecutionAt = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->executeBefore);
          this->__isset.executeBefore = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->numberofRetries);
          this->__isset.numberofRetries = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t QualityOfServiceParams::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("QualityOfServiceParams");

  if (this->__isset.startExecutionAt) {
    xfer += oprot->writeFieldBegin("startExecutionAt", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeString(this->startExecutionAt);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.executeBefore) {
    xfer += oprot->writeFieldBegin("executeBefore", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->executeBefore);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.numberofRetries) {
    xfer += oprot->writeFieldBegin("numberofRetries", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(this->numberofRetries);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(QualityOfServiceParams &a, QualityOfServiceParams &b) {
  using ::std::swap;
  swap(a.startExecutionAt, b.startExecutionAt);
  swap(a.executeBefore, b.executeBefore);
  swap(a.numberofRetries, b.numberofRetries);
  swap(a.__isset, b.__isset);
}

const char* UserConfigurationData::ascii_fingerprint = "0EA9FCA690C445780E02BCAC89B1D820";
const uint8_t UserConfigurationData::binary_fingerprint[16] = {0x0E,0xA9,0xFC,0xA6,0x90,0xC4,0x45,0x78,0x0E,0x02,0xBC,0xAC,0x89,0xB1,0xD8,0x20};

uint32_t UserConfigurationData::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_airavataAutoSchedule = false;
  bool isset_overrideManualScheduledParams = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->airavataAutoSchedule);
          isset_airavataAutoSchedule = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->overrideManualScheduledParams);
          isset_overrideManualScheduledParams = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->shareExperimentPublicly);
          this->__isset.shareExperimentPublicly = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->computationalResourceScheduling.read(iprot);
          this->__isset.computationalResourceScheduling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->advanceInputDataHandling.read(iprot);
          this->__isset.advanceInputDataHandling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->advanceOutputDataHandling.read(iprot);
          this->__isset.advanceOutputDataHandling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->qosParams.read(iprot);
          this->__isset.qosParams = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->throttleResources);
          this->__isset.throttleResources = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userDN);
          this->__isset.userDN = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->generateCert);
          this->__isset.generateCert = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_airavataAutoSchedule)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_overrideManualScheduledParams)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UserConfigurationData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("UserConfigurationData");

  xfer += oprot->writeFieldBegin("airavataAutoSchedule", ::apache::thrift::protocol::T_BOOL, 1);
  xfer += oprot->writeBool(this->airavataAutoSchedule);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("overrideManualScheduledParams", ::apache::thrift::protocol::T_BOOL, 2);
  xfer += oprot->writeBool(this->overrideManualScheduledParams);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.shareExperimentPublicly) {
    xfer += oprot->writeFieldBegin("shareExperimentPublicly", ::apache::thrift::protocol::T_BOOL, 3);
    xfer += oprot->writeBool(this->shareExperimentPublicly);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.computationalResourceScheduling) {
    xfer += oprot->writeFieldBegin("computationalResourceScheduling", ::apache::thrift::protocol::T_STRUCT, 4);
    xfer += this->computationalResourceScheduling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.advanceInputDataHandling) {
    xfer += oprot->writeFieldBegin("advanceInputDataHandling", ::apache::thrift::protocol::T_STRUCT, 5);
    xfer += this->advanceInputDataHandling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.advanceOutputDataHandling) {
    xfer += oprot->writeFieldBegin("advanceOutputDataHandling", ::apache::thrift::protocol::T_STRUCT, 6);
    xfer += this->advanceOutputDataHandling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.qosParams) {
    xfer += oprot->writeFieldBegin("qosParams", ::apache::thrift::protocol::T_STRUCT, 7);
    xfer += this->qosParams.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.throttleResources) {
    xfer += oprot->writeFieldBegin("throttleResources", ::apache::thrift::protocol::T_BOOL, 8);
    xfer += oprot->writeBool(this->throttleResources);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.userDN) {
    xfer += oprot->writeFieldBegin("userDN", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->userDN);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.generateCert) {
    xfer += oprot->writeFieldBegin("generateCert", ::apache::thrift::protocol::T_BOOL, 10);
    xfer += oprot->writeBool(this->generateCert);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UserConfigurationData &a, UserConfigurationData &b) {
  using ::std::swap;
  swap(a.airavataAutoSchedule, b.airavataAutoSchedule);
  swap(a.overrideManualScheduledParams, b.overrideManualScheduledParams);
  swap(a.shareExperimentPublicly, b.shareExperimentPublicly);
  swap(a.computationalResourceScheduling, b.computationalResourceScheduling);
  swap(a.advanceInputDataHandling, b.advanceInputDataHandling);
  swap(a.advanceOutputDataHandling, b.advanceOutputDataHandling);
  swap(a.qosParams, b.qosParams);
  swap(a.throttleResources, b.throttleResources);
  swap(a.userDN, b.userDN);
  swap(a.generateCert, b.generateCert);
  swap(a.__isset, b.__isset);
}

const char* ErrorDetails::ascii_fingerprint = "170CA6E79EB283F31417B9D68071DA33";
const uint8_t ErrorDetails::binary_fingerprint[16] = {0x17,0x0C,0xA6,0xE7,0x9E,0xB2,0x83,0xF3,0x14,0x17,0xB9,0xD6,0x80,0x71,0xDA,0x33};

uint32_t ErrorDetails::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_errorID = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->errorID);
          isset_errorID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->actualErrorMessage);
          this->__isset.actualErrorMessage = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userFriendlyMessage);
          this->__isset.userFriendlyMessage = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast5;
          xfer += iprot->readI32(ecast5);
          this->errorCategory = (ErrorCategory::type)ecast5;
          this->__isset.errorCategory = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->transientOrPersistent);
          this->__isset.transientOrPersistent = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast6;
          xfer += iprot->readI32(ecast6);
          this->correctiveAction = (CorrectiveAction::type)ecast6;
          this->__isset.correctiveAction = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast7;
          xfer += iprot->readI32(ecast7);
          this->actionableGroup = (ActionableGroup::type)ecast7;
          this->__isset.actionableGroup = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->rootCauseErrorIdList.clear();
            uint32_t _size8;
            ::apache::thrift::protocol::TType _etype11;
            xfer += iprot->readListBegin(_etype11, _size8);
            this->rootCauseErrorIdList.resize(_size8);
            uint32_t _i12;
            for (_i12 = 0; _i12 < _size8; ++_i12)
            {
              xfer += iprot->readString(this->rootCauseErrorIdList[_i12]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.rootCauseErrorIdList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_errorID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ErrorDetails::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ErrorDetails");

  xfer += oprot->writeFieldBegin("errorID", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->errorID);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.actualErrorMessage) {
    xfer += oprot->writeFieldBegin("actualErrorMessage", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->actualErrorMessage);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.userFriendlyMessage) {
    xfer += oprot->writeFieldBegin("userFriendlyMessage", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->userFriendlyMessage);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.errorCategory) {
    xfer += oprot->writeFieldBegin("errorCategory", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32((int32_t)this->errorCategory);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.transientOrPersistent) {
    xfer += oprot->writeFieldBegin("transientOrPersistent", ::apache::thrift::protocol::T_BOOL, 6);
    xfer += oprot->writeBool(this->transientOrPersistent);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.correctiveAction) {
    xfer += oprot->writeFieldBegin("correctiveAction", ::apache::thrift::protocol::T_I32, 7);
    xfer += oprot->writeI32((int32_t)this->correctiveAction);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.actionableGroup) {
    xfer += oprot->writeFieldBegin("actionableGroup", ::apache::thrift::protocol::T_I32, 8);
    xfer += oprot->writeI32((int32_t)this->actionableGroup);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.rootCauseErrorIdList) {
    xfer += oprot->writeFieldBegin("rootCauseErrorIdList", ::apache::thrift::protocol::T_LIST, 9);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->rootCauseErrorIdList.size()));
      std::vector<std::string> ::const_iterator _iter13;
      for (_iter13 = this->rootCauseErrorIdList.begin(); _iter13 != this->rootCauseErrorIdList.end(); ++_iter13)
      {
        xfer += oprot->writeString((*_iter13));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ErrorDetails &a, ErrorDetails &b) {
  using ::std::swap;
  swap(a.errorID, b.errorID);
  swap(a.creationTime, b.creationTime);
  swap(a.actualErrorMessage, b.actualErrorMessage);
  swap(a.userFriendlyMessage, b.userFriendlyMessage);
  swap(a.errorCategory, b.errorCategory);
  swap(a.transientOrPersistent, b.transientOrPersistent);
  swap(a.correctiveAction, b.correctiveAction);
  swap(a.actionableGroup, b.actionableGroup);
  swap(a.rootCauseErrorIdList, b.rootCauseErrorIdList);
  swap(a.__isset, b.__isset);
}

const char* JobDetails::ascii_fingerprint = "114EFEA8CA07DC82CC947D9F47547394";
const uint8_t JobDetails::binary_fingerprint[16] = {0x11,0x4E,0xFE,0xA8,0xCA,0x07,0xDC,0x82,0xCC,0x94,0x7D,0x9F,0x47,0x54,0x73,0x94};

uint32_t JobDetails::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobID = false;
  bool isset_jobDescription = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobID);
          isset_jobID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobDescription);
          isset_jobDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->jobStatus.read(iprot);
          this->__isset.jobStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->applicationStatus.read(iprot);
          this->__isset.applicationStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->errors.clear();
            uint32_t _size14;
            ::apache::thrift::protocol::TType _etype17;
            xfer += iprot->readListBegin(_etype17, _size14);
            this->errors.resize(_size14);
            uint32_t _i18;
            for (_i18 = 0; _i18 < _size14; ++_i18)
            {
              xfer += this->errors[_i18].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.errors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->computeResourceConsumed);
          this->__isset.computeResourceConsumed = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobName);
          this->__isset.jobName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workingDir);
          this->__isset.workingDir = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobDescription)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobDetails::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("JobDetails");

  xfer += oprot->writeFieldBegin("jobID", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobID);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobDescription", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->jobDescription);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 3);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobStatus) {
    xfer += oprot->writeFieldBegin("jobStatus", ::apache::thrift::protocol::T_STRUCT, 4);
    xfer += this->jobStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationStatus) {
    xfer += oprot->writeFieldBegin("applicationStatus", ::apache::thrift::protocol::T_STRUCT, 5);
    xfer += this->applicationStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.errors) {
    xfer += oprot->writeFieldBegin("errors", ::apache::thrift::protocol::T_LIST, 6);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->errors.size()));
      std::vector<ErrorDetails> ::const_iterator _iter19;
      for (_iter19 = this->errors.begin(); _iter19 != this->errors.end(); ++_iter19)
      {
        xfer += (*_iter19).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.computeResourceConsumed) {
    xfer += oprot->writeFieldBegin("computeResourceConsumed", ::apache::thrift::protocol::T_STRING, 7);
    xfer += oprot->writeString(this->computeResourceConsumed);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobName) {
    xfer += oprot->writeFieldBegin("jobName", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->jobName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.workingDir) {
    xfer += oprot->writeFieldBegin("workingDir", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->workingDir);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobDetails &a, JobDetails &b) {
  using ::std::swap;
  swap(a.jobID, b.jobID);
  swap(a.jobDescription, b.jobDescription);
  swap(a.creationTime, b.creationTime);
  swap(a.jobStatus, b.jobStatus);
  swap(a.applicationStatus, b.applicationStatus);
  swap(a.errors, b.errors);
  swap(a.computeResourceConsumed, b.computeResourceConsumed);
  swap(a.jobName, b.jobName);
  swap(a.workingDir, b.workingDir);
  swap(a.__isset, b.__isset);
}

const char* DataTransferDetails::ascii_fingerprint = "40D4FEC20E3B334AEEBA92DA2AB9E91E";
const uint8_t DataTransferDetails::binary_fingerprint[16] = {0x40,0xD4,0xFE,0xC2,0x0E,0x3B,0x33,0x4A,0xEE,0xBA,0x92,0xDA,0x2A,0xB9,0xE9,0x1E};

uint32_t DataTransferDetails::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_transferID = false;
  bool isset_transferDescription = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->transferID);
          isset_transferID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->transferDescription);
          isset_transferDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->transferStatus.read(iprot);
          this->__isset.transferStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_transferID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_transferDescription)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataTransferDetails::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("DataTransferDetails");

  xfer += oprot->writeFieldBegin("transferID", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->transferID);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("transferDescription", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->transferDescription);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.transferStatus) {
    xfer += oprot->writeFieldBegin("transferStatus", ::apache::thrift::protocol::T_STRUCT, 4);
    xfer += this->transferStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataTransferDetails &a, DataTransferDetails &b) {
  using ::std::swap;
  swap(a.transferID, b.transferID);
  swap(a.creationTime, b.creationTime);
  swap(a.transferDescription, b.transferDescription);
  swap(a.transferStatus, b.transferStatus);
  swap(a.__isset, b.__isset);
}

const char* TaskDetails::ascii_fingerprint = "B7529305C4CBCDA0A164DA14865F0E67";
const uint8_t TaskDetails::binary_fingerprint[16] = {0xB7,0x52,0x93,0x05,0xC4,0xCB,0xCD,0xA0,0xA1,0x64,0xDA,0x14,0x86,0x5F,0x0E,0x67};

uint32_t TaskDetails::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_taskID = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskID);
          isset_taskID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationId);
          this->__isset.applicationId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationVersion);
          this->__isset.applicationVersion = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationDeploymentId);
          this->__isset.applicationDeploymentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->applicationInputs.clear();
            uint32_t _size20;
            ::apache::thrift::protocol::TType _etype23;
            xfer += iprot->readListBegin(_etype23, _size20);
            this->applicationInputs.resize(_size20);
            uint32_t _i24;
            for (_i24 = 0; _i24 < _size20; ++_i24)
            {
              xfer += this->applicationInputs[_i24].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.applicationInputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->applicationOutputs.clear();
            uint32_t _size25;
            ::apache::thrift::protocol::TType _etype28;
            xfer += iprot->readListBegin(_etype28, _size25);
            this->applicationOutputs.resize(_size25);
            uint32_t _i29;
            for (_i29 = 0; _i29 < _size25; ++_i29)
            {
              xfer += this->applicationOutputs[_i29].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.applicationOutputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskScheduling.read(iprot);
          this->__isset.taskScheduling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->advancedInputDataHandling.read(iprot);
          this->__isset.advancedInputDataHandling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->advancedOutputDataHandling.read(iprot);
          this->__isset.advancedOutputDataHandling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskStatus.read(iprot);
          this->__isset.taskStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->jobDetailsList.clear();
            uint32_t _size30;
            ::apache::thrift::protocol::TType _etype33;
            xfer += iprot->readListBegin(_etype33, _size30);
            this->jobDetailsList.resize(_size30);
            uint32_t _i34;
            for (_i34 = 0; _i34 < _size30; ++_i34)
            {
              xfer += this->jobDetailsList[_i34].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.jobDetailsList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->dataTransferDetailsList.clear();
            uint32_t _size35;
            ::apache::thrift::protocol::TType _etype38;
            xfer += iprot->readListBegin(_etype38, _size35);
            this->dataTransferDetailsList.resize(_size35);
            uint32_t _i39;
            for (_i39 = 0; _i39 < _size35; ++_i39)
            {
              xfer += this->dataTransferDetailsList[_i39].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.dataTransferDetailsList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->errors.clear();
            uint32_t _size40;
            ::apache::thrift::protocol::TType _etype43;
            xfer += iprot->readListBegin(_etype43, _size40);
            this->errors.resize(_size40);
            uint32_t _i44;
            for (_i44 = 0; _i44 < _size40; ++_i44)
            {
              xfer += this->errors[_i44].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.errors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->enableEmailNotification);
          this->__isset.enableEmailNotification = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->emailAddresses.clear();
            uint32_t _size45;
            ::apache::thrift::protocol::TType _etype48;
            xfer += iprot->readListBegin(_etype48, _size45);
            this->emailAddresses.resize(_size45);
            uint32_t _i49;
            for (_i49 = 0; _i49 < _size45; ++_i49)
            {
              xfer += iprot->readString(this->emailAddresses[_i49]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.emailAddresses = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_taskID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskDetails::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskDetails");

  xfer += oprot->writeFieldBegin("taskID", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->taskID);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationId) {
    xfer += oprot->writeFieldBegin("applicationId", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->applicationId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationVersion) {
    xfer += oprot->writeFieldBegin("applicationVersion", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->applicationVersion);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationDeploymentId) {
    xfer += oprot->writeFieldBegin("applicationDeploymentId", ::apache::thrift::protocol::T_STRING, 5);
    xfer += oprot->writeString(this->applicationDeploymentId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationInputs) {
    xfer += oprot->writeFieldBegin("applicationInputs", ::apache::thrift::protocol::T_LIST, 6);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->applicationInputs.size()));
      std::vector< ::apache::airavata::model::appcatalog::appinterface::InputDataObjectType> ::const_iterator _iter50;
      for (_iter50 = this->applicationInputs.begin(); _iter50 != this->applicationInputs.end(); ++_iter50)
      {
        xfer += (*_iter50).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationOutputs) {
    xfer += oprot->writeFieldBegin("applicationOutputs", ::apache::thrift::protocol::T_LIST, 7);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->applicationOutputs.size()));
      std::vector< ::apache::airavata::model::appcatalog::appinterface::OutputDataObjectType> ::const_iterator _iter51;
      for (_iter51 = this->applicationOutputs.begin(); _iter51 != this->applicationOutputs.end(); ++_iter51)
      {
        xfer += (*_iter51).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.taskScheduling) {
    xfer += oprot->writeFieldBegin("taskScheduling", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->taskScheduling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.advancedInputDataHandling) {
    xfer += oprot->writeFieldBegin("advancedInputDataHandling", ::apache::thrift::protocol::T_STRUCT, 9);
    xfer += this->advancedInputDataHandling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.advancedOutputDataHandling) {
    xfer += oprot->writeFieldBegin("advancedOutputDataHandling", ::apache::thrift::protocol::T_STRUCT, 10);
    xfer += this->advancedOutputDataHandling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.taskStatus) {
    xfer += oprot->writeFieldBegin("taskStatus", ::apache::thrift::protocol::T_STRUCT, 11);
    xfer += this->taskStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobDetailsList) {
    xfer += oprot->writeFieldBegin("jobDetailsList", ::apache::thrift::protocol::T_LIST, 12);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->jobDetailsList.size()));
      std::vector<JobDetails> ::const_iterator _iter52;
      for (_iter52 = this->jobDetailsList.begin(); _iter52 != this->jobDetailsList.end(); ++_iter52)
      {
        xfer += (*_iter52).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dataTransferDetailsList) {
    xfer += oprot->writeFieldBegin("dataTransferDetailsList", ::apache::thrift::protocol::T_LIST, 13);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->dataTransferDetailsList.size()));
      std::vector<DataTransferDetails> ::const_iterator _iter53;
      for (_iter53 = this->dataTransferDetailsList.begin(); _iter53 != this->dataTransferDetailsList.end(); ++_iter53)
      {
        xfer += (*_iter53).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.errors) {
    xfer += oprot->writeFieldBegin("errors", ::apache::thrift::protocol::T_LIST, 14);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->errors.size()));
      std::vector<ErrorDetails> ::const_iterator _iter54;
      for (_iter54 = this->errors.begin(); _iter54 != this->errors.end(); ++_iter54)
      {
        xfer += (*_iter54).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.enableEmailNotification) {
    xfer += oprot->writeFieldBegin("enableEmailNotification", ::apache::thrift::protocol::T_BOOL, 15);
    xfer += oprot->writeBool(this->enableEmailNotification);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.emailAddresses) {
    xfer += oprot->writeFieldBegin("emailAddresses", ::apache::thrift::protocol::T_LIST, 16);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->emailAddresses.size()));
      std::vector<std::string> ::const_iterator _iter55;
      for (_iter55 = this->emailAddresses.begin(); _iter55 != this->emailAddresses.end(); ++_iter55)
      {
        xfer += oprot->writeString((*_iter55));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskDetails &a, TaskDetails &b) {
  using ::std::swap;
  swap(a.taskID, b.taskID);
  swap(a.creationTime, b.creationTime);
  swap(a.applicationId, b.applicationId);
  swap(a.applicationVersion, b.applicationVersion);
  swap(a.applicationDeploymentId, b.applicationDeploymentId);
  swap(a.applicationInputs, b.applicationInputs);
  swap(a.applicationOutputs, b.applicationOutputs);
  swap(a.taskScheduling, b.taskScheduling);
  swap(a.advancedInputDataHandling, b.advancedInputDataHandling);
  swap(a.advancedOutputDataHandling, b.advancedOutputDataHandling);
  swap(a.taskStatus, b.taskStatus);
  swap(a.jobDetailsList, b.jobDetailsList);
  swap(a.dataTransferDetailsList, b.dataTransferDetailsList);
  swap(a.errors, b.errors);
  swap(a.enableEmailNotification, b.enableEmailNotification);
  swap(a.emailAddresses, b.emailAddresses);
  swap(a.__isset, b.__isset);
}

const char* WorkflowNodeDetails::ascii_fingerprint = "EB2D51CB4EF4984664FB9C47591EFA8D";
const uint8_t WorkflowNodeDetails::binary_fingerprint[16] = {0xEB,0x2D,0x51,0xCB,0x4E,0xF4,0x98,0x46,0x64,0xFB,0x9C,0x47,0x59,0x1E,0xFA,0x8D};

uint32_t WorkflowNodeDetails::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_nodeInstanceId = false;
  bool isset_nodeName = false;
  bool isset_executionUnit = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->nodeInstanceId);
          isset_nodeInstanceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->nodeName);
          isset_nodeName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast56;
          xfer += iprot->readI32(ecast56);
          this->executionUnit = (ExecutionUnit::type)ecast56;
          isset_executionUnit = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->executionUnitData);
          this->__isset.executionUnitData = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->nodeInputs.clear();
            uint32_t _size57;
            ::apache::thrift::protocol::TType _etype60;
            xfer += iprot->readListBegin(_etype60, _size57);
            this->nodeInputs.resize(_size57);
            uint32_t _i61;
            for (_i61 = 0; _i61 < _size57; ++_i61)
            {
              xfer += this->nodeInputs[_i61].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.nodeInputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->nodeOutputs.clear();
            uint32_t _size62;
            ::apache::thrift::protocol::TType _etype65;
            xfer += iprot->readListBegin(_etype65, _size62);
            this->nodeOutputs.resize(_size62);
            uint32_t _i66;
            for (_i66 = 0; _i66 < _size62; ++_i66)
            {
              xfer += this->nodeOutputs[_i66].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.nodeOutputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->workflowNodeStatus.read(iprot);
          this->__isset.workflowNodeStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->taskDetailsList.clear();
            uint32_t _size67;
            ::apache::thrift::protocol::TType _etype70;
            xfer += iprot->readListBegin(_etype70, _size67);
            this->taskDetailsList.resize(_size67);
            uint32_t _i71;
            for (_i71 = 0; _i71 < _size67; ++_i71)
            {
              xfer += this->taskDetailsList[_i71].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.taskDetailsList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->errors.clear();
            uint32_t _size72;
            ::apache::thrift::protocol::TType _etype75;
            xfer += iprot->readListBegin(_etype75, _size72);
            this->errors.resize(_size72);
            uint32_t _i76;
            for (_i76 = 0; _i76 < _size72; ++_i76)
            {
              xfer += this->errors[_i76].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.errors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_nodeInstanceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_nodeName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_executionUnit)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t WorkflowNodeDetails::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("WorkflowNodeDetails");

  xfer += oprot->writeFieldBegin("nodeInstanceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->nodeInstanceId);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 2);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("nodeName", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->nodeName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("executionUnit", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32((int32_t)this->executionUnit);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.executionUnitData) {
    xfer += oprot->writeFieldBegin("executionUnitData", ::apache::thrift::protocol::T_STRING, 5);
    xfer += oprot->writeString(this->executionUnitData);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.nodeInputs) {
    xfer += oprot->writeFieldBegin("nodeInputs", ::apache::thrift::protocol::T_LIST, 6);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->nodeInputs.size()));
      std::vector< ::apache::airavata::model::appcatalog::appinterface::InputDataObjectType> ::const_iterator _iter77;
      for (_iter77 = this->nodeInputs.begin(); _iter77 != this->nodeInputs.end(); ++_iter77)
      {
        xfer += (*_iter77).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.nodeOutputs) {
    xfer += oprot->writeFieldBegin("nodeOutputs", ::apache::thrift::protocol::T_LIST, 7);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->nodeOutputs.size()));
      std::vector< ::apache::airavata::model::appcatalog::appinterface::OutputDataObjectType> ::const_iterator _iter78;
      for (_iter78 = this->nodeOutputs.begin(); _iter78 != this->nodeOutputs.end(); ++_iter78)
      {
        xfer += (*_iter78).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.workflowNodeStatus) {
    xfer += oprot->writeFieldBegin("workflowNodeStatus", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->workflowNodeStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.taskDetailsList) {
    xfer += oprot->writeFieldBegin("taskDetailsList", ::apache::thrift::protocol::T_LIST, 9);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->taskDetailsList.size()));
      std::vector<TaskDetails> ::const_iterator _iter79;
      for (_iter79 = this->taskDetailsList.begin(); _iter79 != this->taskDetailsList.end(); ++_iter79)
      {
        xfer += (*_iter79).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.errors) {
    xfer += oprot->writeFieldBegin("errors", ::apache::thrift::protocol::T_LIST, 10);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->errors.size()));
      std::vector<ErrorDetails> ::const_iterator _iter80;
      for (_iter80 = this->errors.begin(); _iter80 != this->errors.end(); ++_iter80)
      {
        xfer += (*_iter80).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(WorkflowNodeDetails &a, WorkflowNodeDetails &b) {
  using ::std::swap;
  swap(a.nodeInstanceId, b.nodeInstanceId);
  swap(a.creationTime, b.creationTime);
  swap(a.nodeName, b.nodeName);
  swap(a.executionUnit, b.executionUnit);
  swap(a.executionUnitData, b.executionUnitData);
  swap(a.nodeInputs, b.nodeInputs);
  swap(a.nodeOutputs, b.nodeOutputs);
  swap(a.workflowNodeStatus, b.workflowNodeStatus);
  swap(a.taskDetailsList, b.taskDetailsList);
  swap(a.errors, b.errors);
  swap(a.__isset, b.__isset);
}

const char* ValidatorResult::ascii_fingerprint = "EB04A806CFFC9025AEE48CFFDC378A86";
const uint8_t ValidatorResult::binary_fingerprint[16] = {0xEB,0x04,0xA8,0x06,0xCF,0xFC,0x90,0x25,0xAE,0xE4,0x8C,0xFF,0xDC,0x37,0x8A,0x86};

uint32_t ValidatorResult::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_result = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->result);
          isset_result = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->errorDetails);
          this->__isset.errorDetails = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_result)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ValidatorResult::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ValidatorResult");

  xfer += oprot->writeFieldBegin("result", ::apache::thrift::protocol::T_BOOL, 1);
  xfer += oprot->writeBool(this->result);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.errorDetails) {
    xfer += oprot->writeFieldBegin("errorDetails", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->errorDetails);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ValidatorResult &a, ValidatorResult &b) {
  using ::std::swap;
  swap(a.result, b.result);
  swap(a.errorDetails, b.errorDetails);
  swap(a.__isset, b.__isset);
}

const char* ValidationResults::ascii_fingerprint = "E73BC8630EE405DA5FB801ED852143D2";
const uint8_t ValidationResults::binary_fingerprint[16] = {0xE7,0x3B,0xC8,0x63,0x0E,0xE4,0x05,0xDA,0x5F,0xB8,0x01,0xED,0x85,0x21,0x43,0xD2};

uint32_t ValidationResults::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_validationState = false;
  bool isset_validationResultList = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->validationState);
          isset_validationState = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->validationResultList.clear();
            uint32_t _size81;
            ::apache::thrift::protocol::TType _etype84;
            xfer += iprot->readListBegin(_etype84, _size81);
            this->validationResultList.resize(_size81);
            uint32_t _i85;
            for (_i85 = 0; _i85 < _size81; ++_i85)
            {
              xfer += this->validationResultList[_i85].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_validationResultList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_validationState)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_validationResultList)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ValidationResults::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ValidationResults");

  xfer += oprot->writeFieldBegin("validationState", ::apache::thrift::protocol::T_BOOL, 1);
  xfer += oprot->writeBool(this->validationState);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("validationResultList", ::apache::thrift::protocol::T_LIST, 2);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->validationResultList.size()));
    std::vector<ValidatorResult> ::const_iterator _iter86;
    for (_iter86 = this->validationResultList.begin(); _iter86 != this->validationResultList.end(); ++_iter86)
    {
      xfer += (*_iter86).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ValidationResults &a, ValidationResults &b) {
  using ::std::swap;
  swap(a.validationState, b.validationState);
  swap(a.validationResultList, b.validationResultList);
}

const char* Experiment::ascii_fingerprint = "2826868ECEA08F4F71C71DEAD5A3270F";
const uint8_t Experiment::binary_fingerprint[16] = {0x28,0x26,0x86,0x8E,0xCE,0xA0,0x8F,0x4F,0x71,0xC7,0x1D,0xEA,0xD5,0xA3,0x27,0x0F};

uint32_t Experiment::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentID = false;
  bool isset_projectID = false;
  bool isset_userName = false;
  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentID);
          isset_experimentID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->projectID);
          isset_projectID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userName);
          isset_userName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->description);
          this->__isset.description = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationId);
          this->__isset.applicationId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationVersion);
          this->__isset.applicationVersion = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workflowTemplateId);
          this->__isset.workflowTemplateId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workflowTemplateVersion);
          this->__isset.workflowTemplateVersion = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayExecutionId);
          this->__isset.gatewayExecutionId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->enableEmailNotification);
          this->__isset.enableEmailNotification = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->emailAddresses.clear();
            uint32_t _size87;
            ::apache::thrift::protocol::TType _etype90;
            xfer += iprot->readListBegin(_etype90, _size87);
            this->emailAddresses.resize(_size87);
            uint32_t _i91;
            for (_i91 = 0; _i91 < _size87; ++_i91)
            {
              xfer += iprot->readString(this->emailAddresses[_i91]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.emailAddresses = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->userConfigurationData.read(iprot);
          this->__isset.userConfigurationData = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workflowExecutionInstanceId);
          this->__isset.workflowExecutionInstanceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->experimentInputs.clear();
            uint32_t _size92;
            ::apache::thrift::protocol::TType _etype95;
            xfer += iprot->readListBegin(_etype95, _size92);
            this->experimentInputs.resize(_size92);
            uint32_t _i96;
            for (_i96 = 0; _i96 < _size92; ++_i96)
            {
              xfer += this->experimentInputs[_i96].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.experimentInputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 17:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->experimentOutputs.clear();
            uint32_t _size97;
            ::apache::thrift::protocol::TType _etype100;
            xfer += iprot->readListBegin(_etype100, _size97);
            this->experimentOutputs.resize(_size97);
            uint32_t _i101;
            for (_i101 = 0; _i101 < _size97; ++_i101)
            {
              xfer += this->experimentOutputs[_i101].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.experimentOutputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 18:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->experimentStatus.read(iprot);
          this->__isset.experimentStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 19:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->stateChangeList.clear();
            uint32_t _size102;
            ::apache::thrift::protocol::TType _etype105;
            xfer += iprot->readListBegin(_etype105, _size102);
            this->stateChangeList.resize(_size102);
            uint32_t _i106;
            for (_i106 = 0; _i106 < _size102; ++_i106)
            {
              xfer += this->stateChangeList[_i106].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.stateChangeList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 20:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->workflowNodeDetailsList.clear();
            uint32_t _size107;
            ::apache::thrift::protocol::TType _etype110;
            xfer += iprot->readListBegin(_etype110, _size107);
            this->workflowNodeDetailsList.resize(_size107);
            uint32_t _i111;
            for (_i111 = 0; _i111 < _size107; ++_i111)
            {
              xfer += this->workflowNodeDetailsList[_i111].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.workflowNodeDetailsList = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 21:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->errors.clear();
            uint32_t _size112;
            ::apache::thrift::protocol::TType _etype115;
            xfer += iprot->readListBegin(_etype115, _size112);
            this->errors.resize(_size112);
            uint32_t _i116;
            for (_i116 = 0; _i116 < _size112; ++_i116)
            {
              xfer += this->errors[_i116].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.errors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_projectID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t Experiment::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("Experiment");

  xfer += oprot->writeFieldBegin("experimentID", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentID);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("projectID", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->projectID);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 3);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("userName", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->userName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 5);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.description) {
    xfer += oprot->writeFieldBegin("description", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->description);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationId) {
    xfer += oprot->writeFieldBegin("applicationId", ::apache::thrift::protocol::T_STRING, 7);
    xfer += oprot->writeString(this->applicationId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationVersion) {
    xfer += oprot->writeFieldBegin("applicationVersion", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->applicationVersion);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.workflowTemplateId) {
    xfer += oprot->writeFieldBegin("workflowTemplateId", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->workflowTemplateId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.workflowTemplateVersion) {
    xfer += oprot->writeFieldBegin("workflowTemplateVersion", ::apache::thrift::protocol::T_STRING, 10);
    xfer += oprot->writeString(this->workflowTemplateVersion);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gatewayExecutionId) {
    xfer += oprot->writeFieldBegin("gatewayExecutionId", ::apache::thrift::protocol::T_STRING, 11);
    xfer += oprot->writeString(this->gatewayExecutionId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.enableEmailNotification) {
    xfer += oprot->writeFieldBegin("enableEmailNotification", ::apache::thrift::protocol::T_BOOL, 12);
    xfer += oprot->writeBool(this->enableEmailNotification);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.emailAddresses) {
    xfer += oprot->writeFieldBegin("emailAddresses", ::apache::thrift::protocol::T_LIST, 13);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->emailAddresses.size()));
      std::vector<std::string> ::const_iterator _iter117;
      for (_iter117 = this->emailAddresses.begin(); _iter117 != this->emailAddresses.end(); ++_iter117)
      {
        xfer += oprot->writeString((*_iter117));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.userConfigurationData) {
    xfer += oprot->writeFieldBegin("userConfigurationData", ::apache::thrift::protocol::T_STRUCT, 14);
    xfer += this->userConfigurationData.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.workflowExecutionInstanceId) {
    xfer += oprot->writeFieldBegin("workflowExecutionInstanceId", ::apache::thrift::protocol::T_STRING, 15);
    xfer += oprot->writeString(this->workflowExecutionInstanceId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentInputs) {
    xfer += oprot->writeFieldBegin("experimentInputs", ::apache::thrift::protocol::T_LIST, 16);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->experimentInputs.size()));
      std::vector< ::apache::airavata::model::appcatalog::appinterface::InputDataObjectType> ::const_iterator _iter118;
      for (_iter118 = this->experimentInputs.begin(); _iter118 != this->experimentInputs.end(); ++_iter118)
      {
        xfer += (*_iter118).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentOutputs) {
    xfer += oprot->writeFieldBegin("experimentOutputs", ::apache::thrift::protocol::T_LIST, 17);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->experimentOutputs.size()));
      std::vector< ::apache::airavata::model::appcatalog::appinterface::OutputDataObjectType> ::const_iterator _iter119;
      for (_iter119 = this->experimentOutputs.begin(); _iter119 != this->experimentOutputs.end(); ++_iter119)
      {
        xfer += (*_iter119).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentStatus) {
    xfer += oprot->writeFieldBegin("experimentStatus", ::apache::thrift::protocol::T_STRUCT, 18);
    xfer += this->experimentStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.stateChangeList) {
    xfer += oprot->writeFieldBegin("stateChangeList", ::apache::thrift::protocol::T_LIST, 19);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->stateChangeList.size()));
      std::vector<WorkflowNodeStatus> ::const_iterator _iter120;
      for (_iter120 = this->stateChangeList.begin(); _iter120 != this->stateChangeList.end(); ++_iter120)
      {
        xfer += (*_iter120).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.workflowNodeDetailsList) {
    xfer += oprot->writeFieldBegin("workflowNodeDetailsList", ::apache::thrift::protocol::T_LIST, 20);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->workflowNodeDetailsList.size()));
      std::vector<WorkflowNodeDetails> ::const_iterator _iter121;
      for (_iter121 = this->workflowNodeDetailsList.begin(); _iter121 != this->workflowNodeDetailsList.end(); ++_iter121)
      {
        xfer += (*_iter121).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.errors) {
    xfer += oprot->writeFieldBegin("errors", ::apache::thrift::protocol::T_LIST, 21);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->errors.size()));
      std::vector<ErrorDetails> ::const_iterator _iter122;
      for (_iter122 = this->errors.begin(); _iter122 != this->errors.end(); ++_iter122)
      {
        xfer += (*_iter122).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(Experiment &a, Experiment &b) {
  using ::std::swap;
  swap(a.experimentID, b.experimentID);
  swap(a.projectID, b.projectID);
  swap(a.creationTime, b.creationTime);
  swap(a.userName, b.userName);
  swap(a.name, b.name);
  swap(a.description, b.description);
  swap(a.applicationId, b.applicationId);
  swap(a.applicationVersion, b.applicationVersion);
  swap(a.workflowTemplateId, b.workflowTemplateId);
  swap(a.workflowTemplateVersion, b.workflowTemplateVersion);
  swap(a.gatewayExecutionId, b.gatewayExecutionId);
  swap(a.enableEmailNotification, b.enableEmailNotification);
  swap(a.emailAddresses, b.emailAddresses);
  swap(a.userConfigurationData, b.userConfigurationData);
  swap(a.workflowExecutionInstanceId, b.workflowExecutionInstanceId);
  swap(a.experimentInputs, b.experimentInputs);
  swap(a.experimentOutputs, b.experimentOutputs);
  swap(a.experimentStatus, b.experimentStatus);
  swap(a.stateChangeList, b.stateChangeList);
  swap(a.workflowNodeDetailsList, b.workflowNodeDetailsList);
  swap(a.errors, b.errors);
  swap(a.__isset, b.__isset);
}

const char* ExperimentSummary::ascii_fingerprint = "A1A9DDD1C0AA5DEEDC8413E553960BEF";
const uint8_t ExperimentSummary::binary_fingerprint[16] = {0xA1,0xA9,0xDD,0xD1,0xC0,0xAA,0x5D,0xEE,0xDC,0x84,0x13,0xE5,0x53,0x96,0x0B,0xEF};

uint32_t ExperimentSummary::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentID = false;
  bool isset_projectID = false;
  bool isset_userName = false;
  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentID);
          isset_experimentID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->projectID);
          isset_projectID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userName);
          isset_userName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->description);
          this->__isset.description = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationId);
          this->__isset.applicationId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->experimentStatus.read(iprot);
          this->__isset.experimentStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_projectID)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentSummary::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ExperimentSummary");

  xfer += oprot->writeFieldBegin("experimentID", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentID);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("projectID", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->projectID);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 3);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("userName", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->userName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 5);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.description) {
    xfer += oprot->writeFieldBegin("description", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->description);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationId) {
    xfer += oprot->writeFieldBegin("applicationId", ::apache::thrift::protocol::T_STRING, 7);
    xfer += oprot->writeString(this->applicationId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentStatus) {
    xfer += oprot->writeFieldBegin("experimentStatus", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->experimentStatus.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentSummary &a, ExperimentSummary &b) {
  using ::std::swap;
  swap(a.experimentID, b.experimentID);
  swap(a.projectID, b.projectID);
  swap(a.creationTime, b.creationTime);
  swap(a.userName, b.userName);
  swap(a.name, b.name);
  swap(a.description, b.description);
  swap(a.applicationId, b.applicationId);
  swap(a.experimentStatus, b.experimentStatus);
  swap(a.__isset, b.__isset);
}

}}}}} // namespace
