/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

@Deprecated
public class ResourceImporter {
    private static final Log log = LogFactory.getLog(ResourceImporter.class);
    private Registry registry;

    public ResourceImporter(Registry registry) {
        this.registry = registry;
    }

    public void importDirectory(String fromURL, String toPath) throws RegistryException {
        URI uri;
        toPath = this.preparePath(toPath);
        ArrayList<String> toBeProcessed = new ArrayList<String>();
        try {
            uri = new URI(fromURL);
        }
        catch (URISyntaxException e) {
            String msg = "Directory to be imported should be given as a file URL.\nCaused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
        File topFile = new File(uri);
        if (!topFile.exists()) {
            String msg = "Could not import the non-existence directory " + uri;
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String rootPath = topFile.getAbsolutePath();
        toBeProcessed.add(rootPath);
        while (toBeProcessed.size() > 0) {
            String path = (String)toBeProcessed.remove(0);
            File file = new File(path);
            if (file.isDirectory()) {
                File[] children;
                this.putDirectory(rootPath, file, toPath);
                for (File aChildren : children = file.listFiles()) {
                    toBeProcessed.add(aChildren.getAbsolutePath());
                }
                continue;
            }
            this.putFile(rootPath, file, toPath);
        }
    }

    private void putDirectory(String rootPath, File directory, String toPath) throws RegistryException {
        Collection collection = this.registry.newCollection();
        String targetPath = toPath + directory.getAbsolutePath().substring(rootPath.length());
        this.registry.put(targetPath, collection);
    }

    private void putFile(String rootPath, File file, String toPath) throws RegistryException {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            ResourceImpl resource = new ResourceImpl();
            resource.setContentStream(fileStream);
            String targetPath = toPath + file.getAbsolutePath().substring(rootPath.length());
            this.registry.put(targetPath, resource);
        }
        catch (Exception e) {
            String msg = "Could not read from the file " + file.getPath();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error while closing the file: " + file.getName()));
                }
            }
        }
    }

    private String preparePath(String rawPath) {
        String preparedPath = rawPath;
        if (rawPath.endsWith("/")) {
            preparedPath = rawPath.substring(0, rawPath.length() - "/".length());
        }
        return preparedPath;
    }
}

