/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.dep;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.cfg.Configuration;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.dep.AbstractHibernateGpsDevice;
import org.compass.gps.device.hibernate.dep.HibernateEntityInfo;

public class Hibernate2GpsDevice
extends AbstractHibernateGpsDevice {
    private SessionFactory sessionFactory;
    private Configuration configuration;

    public Hibernate2GpsDevice() {
    }

    public Hibernate2GpsDevice(String name, SessionFactory sessionFactory) {
        this.setName(name);
        this.sessionFactory = sessionFactory;
    }

    public Hibernate2GpsDevice(String name, Configuration configuration) {
        this.setName(name);
        this.configuration = configuration;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws CompassGpsException {
        super.doStart();
        if (this.sessionFactory == null) {
            if (this.configuration == null) {
                throw new HibernateGpsDeviceException(this.buildMessage("Must set configuration or sessionFactory"));
            }
            try {
                this.sessionFactory = this.configuration.buildSessionFactory();
            }
            catch (HibernateException e) {
                throw new HibernateGpsDeviceException(this.buildMessage("Failed to create session factory"), e);
            }
        }
    }

    protected void doStop() throws CompassGpsException {
    }

    protected AbstractHibernateGpsDevice.HibernateSessionWrapper doGetHibernateSessionWrapper() {
        return new Hibernate2SessionWrapper(this.sessionFactory);
    }

    protected HibernateEntityInfo[] doGetHibernateEntitiesInfo() throws HibernateGpsDeviceException {
        ArrayList<HibernateEntityInfo> infos = new ArrayList<HibernateEntityInfo>();
        try {
            Map allClassMetaData = this.sessionFactory.getAllClassMetadata();
            for (Class clazz : allClassMetaData.keySet()) {
                if (this.isFilteredForIndex(clazz.getName()) || !this.compassGps.hasMappingForEntityForIndex(clazz)) continue;
                ResourceMapping resourceMapping = this.compassGps.getMappingForEntityForIndex(clazz);
                HibernateEntityInfo info = new HibernateEntityInfo(clazz.getName(), "from " + clazz.getName(), resourceMapping.getSubIndexHash().getSubIndexes());
                infos.add(info);
            }
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to fetch all class meta data"), e);
        }
        return infos.toArray(new HibernateEntityInfo[infos.size()]);
    }

    protected List doGetObjects(HibernateEntityInfo info, int from, int count, AbstractHibernateGpsDevice.HibernateSessionWrapper sessionWrapper) throws HibernateGpsDeviceException {
        List values;
        Session session = ((Hibernate2SessionWrapper)sessionWrapper).getSession();
        try {
            Query query = session.createQuery(info.getSelectQuery()).setFirstResult(from).setMaxResults(count);
            values = query.list();
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to open session to fetch data for class [" + info.getName() + "]"), e);
        }
        return values;
    }

    private class Hibernate2SessionWrapper
    implements AbstractHibernateGpsDevice.HibernateSessionWrapper {
        private SessionFactory sessionFactory;
        private Session session;
        private Transaction tr;

        public Hibernate2SessionWrapper(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public Session getSession() {
            return this.session;
        }

        public void open() throws HibernateGpsDeviceException {
            try {
                this.session = this.sessionFactory.openSession();
            }
            catch (HibernateException e) {
                throw new HibernateGpsDeviceException(Hibernate2GpsDevice.this.buildMessage("Failed to open session to fetch data"), e);
            }
            try {
                this.tr = this.session.beginTransaction();
            }
            catch (HibernateException e) {
                throw new HibernateGpsDeviceException(Hibernate2GpsDevice.this.buildMessage("Failed to begin transaction to fetch data"), e);
            }
        }

        public void close() {
            if (this.tr != null) {
                try {
                    this.tr.commit();
                }
                catch (HibernateException e1) {
                    Hibernate2GpsDevice.this.log.error((Object)Hibernate2GpsDevice.this.buildMessage("Failed to rollback hibernate transaction"), (Throwable)e1);
                }
            }
            try {
                this.session.close();
            }
            catch (HibernateException e) {
                Hibernate2GpsDevice.this.log.error((Object)Hibernate2GpsDevice.this.buildMessage("Failed to close Hibernate session"), (Throwable)e);
            }
        }

        public void closeOnError() {
            if (this.tr != null) {
                try {
                    this.tr.rollback();
                }
                catch (HibernateException e1) {
                    Hibernate2GpsDevice.this.log.error((Object)Hibernate2GpsDevice.this.buildMessage("Failed to rollback hibernate transaction"), (Throwable)e1);
                }
            }
            try {
                this.session.close();
            }
            catch (HibernateException e) {
                Hibernate2GpsDevice.this.log.error((Object)Hibernate2GpsDevice.this.buildMessage("Failed to close Hibernate session"), (Throwable)e);
            }
        }
    }
}

