/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeEventsResult
implements Serializable {
    private String marker;
    private ListWithAutoConstructFlag<Event> events;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeEventsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<Event> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<Event> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public DescribeEventsResult withEvents(Event ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<Event>(events.length));
        }
        for (Event value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public DescribeEventsResult withEvents(Collection<Event> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResult)) {
            return false;
        }
        DescribeEventsResult other = (DescribeEventsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }
}

