/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.util.Strings;

public class JavaAndBCStyle
extends BCStyle {
    private static final Map<String, ASN1ObjectIdentifier> string2Asn = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Hashtable<ASN1ObjectIdentifier, String> asn2String = new Hashtable();
    public static final Hashtable<ASN1ObjectIdentifier, String> asn2StringAll = new Hashtable();
    public static final ASN1ObjectIdentifier IP = new ASN1ObjectIdentifier("1.3.6.1.4.1.42.2.11.2.1");
    public static final JavaAndBCStyle INSTANCE = new JavaAndBCStyle();

    public ASN1ObjectIdentifier attrNameToOID(String attrName) {
        ASN1ObjectIdentifier asn = string2Asn.get(Strings.toLowerCase((String)attrName));
        if (asn != null) {
            return asn;
        }
        return super.attrNameToOID(attrName);
    }

    public String toString(X500Name name, Hashtable<ASN1ObjectIdentifier, String> mappings) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        RDN[] rdns = name.getRDNs();
        for (int i = 0; i < rdns.length; ++i) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            if (rdns[i].isMultiValued()) {
                AttributeTypeAndValue[] atv = rdns[i].getTypesAndValues();
                boolean firstAtv = true;
                for (int j = 0; j != atv.length; ++j) {
                    if (firstAtv) {
                        firstAtv = false;
                    } else {
                        buf.append('+');
                    }
                    IETFUtils.appendTypeAndValue((StringBuffer)buf, (AttributeTypeAndValue)atv[j], mappings);
                }
                continue;
            }
            IETFUtils.appendTypeAndValue((StringBuffer)buf, (AttributeTypeAndValue)rdns[i].getFirst(), mappings);
        }
        return buf.toString();
    }

    public RDN[] fromString(String dirName) {
        if ("".equals(dirName)) {
            return new RDN[0];
        }
        return super.fromString(dirName);
    }

    public String toString(X500Name name) {
        return this.toString(name, asn2String);
    }

    public String toStringFull(X500Name name) {
        return this.toString(name, asn2StringAll);
    }

    public String getLabelForOid(ASN1ObjectIdentifier oid) {
        return asn2String.get(oid);
    }

    public String getLabelForOidFull(ASN1ObjectIdentifier oid) {
        return asn2StringAll.get(oid);
    }

    static {
        string2Asn.put("email", BCStyle.EmailAddress);
        string2Asn.put("s", BCStyle.ST);
        string2Asn.put("dnqualifier", BCStyle.DN_QUALIFIER);
        string2Asn.put("dnq", BCStyle.DN_QUALIFIER);
        string2Asn.put("ip", IP);
        asn2String.put(CN, "CN");
        asn2String.put(C, "C");
        asn2String.put(L, "L");
        asn2String.put(ST, "ST");
        asn2String.put(O, "O");
        asn2String.put(OU, "OU");
        asn2String.put(T, "T");
        asn2String.put(IP, "IP");
        asn2String.put(STREET, "STREET");
        asn2String.put(DC, "DC");
        asn2String.put(DN_QUALIFIER, "DNQUALIFIER");
        asn2String.put(SURNAME, "SURNAME");
        asn2String.put(GIVENNAME, "GIVENNAME");
        asn2String.put(INITIALS, "INITIALS");
        asn2String.put(GENERATION, "GENERATION");
        asn2String.put(E, "EMAILADDRESS");
        asn2String.put(UID, "UID");
        asn2String.put(SERIALNUMBER, "SERIALNUMBER");
        asn2StringAll.putAll(asn2String);
        asn2StringAll.put(UnstructuredAddress, "unstructuredAddress");
        asn2StringAll.put(UnstructuredName, "unstructuredName");
        asn2StringAll.put(UNIQUE_IDENTIFIER, "UniqueIdentifier");
        asn2StringAll.put(DN_QUALIFIER, "DN");
        asn2StringAll.put(PSEUDONYM, "Pseudonym");
        asn2StringAll.put(POSTAL_ADDRESS, "PostalAddress");
        asn2StringAll.put(NAME_AT_BIRTH, "NameAtBirth");
        asn2StringAll.put(COUNTRY_OF_CITIZENSHIP, "CountryOfCitizenship");
        asn2StringAll.put(COUNTRY_OF_RESIDENCE, "CountryOfResidence");
        asn2StringAll.put(GENDER, "Gender");
        asn2StringAll.put(PLACE_OF_BIRTH, "PlaceOfBirth");
        asn2StringAll.put(DATE_OF_BIRTH, "DateOfBirth");
        asn2StringAll.put(POSTAL_CODE, "PostalCode");
        asn2StringAll.put(BUSINESS_CATEGORY, "BusinessCategory");
        asn2StringAll.put(TELEPHONE_NUMBER, "TelephoneNumber");
        asn2StringAll.put(NAME, "Name");
    }
}

