/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers;

import eu.emi.security.authn.x509.StoreUpdateListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ObserversHandler {
    private Set<StoreUpdateListener> observers = new HashSet<StoreUpdateListener>();

    public ObserversHandler() {
        this(null);
    }

    public ObserversHandler(Collection<? extends StoreUpdateListener> initialObservers) {
        if (initialObservers != null) {
            this.observers.addAll(initialObservers);
        }
    }

    public synchronized void addObserver(StoreUpdateListener listener) {
        this.observers.add(listener);
    }

    public synchronized void removeObserver(StoreUpdateListener listener) {
        this.observers.remove(listener);
    }

    public synchronized void notifyObservers(String url, String type, StoreUpdateListener.Severity level, Exception e) {
        for (StoreUpdateListener observer : this.observers) {
            observer.loadingNotification(url, type, level, e);
        }
    }

    public synchronized void removeAllObservers() {
        this.observers.clear();
    }
}

