/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.proxy.BaseProxyCertificateOptions;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class ProxyCertificateOptions
extends BaseProxyCertificateOptions {
    public static final int DEFAULT_KEY_LENGTH = 1024;
    public static final int DEFAULT_LONG_KEY_LENGTH = 2048;
    public static final int LONG_PROXY = 864000;
    private Integer keyLength;
    private PublicKey publicKey = null;

    public ProxyCertificateOptions(X509Certificate[] parentCertChain) {
        super(parentCertChain);
    }

    public void setKeyLength(int length) {
        this.keyLength = length;
    }

    public int getKeyLength() {
        if (this.keyLength == null) {
            int lifetime = this.getLifetime();
            if (lifetime >= 864000) {
                return 2048;
            }
            return 1024;
        }
        return this.keyLength;
    }

    public void setPublicKey(PublicKey pubKey) {
        this.publicKey = pubKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

