/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.client.AbstractClientEnvironment;
import edu.uiuc.ncsa.security.delegation.client.DelegationService;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import javax.inject.Provider;

public class ClientEnvironment
extends AbstractClientEnvironment {
    public static final String CALLBACK_URI_KEY = "oa4mp:callback_uri";
    public static final String TOKEN = "oa4mp:token";
    public static final String FORM_ENCODING = "oa4mp:form_encoding";
    public static final String VERIFIER = "oa4mp:verifier";
    AssetStore assetStore;
    protected URI accessTokenUri;
    protected URI authorizationUri;
    protected URI initializeUri;
    protected URI resourceServerUri;
    Provider<AssetStore> assetStoreProvider;
    AssetProvider assetProvider;
    TokenForge tokenForge;
    DelegationService delegationService;
    Provider<DelegationService> dsp;
    PrivateKey privateKey;
    PublicKey publicKey;
    String clientId;
    protected URI callback;
    protected String privKeyString;
    protected Provider<Client> cp;
    protected Provider<TokenForge> tfp;
    long certLifetime = 0L;
    protected Client client;
    protected String skin;
    long keypairLifetime = -1L;
    long maxAssetLifetime = -1L;
    boolean enableAssetCleanup;
    boolean showRedirectPage = false;
    protected String errorPagePath = "/pages/client-error.jsp";
    protected String successPagePath = "/pages/client-success.jsp";
    protected String redirectPagePath = "/pages/client-show-redirect.jsp";

    public ClientEnvironment(URI accessTokenUri, URI authorizationUri, URI callback, long certLifetime, String clientId, DelegationService delegationService, URI initializeUri, PrivateKey privateKey, PublicKey publicKey, URI resourceServerUri, TokenForge tokenForge, AssetStore assetStore, boolean showRedirectPage, String errorPagePath, String redirectPagePath, String successPagePath) {
        this.accessTokenUri = accessTokenUri;
        this.authorizationUri = authorizationUri;
        this.callback = callback;
        this.certLifetime = certLifetime;
        this.clientId = clientId;
        this.delegationService = delegationService;
        this.initializeUri = initializeUri;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.resourceServerUri = resourceServerUri;
        this.tokenForge = tokenForge;
        this.assetStore = assetStore;
        this.skin = null;
        this.showRedirectPage = showRedirectPage;
        if (errorPagePath != null) {
            this.errorPagePath = errorPagePath;
        }
        if (successPagePath != null) {
            this.successPagePath = successPagePath;
        }
        if (redirectPagePath != null) {
            this.redirectPagePath = redirectPagePath;
        }
    }

    public boolean hasAssetStore() {
        return this.getAssetStore() != null;
    }

    public ClientEnvironment(MyLoggingFacade logger, Map<String, String> constants, URI accessTokenUri, URI authorizationUri, URI callback, URI initializeUri, URI resourceServerUri, long certLifetime, String clientId, PrivateKey privateKey, PublicKey publicKey, String skin, boolean enableAssetCleanup, long maxAssetLifetime, long keypairLifetime, AssetProvider assetProvider, Provider<Client> clientProvider, Provider<TokenForge> tokenForgeProvider, Provider<DelegationService> delegationServiceProvider, Provider<AssetStore> assetStoreProvider, boolean showRedirectPage, String errorPagePath, String redirectPagePath, String successPagePath) {
        super(logger, constants);
        this.accessTokenUri = accessTokenUri;
        this.authorizationUri = authorizationUri;
        this.callback = callback;
        this.initializeUri = initializeUri;
        this.resourceServerUri = resourceServerUri;
        this.certLifetime = certLifetime;
        this.clientId = clientId;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.cp = clientProvider;
        this.dsp = delegationServiceProvider;
        this.tfp = tokenForgeProvider;
        this.assetStoreProvider = assetStoreProvider;
        this.assetProvider = assetProvider;
        this.skin = skin;
        this.enableAssetCleanup = enableAssetCleanup;
        this.maxAssetLifetime = maxAssetLifetime;
        this.keypairLifetime = keypairLifetime;
        this.showRedirectPage = showRedirectPage;
        if (errorPagePath != null) {
            this.errorPagePath = errorPagePath;
        }
        if (successPagePath != null) {
            this.successPagePath = successPagePath;
        }
        if (redirectPagePath != null) {
            this.redirectPagePath = redirectPagePath;
        }
    }

    public AssetStore getAssetStore() {
        if (this.assetStore == null && this.assetStoreProvider != null) {
            this.assetStore = (AssetStore)this.assetStoreProvider.get();
        }
        return this.assetStore;
    }

    public AssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(AssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }

    public URI getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public URI getAuthorizationUri() {
        return this.authorizationUri;
    }

    public URI getInitializeUri() {
        return this.initializeUri;
    }

    public URI getResourceServerUri() {
        return this.resourceServerUri;
    }

    public TokenForge getTokenForge() {
        if (this.tokenForge == null) {
            this.tokenForge = (TokenForge)this.tfp.get();
        }
        return this.tokenForge;
    }

    public DelegationService getDelegationService() {
        if (this.delegationService == null) {
            this.delegationService = (DelegationService)this.dsp.get();
        }
        return this.delegationService;
    }

    public URI getCallback() {
        return this.callback;
    }

    public void setCallback(URI callback) {
        this.callback = callback;
    }

    public String getClientId() {
        return this.clientId;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    protected String getPrivKeyString() {
        if (this.privKeyString == null) {
            try {
                this.privKeyString = KeyUtil.toPKCS8PEM((PrivateKey)this.getPrivateKey());
            }
            catch (Exception e) {
                throw new GeneralException("Error: could not convert private key to a PKCS 8 PEM", (Throwable)e);
            }
        }
        return this.privKeyString;
    }

    public Client getClient() {
        if (this.client == null) {
            this.client = (Client)this.cp.get();
            this.client.setIdentifier((Identifier)new BasicIdentifier(this.getClientId()));
            this.client.setSecret(this.getPrivKeyString());
        }
        return this.client;
    }

    public long getCertLifetime() {
        return this.certLifetime;
    }

    public void setCertLifetime(long newCertLifetime) {
        this.certLifetime = newCertLifetime;
    }

    public String getSkin() {
        return this.skin;
    }

    public long getKeypairLifetime() {
        return this.keypairLifetime;
    }

    public long getMaxAssetLifetime() {
        return this.maxAssetLifetime;
    }

    public boolean isEnableAssetCleanup() {
        return this.enableAssetCleanup;
    }

    public boolean isShowRedirectPage() {
        return this.showRedirectPage;
    }

    public String getErrorPagePath() {
        return this.errorPagePath;
    }

    public void setErrorPagePath(String errorPagePath) {
        this.errorPagePath = errorPagePath;
    }

    public String getSuccessPagePath() {
        return this.successPagePath;
    }

    public void setSuccessPagePath(String successPagePath) {
        this.successPagePath = successPagePath;
    }

    public String getRedirectPagePath() {
        return this.redirectPagePath;
    }

    public void setRedirectPagePath(String redirectPagePath) {
        this.redirectPagePath = redirectPagePath;
    }
}

