/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtil {
    private String jdbcUrl;
    private String databaseUserName;
    private String databasePassword;
    private String driverName;
    protected static Logger log = LoggerFactory.getLogger(DBUtil.class);
    private Properties properties;

    public DBUtil(String jdbcUrl, String userName, String password, String driver) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.jdbcUrl = jdbcUrl;
        this.databaseUserName = userName;
        this.databasePassword = password;
        this.driverName = driver;
        this.init();
    }

    private void init() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.properties = new Properties();
        this.properties.put("user", this.databaseUserName);
        this.properties.put("password", this.databasePassword);
        this.properties.put("characterEncoding", "ISO-8859-1");
        this.properties.put("useUnicode", "true");
        this.loadDriver();
    }

    public String getMatchingColumnValue(String tableName, String selectColumn, String whereValue) throws SQLException {
        return this.getMatchingColumnValue(tableName, selectColumn, selectColumn, whereValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMatchingColumnValue(String tableName, String selectColumn, String whereColumn, String whereValue) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ").append(selectColumn).append(" FROM ").append(tableName).append(" WHERE ").append(whereColumn).append(" = ?");
        String sql = stringBuilder.toString();
        Connection connection = this.getConnection();
        PreparedStatement ps = connection.prepareStatement(sql);
        ResultSet rs = null;
        try {
            ps.setString(1, whereValue);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                ps.close();
                connection.close();
            }
            catch (Exception ignore) {
                log.error("An error occurred while closing database connections ", (Throwable)ignore);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSQL(String sql) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement ps = connection.prepareStatement(sql);
        try {
            ps.executeUpdate();
            connection.commit();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                connection.close();
            }
            catch (Exception ignore) {
                log.error("An error occurred while closing database connections ", (Throwable)ignore);
            }
        }
    }

    private void loadDriver() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class.forName(this.driverName).newInstance();
    }

    public DataSource getDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(this.driverName);
        ds.setUsername(this.databaseUserName);
        ds.setPassword(this.databasePassword);
        ds.setUrl(this.jdbcUrl);
        return ds;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.jdbcUrl, this.properties);
        connection.setAutoCommit(false);
        return connection;
    }

    public static void cleanup(PreparedStatement preparedStatement, Connection connection) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error("Error closing prepared statement.", (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error("Error closing database connection.", (Throwable)e);
            }
        }
    }

    public static void cleanup(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error("Error closing prepared statement.", (Throwable)e);
            }
        }
    }

    public static void cleanup(PreparedStatement preparedStatement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error("Error closing prepared statement.", (Throwable)e);
            }
        }
        DBUtil.cleanup(preparedStatement);
    }

    public static void cleanup(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.debug("Error closing connection.", (Throwable)e);
                log.warn("Error closing connection.");
            }
        }
    }

    public static void truncate(String tableName, Connection connection) throws SQLException {
        String sql = "delete from " + tableName;
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.executeUpdate();
        connection.commit();
    }

    public static DBUtil getCredentialStoreDBUtil() throws ApplicationSettingsException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String jdbcUrl = ServerSettings.getCredentialStoreDBURL();
        String userName = ServerSettings.getCredentialStoreDBUser();
        String password = ServerSettings.getCredentialStoreDBPassword();
        String driverName = ServerSettings.getCredentialStoreDBDriver();
        StringBuilder stringBuilder = new StringBuilder("Starting credential store, connecting to database - ");
        stringBuilder.append(jdbcUrl).append(" DB user - ").append(userName).append(" driver name - ").append(driverName);
        log.debug(stringBuilder.toString());
        DBUtil dbUtil = new DBUtil(jdbcUrl, userName, password, driverName);
        dbUtil.init();
        return dbUtil;
    }
}

