/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.apache.ws.security.util.Loader;

public class SAMLIssuerImpl
implements SAMLIssuer {
    private static final Log log = LogFactory.getLog(SAMLIssuerImpl.class);
    private Properties properties = null;
    private CallbackHandler callbackHandler = null;
    private String issuer;
    private Crypto issuerCrypto = null;
    private String issuerKeyPassword = null;
    private String issuerKeyName = null;
    private boolean sendKeyValue = false;
    private boolean signAssertion = false;

    public SAMLIssuerImpl() {
    }

    public SAMLIssuerImpl(Properties prop) throws WSSecurityException {
        String issuerProp;
        String signAssertionProp;
        String sendKeyValueProp;
        if (prop == null) {
            return;
        }
        this.properties = prop;
        String cryptoProp = this.properties.getProperty("org.apache.ws.security.saml.issuer.cryptoProp.file");
        if (cryptoProp != null) {
            this.issuerCrypto = CryptoFactory.getInstance(cryptoProp);
            this.issuerKeyName = this.properties.getProperty("org.apache.ws.security.saml.issuer.key.name");
            this.issuerKeyPassword = this.properties.getProperty("org.apache.ws.security.saml.issuer.key.password");
        }
        if ((sendKeyValueProp = this.properties.getProperty("org.apache.ws.security.saml.issuer.sendKeyValue")) != null) {
            this.sendKeyValue = Boolean.valueOf(sendKeyValueProp);
        }
        if ((signAssertionProp = this.properties.getProperty("org.apache.ws.security.saml.issuer.signAssertion")) != null) {
            this.signAssertion = Boolean.valueOf(signAssertionProp);
        }
        if ((issuerProp = this.properties.getProperty("org.apache.ws.security.saml.issuer")) != null) {
            this.issuer = issuerProp;
        }
    }

    public AssertionWrapper newAssertion() throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering AssertionWrapper.newAssertion() ... creating SAML token");
        }
        if (this.callbackHandler == null && this.properties != null) {
            try {
                String samlCallbackClassname = this.properties.getProperty("org.apache.ws.security.saml.callback");
                Class<CallbackHandler> callbackClass = null;
                try {
                    callbackClass = Loader.loadClass(samlCallbackClassname, CallbackHandler.class);
                }
                catch (ClassNotFoundException ex) {
                    throw new WSSecurityException(ex.getMessage(), ex);
                }
                this.callbackHandler = callbackClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new WSSecurityException(ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new WSSecurityException(ex.getMessage(), ex);
            }
        }
        SAMLParms samlParms = new SAMLParms();
        samlParms.setIssuer(this.issuer);
        samlParms.setCallbackHandler(this.callbackHandler);
        AssertionWrapper sa = new AssertionWrapper(samlParms);
        if (this.signAssertion) {
            sa.signAssertion(this.issuerKeyName, this.issuerKeyPassword, this.issuerCrypto, this.sendKeyValue);
        }
        return sa;
    }

    public void setSendKeyValue(boolean sendKeyValue) {
        this.sendKeyValue = sendKeyValue;
    }

    public boolean isSendKeyValue() {
        return this.sendKeyValue;
    }

    public void setSignAssertion(boolean signAssertion) {
        this.signAssertion = signAssertion;
    }

    public boolean isSignAssertion() {
        return this.signAssertion;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setIssuerCrypto(Crypto issuerCrypto) {
        this.issuerCrypto = issuerCrypto;
    }

    public Crypto getIssuerCrypto() {
        return this.issuerCrypto;
    }

    public void setIssuerName(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuerName() {
        return this.issuer;
    }

    public void setIssuerKeyName(String issuerKeyName) {
        this.issuerKeyName = issuerKeyName;
    }

    public String getIssuerKeyName() {
        return this.issuerKeyName;
    }

    public void setIssuerKeyPassword(String issuerKeyPassword) {
        this.issuerKeyPassword = issuerKeyPassword;
    }

    public String getIssuerKeyPassword() {
        return this.issuerKeyPassword;
    }
}

