/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.secure.client;

import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.client.AiravataClientFactory;
import org.apache.airavata.client.secure.client.OAuthAppRegisteringClient;
import org.apache.airavata.client.secure.client.OAuthTokenRetrievalClient;
import org.apache.airavata.client.secure.client.Properties;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.GatewayApprovalStatus;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;

public class SecureClient {
    private static Logger logger = LoggerFactory.getLogger(SecureClient.class);

    public static void main(String[] args) throws Exception {
        String userNameInput;
        Scanner scanner = new Scanner(System.in);
        System.out.println("");
        System.out.println("Please select from the following options:");
        System.out.println("1. Register the client as an OAuth application.");
        System.out.println("2. Client is already registered. Use the existing credentials.");
        String opInput = scanner.next();
        int option = Integer.valueOf(opInput.trim());
        String consumerId = null;
        String consumerSecret = null;
        if (option == 1) {
            System.out.println("");
            System.out.println("Registering an OAuth application representing the client....");
            System.out.println("Please enter following information as you prefer, or use defaults.");
            System.out.println("OAuth application name: (default:" + Properties.appName + ", press 'd' to use default value.)");
            String appNameInput = scanner.next();
            String appName = null;
            appName = appNameInput.trim().equals("d") ? Properties.appName : appNameInput.trim();
            System.out.println("Consumer Id: (default:" + Properties.consumerID + ", press 'd' to use default value.)");
            String consumerIdInput = scanner.next();
            consumerId = consumerIdInput.trim().equals("d") ? Properties.consumerID : consumerIdInput.trim();
            System.out.println("Consumer Secret: (default:" + Properties.consumerSecret + ", press 'd' to use default value.)");
            String consumerSecInput = scanner.next();
            consumerSecret = consumerSecInput.trim().equals("d") ? Properties.consumerSecret : consumerSecInput.trim();
            try {
                ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
                OAuthAppRegisteringClient authAppRegisteringClient = new OAuthAppRegisteringClient(Properties.oauthAuthzServerURL, Properties.adminUserName, Properties.adminPassword, configContext);
                OAuthConsumerAppDTO appDTO = authAppRegisteringClient.registerApplication(appName, consumerId, consumerSecret);
                System.out.println("");
                System.out.println("Registered OAuth app successfully. Following is app's details:");
                System.out.println("App Name: " + appDTO.getApplicationName());
                System.out.println("Consumer ID: " + appDTO.getOauthConsumerKey());
                System.out.println("Consumer Secret: " + appDTO.getOauthConsumerSecret());
                System.out.println("");
            }
            catch (AiravataSecurityException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        } else if (option == 2) {
            System.out.println("");
            System.out.println("Enter Consumer Id: ");
            consumerId = scanner.next().trim();
            System.out.println("Enter Consumer Secret: ");
            consumerSecret = scanner.next().trim();
        }
        System.out.println("");
        System.out.println("Please select the preferred grant type: (or press d to use the default option" + Properties.grantType + ")");
        System.out.println("1. Resource Owner Password Credential.");
        System.out.println("2. Client Credential.");
        String grantTypeInput = scanner.next().trim();
        int grantType = 0;
        grantType = grantTypeInput.equals("d") ? Properties.grantType : Integer.valueOf(grantTypeInput);
        String userName = null;
        String password = null;
        if (grantType == 1) {
            System.out.println("Obtaining OAuth access token via 'Resource Owner Password' grant type....");
            System.out.println("Please enter following information as you prefer, or use defaults.");
            System.out.println("End user's name: (default:" + Properties.userName + ", press 'd' to use default value.)");
            userNameInput = scanner.next();
            userName = userNameInput.trim().equals("d") ? Properties.userName : userNameInput.trim();
            System.out.println("End user's password: (default:" + Properties.password + ", press 'd' to use default value.)");
            String passwordInput = scanner.next();
            password = passwordInput.trim().equals("d") ? Properties.password : passwordInput.trim();
        } else if (grantType == 2) {
            System.out.println("");
            System.out.println("Please enter the user name to be passed: ");
            userNameInput = scanner.next();
            userName = userNameInput.trim();
            System.out.println("");
            System.out.println("Obtaining OAuth access token via 'Client Credential' grant type...' grant type....");
        }
        try {
            String accessToken = new OAuthTokenRetrievalClient().retrieveAccessToken(consumerId, consumerSecret, userName, password, grantType);
            System.out.println("");
            System.out.println("OAuth access token is: " + accessToken);
            System.out.println("");
            System.out.println("Invoking Airavata API...");
            System.out.println("Enter the access token to be used: (default:" + accessToken + ", press 'd' to use default value.)");
            String accessTokenInput = scanner.next();
            String acTk = null;
            acTk = accessTokenInput.trim().equals("d") ? accessToken : accessTokenInput.trim();
            System.out.println("");
            System.out.println("Enter the number corresponding to the method to be invoked: ");
            System.out.println("1. getAPIVersion");
            System.out.println("2. getAllAppModules");
            System.out.println("3. addGateway");
            String methodNumberString = scanner.next();
            int methodNumber = Integer.valueOf(methodNumberString.trim());
            Airavata.Client client = SecureClient.createAiravataClient("localhost", 9930);
            AuthzToken authzToken = new AuthzToken();
            authzToken.setAccessToken(acTk);
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            claimsMap.put("userName", userName);
            claimsMap.put("email", "hasini@gmail.com");
            authzToken.setClaimsMap(claimsMap);
            if (methodNumber == 1) {
                String version = client.getAPIVersion(authzToken);
                System.out.println("");
                System.out.println("Airavata API version: " + version);
                System.out.println("");
            } else if (methodNumber == 2) {
                System.out.println("");
                System.out.println("Enter the gateway id: ");
                String gatewayId = scanner.next().trim();
                List appModules = client.getAllAppModules(authzToken, gatewayId);
                System.out.println("Output of getAllAppModuels: ");
                for (ApplicationModule appModule : appModules) {
                    System.out.println(appModule.getAppModuleName());
                }
                System.out.println("");
                System.out.println("");
            } else if (methodNumber == 3) {
                System.out.println("");
                System.out.println("Enter the gateway id: ");
                String gatewayId = scanner.next().trim();
                Gateway gateway = new Gateway(gatewayId, GatewayApprovalStatus.REQUESTED);
                gateway.setDomain("airavata.org");
                gateway.setEmailAddress("airavata@apache.org");
                gateway.setGatewayName("airavataGW");
                String output = client.addGateway(authzToken, gateway);
                System.out.println("");
                System.out.println("Output of addGateway: " + output);
                System.out.println("");
            }
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        catch (AiravataSecurityException e) {
            e.printStackTrace();
        }
    }

    public static Airavata.Client createAiravataClient(String serverHost, int serverPort) throws AiravataClientException {
        Airavata.Client client = AiravataClientFactory.createAiravataSecureClient((String)serverHost, (int)serverPort, (String)"../../../../../airavata/modules/configuration/server/src/main/resources/client_truststore.jks", (String)"airavata", (int)10000);
        return client;
    }
}

