/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.api.server.util;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClientPool<T extends TServiceClient>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftClientPool.class);
    private final GenericObjectPool internalPool;

    public ThriftClientPool(ClientFactory<T> clientFactory, GenericObjectPool.Config poolConfig, String host, int port) {
        this(clientFactory, new BinaryOverSocketProtocolFactory(host, port), poolConfig);
    }

    public ThriftClientPool(ClientFactory<T> clientFactory, ProtocolFactory protocolFactory, GenericObjectPool.Config poolConfig) {
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new ThriftClientFactory(clientFactory, protocolFactory), poolConfig);
    }

    public T getResource() {
        try {
            return (T)((TServiceClient)this.internalPool.borrowObject());
        }
        catch (Exception e) {
            throw new ThriftClientException("Could not get a resource from the pool", e);
        }
    }

    public void returnResourceObject(T resource) {
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new ThriftClientException("Could not return the resource to the pool", e);
        }
    }

    public void returnBrokenResource(T resource) {
        this.returnBrokenResourceObject(resource);
    }

    public void returnResource(T resource) {
        this.returnResourceObject(resource);
    }

    protected void returnBrokenResourceObject(T resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new ThriftClientException("Could not return the resource to the pool", e);
        }
    }

    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new ThriftClientException("Could not destroy the pool", e);
        }
    }

    public static class ThriftClientException
    extends RuntimeException {
        private static final long serialVersionUID = -2275296727467192665L;

        public ThriftClientException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class BinaryOverSocketProtocolFactory
    implements ProtocolFactory {
        private String host;
        private int port;

        public BinaryOverSocketProtocolFactory(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        public TProtocol make() {
            TSocket transport = new TSocket(this.host, this.port);
            try {
                transport.open();
            }
            catch (TTransportException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                throw new ThriftClientException("Can not make protocol", (Exception)((Object)e));
            }
            return new TBinaryProtocol((TTransport)transport);
        }
    }

    public static interface ProtocolFactory {
        public TProtocol make();
    }

    public static interface ClientFactory<T> {
        public T make(TProtocol var1);
    }

    class ThriftClientFactory
    extends BasePoolableObjectFactory {
        private ClientFactory<T> clientFactory;
        private ProtocolFactory protocolFactory;

        public ThriftClientFactory(ClientFactory<T> clientFactory, ProtocolFactory protocolFactory) {
            this.clientFactory = clientFactory;
            this.protocolFactory = protocolFactory;
        }

        public T makeObject() throws Exception {
            try {
                TProtocol protocol = this.protocolFactory.make();
                return (TServiceClient)this.clientFactory.make(protocol);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                throw new ThriftClientException("Can not make a new object for pool", e);
            }
        }

        public void destroyObject(T obj) throws Exception {
            if (obj.getOutputProtocol().getTransport().isOpen()) {
                obj.getOutputProtocol().getTransport().close();
            }
            if (obj.getInputProtocol().getTransport().isOpen()) {
                obj.getInputProtocol().getTransport().close();
            }
        }
    }
}

