/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.SSHApiException;
import org.apache.airavata.gfac.core.authentication.AuthenticationInfo;
import org.apache.airavata.gfac.core.cluster.ServerInfo;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.JobSubmissionTask;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.gfac.impl.SSHUtils;
import org.apache.airavata.gfac.impl.task.TaskUtils;
import org.apache.airavata.gfac.impl.task.utils.bes.DataTransferrer;
import org.apache.airavata.gfac.impl.task.utils.bes.JSDLGenerator;
import org.apache.airavata.gfac.impl.task.utils.bes.SecurityUtils;
import org.apache.airavata.gfac.impl.task.utils.bes.StorageCreator;
import org.apache.airavata.gfac.impl.task.utils.bes.UNICORESecurityContext;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.xmlbeans.XmlCursor;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESJobSubmissionTask
implements JobSubmissionTask {
    private static final Logger log = LoggerFactory.getLogger(BESJobSubmissionTask.class);
    private DefaultClientConfiguration secProperties;
    private String jobId;
    private String hostName;
    private String userName;
    private String inputPath;
    private int DEFAULT_SSH_PORT = 22;
    private AuthenticationInfo authenticationInfo;

    public JobStatus cancel(TaskContext taskcontext) throws TaskException {
        return null;
    }

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        StorageClient sc = null;
        ProcessContext processContext = taskContext.getParentProcessContext();
        this.setInputOutputLocations(processContext);
        try {
            this.secProperties = this.getSecurityConfig(processContext);
        }
        catch (GFacException e) {
            String msg = "Unicorn security context initialization error";
            log.error(msg, (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
            taskStatus.setReason(msg);
            return taskStatus;
        }
        try {
            JobSubmissionProtocol protocol = processContext.getJobSubmissionProtocol();
            JobSubmissionInterface jobSubmissionInterface = GFacUtils.getPreferredJobSubmissionInterface((ProcessContext)processContext);
            String factoryUrl = null;
            if (protocol.equals((Object)JobSubmissionProtocol.UNICORE)) {
                UnicoreJobSubmission unicoreJobSubmission = GFacUtils.getUnicoreJobSubmission((String)jobSubmissionInterface.getJobSubmissionInterfaceId());
                factoryUrl = unicoreJobSubmission.getUnicoreEndPointURL();
            }
            EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
            eprt.addNewAddress().setStringValue(factoryUrl);
            String userDN = processContext.getProcessModel().getUserDn();
            CreateActivityDocument cad = CreateActivityDocument.Factory.newInstance();
            StorageCreator storageCreator = new StorageCreator(this.secProperties, factoryUrl, 5, null);
            sc = storageCreator.createStorage();
            JobDefinitionType jobDefinition = JSDLGenerator.buildJSDLInstance(processContext, sc.getUrl()).getJobDefinition();
            cad.addNewCreateActivity().addNewActivityDocument().setJobDefinition(jobDefinition);
            log.info("Submitted JSDL: " + jobDefinition.getJobDescription());
            this.copyInputFilesToLocal(taskContext);
            DataTransferrer dt = new DataTransferrer(processContext, sc);
            dt.uploadLocalFiles();
            JobModel jobDetails = new JobModel();
            jobDetails.setTaskId(taskContext.getTaskId());
            jobDetails.setProcessId(taskContext.getProcessId());
            FactoryClient factory = new FactoryClient(eprt, (IClientConfiguration)this.secProperties);
            log.info("Activity Submitting to {} ... \n", (Object)factoryUrl);
            CreateActivityResponseDocument response = factory.createActivity(cad);
            log.info("Activity Submitted to {} ... \n", (Object)factoryUrl);
            EndpointReferenceType activityEpr = response.getCreateActivityResponse().getActivityIdentifier();
            log.info("Activity : " + activityEpr.getAddress().getStringValue() + " Submitted.");
            this.jobId = WSUtilities.extractResourceID((EndpointReferenceType)activityEpr);
            if (this.jobId == null) {
                this.jobId = new Long(Calendar.getInstance().getTimeInMillis()).toString();
            }
            log.info("JobID: " + this.jobId);
            jobDetails.setJobId(this.jobId);
            jobDetails.setJobDescription(activityEpr.toString());
            jobDetails.setJobStatuses(Arrays.asList(new JobStatus(JobState.SUBMITTED)));
            processContext.setJobModel(jobDetails);
            GFacUtils.saveJobModel((ProcessContext)processContext, (JobModel)jobDetails);
            GFacUtils.saveJobStatus((ProcessContext)processContext, (JobModel)jobDetails);
            log.info(this.formatStatusMessage(activityEpr.getAddress().getStringValue(), factory.getActivityStatus(activityEpr).toString()));
            this.waitUntilDone(eprt, activityEpr, processContext, this.secProperties);
            ActivityStatusType activityStatus = null;
            activityStatus = this.getStatus(factory, activityEpr);
            log.info(this.formatStatusMessage(activityEpr.getAddress().getStringValue(), activityStatus.getState().toString()));
            ActivityClient activityClient = new ActivityClient(activityEpr, (IClientConfiguration)this.secProperties);
            dt.setStorageClient(activityClient.getUspaceClient());
            List<OutputDataObjectType> copyOutput = null;
            if (activityStatus.getState() == ActivityStateEnumeration.FAILED) {
                String error = activityStatus.getFault().getFaultcode().getLocalPart() + "\n" + activityStatus.getFault().getFaultstring() + "\n EXITCODE: " + activityStatus.getExitCode();
                log.error(error);
                JobState applicationJobStatus = JobState.FAILED;
                jobDetails.setJobStatuses(Arrays.asList(new JobStatus(applicationJobStatus)));
                this.sendNotification(processContext, jobDetails);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.debug("Downloading any standard output and error files, if they were produced.");
                copyOutput = dt.downloadRemoteFiles();
            } else {
                if (activityStatus.getState() == ActivityStateEnumeration.CANCELLED) {
                    JobState applicationJobStatus = JobState.CANCELED;
                    jobDetails.setJobStatuses(Arrays.asList(new JobStatus(applicationJobStatus)));
                    GFacUtils.saveJobStatus((ProcessContext)processContext, (JobModel)jobDetails);
                    throw new GFacException(processContext.getExperimentId() + "Job Canceled");
                }
                if (activityStatus.getState() == ActivityStateEnumeration.FINISHED) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException applicationJobStatus) {
                        // empty catch block
                    }
                    JobState applicationJobStatus = JobState.COMPLETE;
                    jobDetails.setJobStatuses(Arrays.asList(new JobStatus(applicationJobStatus)));
                    GFacUtils.saveJobStatus((ProcessContext)processContext, (JobModel)jobDetails);
                    log.info("Job Id: {}, exit code: {}, exit status: {}", new Object[]{jobDetails.getJobId(), activityStatus.getExitCode(), ActivityStateEnumeration.FINISHED.toString()});
                    copyOutput = dt.downloadRemoteFiles();
                }
            }
            if (copyOutput != null) {
                this.copyOutputFilesToStorage(taskContext, copyOutput);
                for (OutputDataObjectType outputDataObjectType : copyOutput) {
                    GFacUtils.saveExperimentOutput((ProcessContext)processContext, (String)outputDataObjectType.getName(), (String)outputDataObjectType.getValue());
                }
            }
            taskStatus.setState(TaskState.COMPLETED);
        }
        catch (AppCatalogException e) {
            log.error("Error while retrieving UNICORE job submission..", (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
        }
        catch (Exception e) {
            log.error("BES task failed... ", (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
        }
        return taskStatus;
    }

    private void copyOutputFilesToStorage(TaskContext taskContext, List<OutputDataObjectType> copyOutput) throws GFacException {
        ProcessContext pc = taskContext.getParentProcessContext();
        String remoteFilePath = null;
        String fileName = null;
        String localFilePath = null;
        try {
            this.authenticationInfo = Factory.getStorageSSHKeyAuthentication(pc);
            ServerInfo serverInfo = pc.getComputeResourceServerInfo();
            Session sshSession = Factory.getSSHSession(this.authenticationInfo, serverInfo);
            for (OutputDataObjectType output : copyOutput) {
                switch (output.getType()) {
                    case STDERR: 
                    case STDOUT: 
                    case STRING: 
                    case URI: {
                        localFilePath = output.getValue();
                        if (localFilePath.contains("://")) {
                            localFilePath = localFilePath.substring(localFilePath.indexOf("://") + 2, localFilePath.length());
                        }
                        fileName = localFilePath.substring(localFilePath.lastIndexOf("/") + 1);
                        URI destinationURI = TaskUtils.getDestinationURI(taskContext, this.hostName, this.inputPath, fileName);
                        remoteFilePath = destinationURI.getPath();
                        log.info("SCP local file :{} -> from remote :{}", (Object)localFilePath, (Object)remoteFilePath);
                        SSHUtils.scpTo(localFilePath, remoteFilePath, sshSession);
                        output.setValue(destinationURI.toString());
                        break;
                    }
                }
            }
        }
        catch (JSchException | IOException | URISyntaxException | CredentialStoreException | SSHApiException e) {
            log.error("Error while coping local file " + localFilePath + " to remote " + remoteFilePath, e);
            throw new GFacException("Error while scp output files to remote storage file location", e);
        }
    }

    private void copyInputFilesToLocal(TaskContext taskContext) throws GFacException {
        ProcessContext pc = taskContext.getParentProcessContext();
        StorageResourceDescription storageResource = pc.getStorageResource();
        if (storageResource == null) {
            throw new GFacException("Storage Resource is null");
        }
        this.hostName = storageResource.getHostName();
        this.inputPath = pc.getStorageFileSystemRootLocation();
        this.inputPath = this.inputPath.endsWith(File.separator) ? this.inputPath : this.inputPath + File.separator;
        String remoteFilePath = null;
        String fileName = null;
        String localFilePath = null;
        URI remoteFileURI = null;
        try {
            this.authenticationInfo = Factory.getStorageSSHKeyAuthentication(pc);
            ServerInfo serverInfo = pc.getStorageResourceServerInfo();
            Session sshSession = Factory.getSSHSession(this.authenticationInfo, serverInfo);
            List processInputs = pc.getProcessModel().getProcessInputs();
            for (InputDataObjectType input : processInputs) {
                if (input.getType() != DataType.URI) continue;
                remoteFileURI = new URI(input.getValue());
                remoteFilePath = remoteFileURI.getPath();
                fileName = remoteFilePath.substring(remoteFilePath.lastIndexOf("/") + 1);
                localFilePath = pc.getInputDir() + File.separator + fileName;
                log.info("SCP remote file :{} -> to local :{}", (Object)remoteFilePath, (Object)localFilePath);
                SSHUtils.scpFrom(remoteFilePath, localFilePath, sshSession);
                input.setValue("file:/" + localFilePath);
            }
        }
        catch (JSchException | IOException | URISyntaxException | SSHApiException e) {
            log.error("Error while coping remote file " + remoteFilePath + " to local " + localFilePath, e);
            throw new GFacException("Error while scp input files to local file location", e);
        }
        catch (CredentialStoreException e) {
            String msg = "Authentication issue, make sure you are passing valid credential token";
            log.error(msg, (Throwable)e);
            throw new GFacException(msg, (Throwable)e);
        }
    }

    private void setInputOutputLocations(ProcessContext processContext) {
        String localPath = System.getProperty("java.io.tmpdir") + File.separator + processContext.getProcessId();
        new File(localPath).mkdir();
        processContext.setInputDir(localPath);
        processContext.setOutputDir(localPath);
    }

    private DefaultClientConfiguration getSecurityConfig(ProcessContext pc) throws GFacException {
        DefaultClientConfiguration clientConfig = null;
        try {
            UNICORESecurityContext unicoreSecurityContext = SecurityUtils.getSecurityContext(pc);
            UserConfigurationDataModel userConfigDataModel = (UserConfigurationDataModel)pc.getExperimentCatalog().get(ExperimentCatalogModelType.USER_CONFIGURATION_DATA, (Object)pc.getExperimentId());
            userConfigDataModel.setGenerateCert(true);
            clientConfig = userConfigDataModel.isGenerateCert() ? unicoreSecurityContext.getDefaultConfiguration(false, userConfigDataModel) : unicoreSecurityContext.getDefaultConfiguration(false);
        }
        catch (RegistryException e) {
            throw new GFacException("Error! reading user configuration data from registry", (Throwable)e);
        }
        catch (ApplicationSettingsException e) {
            throw new GFacException("Error! retrieving default client configurations", (Throwable)e);
        }
        return clientConfig;
    }

    protected String formatStatusMessage(String activityUrl, String status) {
        return String.format("Activity %s is %s.\n", activityUrl, status);
    }

    protected void waitUntilDone(EndpointReferenceType factoryEpr, EndpointReferenceType activityEpr, ProcessContext processContext, DefaultClientConfiguration secProperties) throws Exception {
        try {
            FactoryClient factoryClient = new FactoryClient(factoryEpr, (IClientConfiguration)secProperties);
            JobState applicationJobStatus = null;
            ActivityStateEnumeration.Enum activityStatus = factoryClient.getActivityStatus(activityEpr);
            while (activityStatus != ActivityStateEnumeration.FINISHED && activityStatus != ActivityStateEnumeration.FAILED && activityStatus != ActivityStateEnumeration.CANCELLED && applicationJobStatus != JobState.COMPLETE) {
                ActivityStatusType activityStatusType = this.getStatus(factoryClient, activityEpr);
                applicationJobStatus = this.getApplicationJobStatus(activityStatusType);
                this.sendNotification(processContext, processContext.getJobModel());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                activityStatus = factoryClient.getActivityStatus(activityEpr);
            }
        }
        catch (Exception e) {
            log.error("Error monitoring job status..");
            throw e;
        }
    }

    private void sendNotification(ProcessContext processContext, JobModel jobModel) throws GFacException {
        GFacUtils.saveJobStatus((ProcessContext)processContext, (JobModel)jobModel);
    }

    public TaskStatus recover(TaskContext taskContext) {
        return this.execute(taskContext);
    }

    public TaskTypes getType() {
        return TaskTypes.JOB_SUBMISSION;
    }

    protected ActivityStatusType getStatus(FactoryClient fc, EndpointReferenceType activityEpr) throws UnknownActivityIdentifierFault {
        GetActivityStatusesDocument stats = GetActivityStatusesDocument.Factory.newInstance();
        stats.addNewGetActivityStatuses().setActivityIdentifierArray(new EndpointReferenceType[]{activityEpr});
        GetActivityStatusesResponseDocument resDoc = fc.getActivityStatuses(stats);
        ActivityStatusType activityStatus = resDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus();
        return activityStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobState getApplicationJobStatus(ActivityStatusType activityStatus) {
        if (activityStatus == null) {
            return JobState.UNKNOWN;
        }
        ActivityStateEnumeration.Enum state = activityStatus.getState();
        String status = null;
        XmlCursor acursor = activityStatus.newCursor();
        try {
            if (acursor.toFirstChild() && acursor.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) {
                status = acursor.getName().getLocalPart();
            }
            if (status != null) {
                if (status.equalsIgnoreCase("Queued") || status.equalsIgnoreCase("Starting") || status.equalsIgnoreCase("Ready")) {
                    JobState jobState = JobState.QUEUED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Staging-In")) {
                    JobState jobState = JobState.SUBMITTED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("FINISHED")) {
                    JobState jobState = JobState.COMPLETE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Staging-Out")) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Executing")) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("FAILED")) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("CANCELLED")) {
                    JobState jobState = JobState.CANCELED;
                    return jobState;
                }
            } else {
                if (ActivityStateEnumeration.CANCELLED.equals(state)) {
                    JobState jobState = JobState.CANCELED;
                    return jobState;
                }
                if (ActivityStateEnumeration.FAILED.equals(state)) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
                if (ActivityStateEnumeration.FINISHED.equals(state)) {
                    JobState jobState = JobState.COMPLETE;
                    return jobState;
                }
                if (ActivityStateEnumeration.RUNNING.equals(state)) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
            }
        }
        finally {
            if (acursor != null) {
                acursor.dispose();
            }
        }
        return JobState.UNKNOWN;
    }

    public boolean cancelJob(ProcessContext processContext) throws GFacException {
        try {
            String activityEpr = processContext.getJobModel().getJobDescription();
            EndpointReferenceType eprt = EndpointReferenceType.Factory.parse((String)activityEpr);
            JobSubmissionProtocol protocol = processContext.getJobSubmissionProtocol();
            String interfaceId = processContext.getApplicationInterfaceDescription().getApplicationInterfaceId();
            String factoryUrl = null;
            if (protocol.equals((Object)JobSubmissionProtocol.UNICORE)) {
                UnicoreJobSubmission unicoreJobSubmission = GFacUtils.getUnicoreJobSubmission((String)interfaceId);
                factoryUrl = unicoreJobSubmission.getUnicoreEndPointURL();
            }
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(factoryUrl);
            FactoryClient factory = new FactoryClient(epr, (IClientConfiguration)this.secProperties);
            factory.terminateActivity(eprt);
            return true;
        }
        catch (Exception e) {
            throw new GFacException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

