/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.aries.jndi.spi.EnvironmentAugmentation;
import org.apache.aries.jndi.startup.Activator;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static final Comparator<ServiceReference> SERVICE_REFERENCE_COMPARATOR = new ServiceReferenceComparator();
    public static final MessageUtil MESSAGES = MessageUtil.createMessageUtil(Utils.class, (String)"org.apache.aries.jndi.nls.jndiMessages");

    private Utils() {
        throw new RuntimeException();
    }

    public static BundleContext getBundleContext(final Map<?, ?> env, final Class<?> namingClass) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){

            @Override
            public BundleContext run() {
                return Utils.doGetBundleContext(env, namingClass);
            }
        });
    }

    private static BundleContext doGetBundleContext(Map<?, ?> env, Class<?> namingClass) {
        Object bc;
        BundleContext result = null;
        Object v0 = bc = env == null ? null : env.get("osgi.service.jndi.bundleContext");
        if (bc != null && bc instanceof BundleContext) {
            result = bc;
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = Utils.getBundleContext(cl);
        }
        if (result == null) {
            int i;
            StackFinder finder = new StackFinder();
            Class<?>[] classStack = finder.getClassContext();
            for (i = classStack.length - 1; i >= 0 && !namingClass.isAssignableFrom(classStack[i]); --i) {
            }
            ++i;
            while (i < classStack.length && result == null) {
                result = Utils.getBundleContext(classStack[i].getClassLoader());
                ++i;
            }
        }
        return result;
    }

    private static BundleContext getBundleContext(ClassLoader cl2) {
        ClassLoader cl = cl2;
        BundleContext result = null;
        while (result == null && cl != null) {
            if (cl instanceof BundleReference) {
                Bundle b = ((BundleReference)cl).getBundle();
                result = b.getBundleContext();
                if (result != null) continue;
                try {
                    b.start();
                    result = b.getBundleContext();
                }
                catch (BundleException e) {}
                break;
            }
            if (cl == null) continue;
            cl = cl.getParent();
        }
        return result;
    }

    public static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    public static Hashtable<?, ?> toHashtable(Map<?, ?> map) {
        Hashtable<Object, Object> env = map instanceof Hashtable ? (Hashtable)map : (map == null ? new Hashtable() : new Hashtable(map));
        return env;
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws Exception {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            throw cause;
        }
    }

    public static <T> T doPrivilegedNaming(PrivilegedExceptionAction<T> action) throws NamingException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException ex = new NamingException(cause.getMessage());
            ex.initCause(cause);
            throw ex;
        }
    }

    public static ServiceReference[] getReferencesPrivileged(final BundleContext ctx, final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceReference[]>(){

            @Override
            public ServiceReference[] run() {
                try {
                    return ctx.getServiceReferences(clazz.getName(), null);
                }
                catch (InvalidSyntaxException ise) {
                    throw new RuntimeException(MESSAGES.getMessage("null.is.invalid.filter", new Object[0]), ise);
                }
            }
        });
    }

    public static Object getServicePrivileged(final BundleContext ctx, final ServiceReference ref) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ctx.getService(ref);
            }
        });
    }

    public static void augmentEnvironment(Hashtable<?, ?> environment) {
        Object[] objects = Activator.getEnvironmentAugmentors();
        if (objects != null) {
            for (Object obj : objects) {
                if (!(obj instanceof EnvironmentAugmentation)) continue;
                ((EnvironmentAugmentation)obj).augmentEnvironment(environment);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceReferenceComparator
    implements Comparator<ServiceReference> {
        private ServiceReferenceComparator() {
        }

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o2.compareTo((Object)o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackFinder
    extends SecurityManager {
        private StackFinder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

