/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.internal.AbstractCapability;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.Resolver;

public class DependencyCalculator {
    private final ResolveContext context;

    public DependencyCalculator(Collection<Resource> resources) {
        this.context = new ResolveContext(resources);
    }

    public List<Requirement> calculateDependencies() throws ResolutionException {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        Resolver resolver = Activator.getInstance().getResolver();
        Map resolution = resolver.resolve((org.osgi.service.resolver.ResolveContext)this.context);
        for (List wires : resolution.values()) {
            for (Wire wire : wires) {
                if (!(wire.getCapability() instanceof MissingCapability)) continue;
                result.add(wire.getRequirement());
            }
        }
        result.trimToSize();
        return result;
    }

    private static class MissingCapability
    extends AbstractCapability {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Requirement requirement;

        public MissingCapability(Requirement requirement) {
            this.requirement = requirement;
            this.initializeAttributes();
        }

        public Map<String, Object> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        public Map<String, String> getDirectives() {
            return Collections.emptyMap();
        }

        public String getNamespace() {
            return this.requirement.getNamespace();
        }

        public Resource getResource() {
            return Resource.INSTANCE;
        }

        private void initializeAttributes() {
            String filter = (String)this.requirement.getDirectives().get("filter");
            if (filter == null) {
                return;
            }
            Pattern pattern = Pattern.compile("\\(([^<>~(=]+)(?:=|<=|>=|~=)([^)]+)\\)");
            Matcher matcher = pattern.matcher(filter);
            while (matcher.find()) {
                this.attributes.put(matcher.group(1), matcher.group(2));
            }
        }

        private static class Resource
        implements org.osgi.resource.Resource {
            public static final Resource INSTANCE = new Resource();
            private final Capability identity;

            public Resource() {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("osgi.identity", "org.apache.aries.subsystem.resource.synthesized");
                attributes.put("type", "org.apache.aries.subsystem.resource.synthesized");
                this.identity = new BasicCapability("osgi.identity", attributes, null, this);
            }

            public List<Capability> getCapabilities(String namespace) {
                return Collections.singletonList(this.identity);
            }

            public List<Requirement> getRequirements(String namespace) {
                return Collections.emptyList();
            }
        }
    }

    private static class ResolveContext
    extends org.osgi.service.resolver.ResolveContext {
        private final Collection<Resource> resources;

        public ResolveContext(Collection<Resource> resources) {
            this.resources = resources;
        }

        public List<Capability> findProviders(Requirement requirement) {
            ArrayList<Capability> capabilities = new ArrayList<Capability>();
            for (Resource resource : this.resources) {
                for (Capability capability : resource.getCapabilities(requirement.getNamespace())) {
                    if (!ResourceHelper.matches(requirement, capability)) continue;
                    capabilities.add(capability);
                }
            }
            if (capabilities.isEmpty()) {
                capabilities.add(new MissingCapability(requirement));
            }
            capabilities.trimToSize();
            return capabilities;
        }

        public boolean isEffective(Requirement requirement) {
            return true;
        }

        public Collection<Resource> getMandatoryResources() {
            return this.resources;
        }

        public Map<Resource, Wiring> getWirings() {
            return Collections.emptyMap();
        }

        public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
            capabilities.add((Capability)hostedCapability);
            return capabilities.size() - 1;
        }
    }
}

