/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tranql.connector.AbstractManagedConnection;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.TranqlDataSource;

public final class ValidatingDelegatingManagedConnectionFactory
implements UserPasswordManagedConnectionFactory,
ValidatingManagedConnectionFactory,
TransactionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingDelegatingManagedConnectionFactory.class);
    private final ManagedConnectionFactory delegate;

    public ValidatingDelegatingManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.delegate = managedConnectionFactory;
    }

    private boolean isValidConnection(Connection c) {
        try {
            if (c.isValid(0)) {
                LOG.debug("Connection validation succeeded for managed connection {}.", (Object)c);
                return true;
            }
            LOG.debug("Connection validation failed for managed connection {}.", (Object)c);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return ((TransactionSupport)TransactionSupport.class.cast(this.delegate)).getTransactionSupport();
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        HashSet<AbstractManagedConnection> invalid = new HashSet<AbstractManagedConnection>();
        for (Object o : connectionSet) {
            AbstractManagedConnection amc;
            if (!(o instanceof AbstractManagedConnection) || this.isValidConnection((Connection)(amc = (AbstractManagedConnection)AbstractManagedConnection.class.cast(o)).getPhysicalConnection())) continue;
            invalid.add(amc);
        }
        return invalid;
    }

    @Override
    public String getUserName() {
        return ((UserPasswordManagedConnectionFactory)UserPasswordManagedConnectionFactory.class.cast(this.delegate)).getUserName();
    }

    @Override
    public String getPassword() {
        return ((UserPasswordManagedConnectionFactory)UserPasswordManagedConnectionFactory.class.cast(this.delegate)).getPassword();
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new TranqlDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.delegate.createManagedConnection(subject, cxRequestInfo);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        for (Object o : connectionSet) {
            ManagedConnectionHandle mch;
            if (!(o instanceof ManagedConnectionHandle) || !(mch = (ManagedConnectionHandle)ManagedConnectionHandle.class.cast(o)).matches(this, subject, cxRequestInfo)) continue;
            if (mch instanceof AbstractManagedConnection) {
                AbstractManagedConnection amc = (AbstractManagedConnection)AbstractManagedConnection.class.cast(mch);
                if (!this.isValidConnection((Connection)amc.getPhysicalConnection())) continue;
                return amc;
            }
            return mch;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.delegate.setLogWriter(out);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.delegate.getLogWriter();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }
}

