/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.apache.hadoop.fs.Path;

public class RecordCountTool
implements Tool {
    @Override
    public String getName() {
        return "count";
    }

    @Override
    public String getShortDescription() {
        return "Counts the records in avro files or folders";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optionParser = new OptionParser();
        OptionSet optionSet = optionParser.parse(args.toArray(new String[0]));
        List nargs = optionSet.nonOptionArguments();
        if (nargs.isEmpty()) {
            this.printHelp(err);
            err.println();
            optionParser.printHelpOn((OutputStream)err);
            return 0;
        }
        long count = 0L;
        if (ImmutableList.of((Object)"-").equals((Object)nargs)) {
            count = this.countRecords(stdin);
        } else {
            for (Path file : Util.getFiles(nargs)) {
                InputStream inStream = Util.openFromFS(file);
                Throwable throwable = null;
                try {
                    count += this.countRecords(inStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inStream == null) continue;
                    if (throwable != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inStream.close();
                }
            }
        }
        out.println(count);
        out.flush();
        return 0;
    }

    private long countRecords(InputStream inStream) throws IOException {
        long count = 0L;
        try (DataFileStream streamReader = new DataFileStream(inStream, (DatumReader)new GenericDatumReader());){
            while (streamReader.hasNext()) {
                count += streamReader.getBlockCount();
                streamReader.nextBlock();
            }
        }
        return count;
    }

    private void printHelp(PrintStream ps) {
        ps.println(this.getName() + " [input-files...]");
        ps.println();
        ps.println(this.getShortDescription());
        ps.println("A dash ('-') can be given as an input-file to use stdin");
    }
}

