/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class SmallLongTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            e.writeLong((long)state.testData[i + 0]);
            e.writeLong((long)state.testData[i + 1]);
            e.writeLong((long)state.testData[i + 2]);
            e.writeLong((long)state.testData[i + 3]);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public int decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        int total = 0;
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            total = (int)((long)total + d.readLong());
            total = (int)((long)total + d.readLong());
            total = (int)((long)total + d.readLong());
            total = (int)((long)total + d.readLong());
        }
        return total;
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private int[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new int[this.getBatchSize()];
            for (int i = 0; i < this.testData.length; i += 4) {
                this.testData[i + 0] = super.getRandom().nextInt(50);
                this.testData[i + 1] = super.getRandom().nextInt(5000);
                this.testData[i + 2] = super.getRandom().nextInt(500000);
                this.testData[i + 3] = super.getRandom().nextInt(150000000);
            }
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            for (int i = 0; i < this.getBatchSize(); i += 4) {
                encoder.writeInt(super.getRandom().nextInt(50));
                encoder.writeInt(super.getRandom().nextInt(5000));
                encoder.writeInt(super.getRandom().nextInt(500000));
                encoder.writeInt(super.getRandom().nextInt(150000000));
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }
}

