/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message;

import javax.xml.namespace.QName;

public class XMLFaultCode {
    public static final XMLFaultCode SENDER = new XMLFaultCode(){

        @Override
        public QName toQName(String namespace) {
            String localPart = namespace.equals("http://www.w3.org/2003/05/soap-envelope") ? "Sender" : "Client";
            return new QName(namespace, localPart);
        }
    };
    public static final XMLFaultCode RECEIVER = new XMLFaultCode(){

        @Override
        public QName toQName(String namespace) {
            String localPart = namespace.equals("http://www.w3.org/2003/05/soap-envelope") ? "Receiver" : "Server";
            return new QName(namespace, localPart);
        }
    };
    public static final XMLFaultCode MUSTUNDERSTAND = new XMLFaultCode(){

        @Override
        public QName toQName(String namespace) {
            return new QName(namespace, "MustUnderstand");
        }
    };
    public static final XMLFaultCode DATAENCODINGUNKNOWN = new XMLFaultCode(){

        @Override
        public QName toQName(String namespace) {
            String localPart = namespace.equals("http://www.w3.org/2003/05/soap-envelope") ? "DataEncodingUnknown" : "Server";
            return new QName(namespace, localPart);
        }
    };
    public static final XMLFaultCode VERSIONMISMATCH = new XMLFaultCode(){

        @Override
        public QName toQName(String namespace) {
            return new QName(namespace, "VersionMismatch");
        }
    };
    private QName faultCode;

    private XMLFaultCode() {
    }

    public XMLFaultCode(QName faultCode) {
        if (faultCode == null) {
            throw new NullPointerException("Null fault code");
        }
        this.faultCode = faultCode;
    }

    public QName toQName(String protocolNamespace) {
        return this.faultCode;
    }

    public static XMLFaultCode fromQName(QName qName) {
        if (qName == null) {
            return RECEIVER;
        }
        String namespace = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        XMLFaultCode xmlFaultCode = null;
        xmlFaultCode = localPart.equalsIgnoreCase("Sender") ? SENDER : (localPart.equalsIgnoreCase("Receiver") ? RECEIVER : (localPart.equalsIgnoreCase("Client") ? SENDER : (localPart.equalsIgnoreCase("Server") ? RECEIVER : (localPart.equalsIgnoreCase("MustUnderstand") ? MUSTUNDERSTAND : (localPart.equalsIgnoreCase("DataEncodingUnknown") ? DATAENCODINGUNKNOWN : (localPart.equalsIgnoreCase("VersionMismatch") ? VERSIONMISMATCH : new XMLFaultCode(qName)))))));
        return xmlFaultCode;
    }
}

