/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.openjdk.tools.javac.parser.JavaTokenizer;
import org.openjdk.tools.javac.parser.Scanner;
import org.openjdk.tools.javac.parser.ScannerFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.parser.UnicodeReader;
import org.openjdk.tools.javac.util.Context;

class JavacTokens {
    private static final CharSequence EOF_COMMENT = "\n//EOF";

    JavacTokens() {
    }

    public static ImmutableList<RawTok> getTokens(String source, Context context, Set<Tokens.TokenKind> stopTokens) {
        if (source == null) {
            return ImmutableList.of();
        }
        ScannerFactory fac = ScannerFactory.instance((Context)context);
        char[] buffer = (source + EOF_COMMENT).toCharArray();
        AccessibleScanner scanner = new AccessibleScanner(fac, new CommentSavingTokenizer(fac, buffer, buffer.length));
        ImmutableList.Builder tokens = ImmutableList.builder();
        int end = source.length();
        int last = 0;
        do {
            scanner.nextToken();
            Tokens.Token t = scanner.token();
            if (t.comments != null) {
                for (Tokens.Comment c : Lists.reverse((List)t.comments)) {
                    if (last < c.getSourcePos(0)) {
                        tokens.add((Object)new RawTok(null, null, last, c.getSourcePos(0)));
                    }
                    tokens.add((Object)new RawTok(null, null, c.getSourcePos(0), c.getSourcePos(0) + c.getText().length()));
                    last = c.getSourcePos(0) + c.getText().length();
                }
            }
            if (stopTokens.contains(t.kind)) {
                if (t.kind == Tokens.TokenKind.EOF) break;
                end = t.pos;
                break;
            }
            if (last < t.pos) {
                tokens.add((Object)new RawTok(null, null, last, t.pos));
            }
            tokens.add((Object)new RawTok(t.kind == Tokens.TokenKind.STRINGLITERAL ? "\"" + t.stringVal() + "\"" : null, t.kind, t.pos, t.endPos));
            last = t.endPos;
        } while (scanner.token().kind != Tokens.TokenKind.EOF);
        if (last < end) {
            tokens.add((Object)new RawTok(null, null, last, end));
        }
        return tokens.build();
    }

    static class AccessibleReader
    extends UnicodeReader {
        protected AccessibleReader(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }
    }

    static class AccessibleScanner
    extends Scanner {
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super(fac, tokenizer);
        }
    }

    static class CommentWithTextAndPosition
    implements Tokens.Comment {
        private final int pos;
        private final int endPos;
        private final AccessibleReader reader;
        private final Tokens.Comment.CommentStyle style;
        private String text = null;

        public CommentWithTextAndPosition(int pos, int endPos, AccessibleReader reader, Tokens.Comment.CommentStyle style) {
            this.pos = pos;
            this.endPos = endPos;
            this.reader = reader;
            this.style = style;
        }

        public int getSourcePos(int index) {
            Preconditions.checkArgument((0 <= index && index < this.endPos - this.pos ? 1 : 0) != 0, (String)"Expected %s in the range [0, %s)", (int)index, (int)(this.endPos - this.pos));
            return this.pos + index;
        }

        public Tokens.Comment.CommentStyle getStyle() {
            return this.style;
        }

        public String getText() {
            String text = this.text;
            if (text == null) {
                this.text = text = new String(this.reader.getRawCharacters());
            }
            return text;
        }

        public boolean isDeprecated() {
            return false;
        }

        public String toString() {
            return String.format("Comment: '%s'", this.getText());
        }
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }

        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            char[] buf = this.reader.getRawCharacters(pos, endPos);
            return new CommentWithTextAndPosition(pos, endPos, new AccessibleReader(this.fac, buf, buf.length), style);
        }
    }

    static class RawTok {
        private final String stringVal;
        private final Tokens.TokenKind kind;
        private final int pos;
        private final int endPos;

        RawTok(String stringVal, Tokens.TokenKind kind, int pos, int endPos) {
            this.stringVal = stringVal;
            this.kind = kind;
            this.pos = pos;
            this.endPos = endPos;
        }

        public Tokens.TokenKind kind() {
            return this.kind;
        }

        public int pos() {
            return this.pos;
        }

        public int endPos() {
            return this.endPos;
        }

        public String stringVal() {
            return this.stringVal;
        }
    }
}

