/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import org.apache.axis2.tool.service.bean.LibrarySelectionBean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class LibraryAddingPage
extends AbstractServiceWizardPage {
    private Text libraryNameText;
    private Button browseButton;
    private Button addButton;
    private Button removeButton;
    private List jarFileList;
    private Label jarFilecountLabel;

    public LibraryAddingPage() {
        super("page6");
    }

    @Override
    protected void initializeDefaultSettings() {
        this.settings.put("LIB_NAMES", new String[0]);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.libraryNameText = new Text(container, 2048);
        this.libraryNameText.setLayoutData((Object)gd);
        this.libraryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        gd = new GridData(768);
        this.browseButton = new Button(container, 8);
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.setText(ServiceArchiver.getResourceString("general.browse"));
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                LibraryAddingPage.this.handleBrowse();
            }
        });
        gd = new GridData(768);
        this.addButton = new Button(container, 8);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.setText(ServiceArchiver.getResourceString("page6.add"));
        this.addButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                LibraryAddingPage.this.handleAdd();
            }
        });
        gd = new GridData(768);
        this.removeButton = new Button(container, 8);
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setText(ServiceArchiver.getResourceString("page6.remove"));
        this.removeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                LibraryAddingPage.this.handleRemove();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label dummyLabel = new Label(container, 0);
        dummyLabel.setText(ServiceArchiver.getResourceString("page6.liblist.caption"));
        dummyLabel.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 5;
        this.jarFileList = new List(container, 2560);
        this.jarFileList.setItems(this.settings.getArray("LIB_NAMES"));
        this.jarFileList.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.jarFilecountLabel = new Label(container, 0);
        this.jarFilecountLabel.setLayoutData((Object)gd);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void handleBrowse() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{"*.jar"});
        String returnFileName = fileDialog.open();
        if (returnFileName != null) {
            this.libraryNameText.setText(returnFileName);
        }
    }

    private void handleAdd() {
        String libName = this.libraryNameText.getText().trim();
        if (!libName.equals("")) {
            this.jarFileList.add(libName);
            this.updateList();
            this.libraryNameText.setText("");
        }
    }

    private void handleRemove() {
        int selectedIndex = this.jarFileList.getSelectionIndex();
        if (selectedIndex != -1) {
            this.jarFileList.remove(selectedIndex);
            this.updateList();
        }
    }

    private void updateList() {
        this.jarFilecountLabel.setText(this.jarFileList.getItemCount() + " " + ServiceArchiver.getResourceString("page6.liblist.count.caption"));
        this.settings.put("LIB_NAMES", this.jarFileList.getItems());
    }

    public LibrarySelectionBean getBean() {
        LibrarySelectionBean bean = new LibrarySelectionBean();
        bean.setFileList(this.jarFileList.getItems());
        return bean;
    }

    @Override
    protected boolean getWizardComplete() {
        return false;
    }
}

