/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.factory;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.json.factory.JSONType;
import org.apache.axis2.json.factory.JsonObject;
import org.apache.axis2.json.factory.XmlNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.XmlSchemaRef;

public class XmlNodeGenerator {
    private static final Log log = LogFactory.getLog(XmlNodeGenerator.class);
    List<XmlSchema> xmlSchemaList;
    QName elementQname;
    private XmlNode mainXmlNode;
    Queue<JsonObject> queue = new LinkedList<JsonObject>();
    Queue<JsonObject> attribute_queue = new LinkedList<JsonObject>();

    public XmlNodeGenerator(List<XmlSchema> xmlSchemaList, QName elementQname) {
        this.xmlSchemaList = xmlSchemaList;
        this.elementQname = elementQname;
    }

    public XmlNodeGenerator() {
    }

    private void processSchemaList() throws AxisFault {
        XmlSchema operationSchema = this.getXmlSchema(this.elementQname);
        XmlSchemaElement messageElement = operationSchema.getElementByName(this.elementQname.getLocalPart());
        this.mainXmlNode = new XmlNode(this.elementQname.getLocalPart(), this.elementQname.getNamespaceURI(), false, messageElement.getMaxOccurs() != 1L, "");
        QName messageSchemaTypeName = messageElement.getSchemaTypeName();
        XmlSchemaType schemaType = null;
        XmlSchema schemaOfType = null;
        if (messageSchemaTypeName != null) {
            schemaType = operationSchema.getTypeByName(messageSchemaTypeName);
            if (schemaType == null) {
                schemaOfType = this.getXmlSchema(messageSchemaTypeName);
                schemaType = schemaOfType.getTypeByName(messageSchemaTypeName.getLocalPart());
            } else {
                schemaOfType = operationSchema;
            }
        } else {
            schemaType = messageElement.getSchemaType();
            schemaOfType = operationSchema;
        }
        if (schemaType != null) {
            this.processSchemaType(schemaType, this.mainXmlNode, schemaOfType);
        }
    }

    private void processElement(XmlSchemaElement element, XmlNode parentNode, XmlSchema schema) throws AxisFault {
        log.debug((Object)("XmlNodeGenerator.processElement() found parentNode node name: " + parentNode.getName() + " , isAttribute: " + parentNode.isAttribute() + " , element name: " + element.getName()));
        String targetNamespace = schema.getTargetNamespace();
        QName schemaTypeName = element.getSchemaTypeName();
        XmlSchemaType schemaType = element.getSchemaType();
        if (schemaTypeName != null) {
            XmlNode xmlNode = new XmlNode(element.getName(), targetNamespace, false, element.getMaxOccurs() != 1L, schemaTypeName.getLocalPart());
            parentNode.addChildToList(xmlNode);
            if (!"http://www.w3.org/2001/XMLSchema".equals(schemaTypeName.getNamespaceURI())) {
                XmlSchema schemaOfType;
                XmlSchemaType childSchemaType = schema.getTypeByName(schemaTypeName.getLocalPart());
                if (childSchemaType == null) {
                    schemaOfType = this.getXmlSchema(schemaTypeName);
                    childSchemaType = schemaOfType.getTypeByName(schemaTypeName.getLocalPart());
                } else {
                    schemaOfType = schema;
                }
                this.processSchemaType(childSchemaType, xmlNode, schemaOfType);
            }
        } else if (schemaType != null) {
            XmlNode xmlNode = new XmlNode(element.getName(), targetNamespace, false, element.getMaxOccurs() != 1L, schemaType.getQName().getLocalPart());
            parentNode.addChildToList(xmlNode);
            this.processSchemaType(schemaType, xmlNode, schema);
        } else if (element.getRef() != null) {
            XmlSchemaRef xmlSchemaRef = element.getRef();
            QName targetQname = xmlSchemaRef.getTargetQName();
            if (targetQname == null) {
                throw new AxisFault("target QName is null while processing ref:" + element.getName());
            }
            this.getXmlSchema(targetQname);
            XmlNode xmlNode = new XmlNode(targetQname.getLocalPart(), targetNamespace, false, element.getMaxOccurs() != 1L, targetQname.getLocalPart());
            parentNode.addChildToList(xmlNode);
            if (!"http://www.w3.org/2001/XMLSchema".equals(targetQname.getNamespaceURI())) {
                XmlSchema schemaOfType;
                XmlSchemaType childSchemaType = schema.getTypeByName(targetQname.getLocalPart());
                if (childSchemaType == null) {
                    schemaOfType = this.getXmlSchema(targetQname);
                    childSchemaType = schemaOfType.getTypeByName(targetQname.getLocalPart());
                } else {
                    schemaOfType = schema;
                }
                this.processSchemaType(childSchemaType, xmlNode, schemaOfType);
            }
        }
    }

    private void processSchemaType(XmlSchemaType xmlSchemaType, XmlNode parentNode, XmlSchema schema) throws AxisFault {
        if (xmlSchemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)xmlSchemaType;
            XmlSchemaParticle particle = complexType.getParticle();
            if (particle instanceof XmlSchemaSequence) {
                XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
                for (XmlSchemaSequenceMember member : sequence.getItems()) {
                    if (!(member instanceof XmlSchemaElement)) continue;
                    this.processElement((XmlSchemaElement)member, parentNode, schema);
                }
            }
            if (complexType.getAttributes() != null && complexType.getAttributes().size() > 0) {
                log.debug((Object)("XmlNodeGenerator.processSchemaType() found attribute size from complexType: " + complexType.getAttributes().size()));
                List list = complexType.getAttributes();
                for (XmlSchemaAttributeOrGroupRef ref : list) {
                    XmlSchemaAttribute xsa = (XmlSchemaAttribute)ref;
                    String name = xsa.getName();
                    QName schemaTypeName = xsa.getSchemaTypeName();
                    if (schema != null && schema.getTargetNamespace() != null && schemaTypeName != null && schemaTypeName.getLocalPart() != null) {
                        log.debug((Object)("XmlNodeGenerator.processSchemaType() found attribute name from complexType: " + name + " , adding it to parentNode"));
                        XmlNode xmlNode = new XmlNode(name, schema.getTargetNamespace(), true, false, schemaTypeName.getLocalPart());
                        parentNode.addChildToList(xmlNode);
                        continue;
                    }
                    log.debug((Object)("XmlNodeGenerator.processSchemaType() found attribute name from complexType: " + name + " , however could not resolve namespace and localPart"));
                }
            }
        } else if (xmlSchemaType instanceof XmlSchemaSimpleType) {
            // empty if block
        }
    }

    private XmlSchema getXmlSchema(QName qName) {
        for (XmlSchema xmlSchema : this.xmlSchemaList) {
            if (!xmlSchema.getTargetNamespace().equals(qName.getNamespaceURI())) continue;
            return xmlSchema;
        }
        return null;
    }

    private void generateQueue(XmlNode node) {
        log.debug((Object)("XmlNodeGenerator.generateQueue() found node name: " + node.getName() + " , isAttribute: " + node.isAttribute()));
        if (node.isAttribute()) {
            this.attribute_queue.add(new JsonObject(node.getName(), JSONType.OBJECT, node.getValueType(), node.getNamespaceUri()));
            return;
        }
        if (node.isArray()) {
            if (node.getChildrenList().size() > 0) {
                this.queue.add(new JsonObject(node.getName(), JSONType.NESTED_ARRAY, node.getValueType(), node.getNamespaceUri()));
                this.processXmlNodeChildren(node.getChildrenList());
            } else {
                this.queue.add(new JsonObject(node.getName(), JSONType.ARRAY, node.getValueType(), node.getNamespaceUri()));
            }
        } else if (node.getChildrenList().size() > 0) {
            this.queue.add(new JsonObject(node.getName(), JSONType.NESTED_OBJECT, node.getValueType(), node.getNamespaceUri()));
            this.processXmlNodeChildren(node.getChildrenList());
        } else {
            this.queue.add(new JsonObject(node.getName(), JSONType.OBJECT, node.getValueType(), node.getNamespaceUri()));
        }
    }

    private void processXmlNodeChildren(List<XmlNode> childrenNodes) {
        for (int i = 0; i < childrenNodes.size(); ++i) {
            this.generateQueue(childrenNodes.get(i));
        }
    }

    public XmlNode getMainXmlNode() throws AxisFault {
        if (this.mainXmlNode == null) {
            try {
                this.processSchemaList();
            }
            catch (AxisFault axisFault) {
                throw new AxisFault("Error while creating intermeidate xml structure ", (Throwable)axisFault);
            }
        }
        return this.mainXmlNode;
    }

    public Queue<JsonObject> getQueue(XmlNode node) {
        this.generateQueue(node);
        return this.queue;
    }

    public Queue<JsonObject> getAttributeQueue() {
        return this.attribute_queue;
    }
}

