/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.functions;

import com.google.common.net.InternetDomainName;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.v1_1.domain.Endpoint;
import org.jclouds.openstack.keystone.v1_1.functions.EndpointToRegion;

@Singleton
public class RegionFirstPartOfDNSNameOrProvider
implements EndpointToRegion {
    private final String provider;

    @Inject
    RegionFirstPartOfDNSNameOrProvider(@Provider String provider) {
        this.provider = provider;
    }

    public String apply(Endpoint input) {
        if (input.getRegion() != null) {
            return input.getRegion();
        }
        String host = input.getPublicURL().getHost();
        if (InternetDomainName.isValid((String)host)) {
            InternetDomainName domain = InternetDomainName.from((String)host);
            return (String)domain.parts().get(0);
        }
        return this.provider;
    }
}

