/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.loadbalancing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.policy.autoscaling.AutoScalerPolicy;
import org.apache.brooklyn.policy.loadbalancing.BalanceableContainer;
import org.apache.brooklyn.policy.loadbalancing.BalanceablePoolModel;
import org.apache.brooklyn.policy.loadbalancing.BalanceableWorkerPool;
import org.apache.brooklyn.policy.loadbalancing.BalancingStrategy;
import org.apache.brooklyn.policy.loadbalancing.Movable;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancingPolicy<NodeType extends Entity, ItemType extends Movable>
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancingPolicy.class);
    @SetFromFlag(defaultVal="100")
    private long minPeriodBetweenExecs;
    private final AttributeSensor<? extends Number> metric;
    private final String lowThresholdConfigKeyName;
    private final String highThresholdConfigKeyName;
    private final BalanceablePoolModel<NodeType, ItemType> model;
    private final BalancingStrategy<NodeType, ItemType> strategy;
    private BalanceableWorkerPool poolEntity;
    private volatile ScheduledExecutorService executor;
    private final AtomicBoolean executorQueued = new AtomicBoolean(false);
    private volatile long executorTime = 0L;
    private int lastEmittedDesiredPoolSize = 0;
    private TemperatureStates lastEmittedPoolTemperature = null;
    private final SensorEventListener<Object> eventHandler = new SensorEventListener<Object>(){

        public void onEvent(SensorEvent<Object> event) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} received event {}", (Object)LoadBalancingPolicy.this, event);
            }
            Entity source = event.getSource();
            Object value = event.getValue();
            Sensor sensor = event.getSensor();
            if (sensor.equals(LoadBalancingPolicy.this.metric)) {
                LoadBalancingPolicy.this.onItemMetricUpdate((Movable)source, ((Number)value).doubleValue(), true);
            } else if (sensor.equals(BalanceableWorkerPool.CONTAINER_ADDED)) {
                LoadBalancingPolicy.this.onContainerAdded((Entity)value, true);
            } else if (sensor.equals(BalanceableWorkerPool.CONTAINER_REMOVED)) {
                LoadBalancingPolicy.this.onContainerRemoved((Entity)value, true);
            } else if (sensor.equals(BalanceableWorkerPool.ITEM_ADDED)) {
                BalanceableWorkerPool.ContainerItemPair pair = (BalanceableWorkerPool.ContainerItemPair)value;
                LoadBalancingPolicy.this.onItemAdded((Movable)pair.item, pair.container, true);
            } else if (sensor.equals(BalanceableWorkerPool.ITEM_REMOVED)) {
                BalanceableWorkerPool.ContainerItemPair pair = (BalanceableWorkerPool.ContainerItemPair)value;
                LoadBalancingPolicy.this.onItemRemoved((Movable)pair.item, pair.container, true);
            } else if (sensor.equals(BalanceableWorkerPool.ITEM_MOVED)) {
                BalanceableWorkerPool.ContainerItemPair pair = (BalanceableWorkerPool.ContainerItemPair)value;
                LoadBalancingPolicy.this.onItemMoved((Movable)pair.item, pair.container, true);
            }
        }
    };

    public LoadBalancingPolicy() {
        this(null, null);
    }

    public LoadBalancingPolicy(AttributeSensor<? extends Number> metric, BalanceablePoolModel<NodeType, ItemType> model) {
        this((Map)MutableMap.of(), metric, model);
    }

    public LoadBalancingPolicy(Map props, AttributeSensor<? extends Number> metric, BalanceablePoolModel<NodeType, ItemType> model) {
        super(props);
        this.metric = metric;
        this.lowThresholdConfigKeyName = metric.getName() + ".threshold.low";
        this.highThresholdConfigKeyName = metric.getName() + ".threshold.high";
        this.model = model;
        this.strategy = new BalancingStrategy<NodeType, ItemType>(this.getDisplayName(), model);
        this.executor = Executors.newSingleThreadScheduledExecutor(this.newThreadFactory());
    }

    public void setEntity(EntityLocal entity) {
        Preconditions.checkArgument((boolean)(entity instanceof BalanceableWorkerPool), (Object)"Provided entity must be a BalanceableWorkerPool");
        super.setEntity(entity);
        this.poolEntity = (BalanceableWorkerPool)entity;
        this.subscriptions().subscribe((Entity)this.poolEntity, BalanceableWorkerPool.CONTAINER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, BalanceableWorkerPool.CONTAINER_REMOVED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, BalanceableWorkerPool.ITEM_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, BalanceableWorkerPool.ITEM_REMOVED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, BalanceableWorkerPool.ITEM_MOVED, this.eventHandler);
        for (Entity container : this.poolEntity.getContainerGroup().getMembers()) {
            this.onContainerAdded(container, false);
        }
        for (Entity item : this.poolEntity.getItemGroup().getMembers()) {
            this.onItemAdded((Movable)item, (Entity)item.getAttribute(Movable.CONTAINER), false);
        }
        this.scheduleRebalance();
    }

    public void suspend() {
        super.suspend();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executorQueued.set(false);
    }

    public void resume() {
        super.resume();
        this.executor = Executors.newSingleThreadScheduledExecutor(this.newThreadFactory());
        this.executorTime = 0L;
        this.executorQueued.set(false);
    }

    private ThreadFactory newThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat("brooklyn-followthesunpolicy-%d").build();
    }

    private void scheduleRebalance() {
        if (this.isRunning() && this.executorQueued.compareAndSet(false, true)) {
            long now = System.currentTimeMillis();
            long delay = Math.max(0L, this.executorTime + this.minPeriodBetweenExecs - now);
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    this.runWithRetries(3);
                }

                private void runWithRetries(int retriesRemaining) {
                    try {
                        LoadBalancingPolicy.this.executorTime = System.currentTimeMillis();
                        LoadBalancingPolicy.this.executorQueued.set(false);
                        LoadBalancingPolicy.this.strategy.rebalance();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} post-rebalance: poolSize={}; workrate={}; lowThreshold={}; highThreshold={}", new Object[]{this, LoadBalancingPolicy.this.model.getPoolSize(), LoadBalancingPolicy.this.model.getCurrentPoolWorkrate(), LoadBalancingPolicy.this.model.getPoolLowThreshold(), LoadBalancingPolicy.this.model.getPoolHighThreshold()});
                        }
                        if (LoadBalancingPolicy.this.model.isCold()) {
                            int desiredPoolSize;
                            ImmutableMap eventVal = ImmutableMap.of((Object)"pool.current.size", (Object)LoadBalancingPolicy.this.model.getPoolSize(), (Object)"pool.current.workrate", (Object)LoadBalancingPolicy.this.model.getCurrentPoolWorkrate(), (Object)"pool.low.threshold", (Object)LoadBalancingPolicy.this.model.getPoolLowThreshold(), (Object)"pool.high.threshold", (Object)LoadBalancingPolicy.this.model.getPoolHighThreshold());
                            LoadBalancingPolicy.this.poolEntity.sensors().emit(AutoScalerPolicy.DEFAULT_POOL_COLD_SENSOR, (Object)eventVal);
                            if (LOG.isInfoEnabled() && ((desiredPoolSize = (int)Math.ceil(LoadBalancingPolicy.this.model.getCurrentPoolWorkrate() / (LoadBalancingPolicy.this.model.getPoolLowThreshold() / (double)LoadBalancingPolicy.this.model.getPoolSize()))) != LoadBalancingPolicy.this.lastEmittedDesiredPoolSize || LoadBalancingPolicy.this.lastEmittedPoolTemperature != TemperatureStates.COLD)) {
                                LOG.info("{} emitted COLD (suggesting {}): {}", new Object[]{this, desiredPoolSize, eventVal});
                                LoadBalancingPolicy.this.lastEmittedDesiredPoolSize = desiredPoolSize;
                                LoadBalancingPolicy.this.lastEmittedPoolTemperature = TemperatureStates.COLD;
                            }
                        } else if (LoadBalancingPolicy.this.model.isHot()) {
                            int desiredPoolSize;
                            ImmutableMap eventVal = ImmutableMap.of((Object)"pool.current.size", (Object)LoadBalancingPolicy.this.model.getPoolSize(), (Object)"pool.current.workrate", (Object)LoadBalancingPolicy.this.model.getCurrentPoolWorkrate(), (Object)"pool.low.threshold", (Object)LoadBalancingPolicy.this.model.getPoolLowThreshold(), (Object)"pool.high.threshold", (Object)LoadBalancingPolicy.this.model.getPoolHighThreshold());
                            LoadBalancingPolicy.this.poolEntity.sensors().emit(AutoScalerPolicy.DEFAULT_POOL_HOT_SENSOR, (Object)eventVal);
                            if (LOG.isInfoEnabled() && ((desiredPoolSize = (int)Math.ceil(LoadBalancingPolicy.this.model.getCurrentPoolWorkrate() / (LoadBalancingPolicy.this.model.getPoolHighThreshold() / (double)LoadBalancingPolicy.this.model.getPoolSize()))) != LoadBalancingPolicy.this.lastEmittedDesiredPoolSize || LoadBalancingPolicy.this.lastEmittedPoolTemperature != TemperatureStates.HOT)) {
                                LOG.info("{} emitted HOT (suggesting {}): {}", new Object[]{this, desiredPoolSize, eventVal});
                                LoadBalancingPolicy.this.lastEmittedDesiredPoolSize = desiredPoolSize;
                                LoadBalancingPolicy.this.lastEmittedPoolTemperature = TemperatureStates.HOT;
                            }
                        }
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (LoadBalancingPolicy.this.isRunning()) {
                            if (retriesRemaining > 0) {
                                LOG.error("Error rebalancing (ignoring and retrying, " + retriesRemaining + " left): " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                                this.runWithRetries(retriesRemaining - 1);
                            } else {
                                LOG.error("Error rebalancing (ignoring, another event may trigger a rebalance): " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                            }
                        }
                        LOG.debug("Error rebalancing, but no longer running: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    private void onContainerAdded(NodeType newContainer, boolean rebalanceNow) {
        Preconditions.checkArgument((boolean)(newContainer instanceof BalanceableContainer), (Object)"Added container must be a BalanceableContainer");
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording addition of container {}", (Object)this, newContainer);
        }
        Number lowThreshold = (Number)newContainer.getConfig(ConfigKeys.newConfigKey(Number.class, (String)this.lowThresholdConfigKeyName));
        Number highThreshold = (Number)newContainer.getConfig(ConfigKeys.newConfigKey(Number.class, (String)this.highThresholdConfigKeyName));
        if (lowThreshold == null || highThreshold == null) {
            LOG.warn("Balanceable container '" + newContainer + "' does not define low- and high- threshold configuration keys: '" + this.lowThresholdConfigKeyName + "' and '" + this.highThresholdConfigKeyName + "', skipping");
            return;
        }
        this.model.onContainerAdded(newContainer, lowThreshold.doubleValue(), highThreshold.doubleValue());
        if (rebalanceNow) {
            this.scheduleRebalance();
        }
    }

    private Number findConfigValue(NodeType newContainer, String lowThresholdConfigKeyName2) {
        return null;
    }

    private void onContainerRemoved(NodeType oldContainer, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording removal of container {}", (Object)this, oldContainer);
        }
        this.model.onContainerRemoved(oldContainer);
        if (rebalanceNow) {
            this.scheduleRebalance();
        }
    }

    private void onItemAdded(ItemType item, NodeType parentContainer, boolean rebalanceNow) {
        Preconditions.checkArgument((boolean)(item instanceof Movable), (Object)("Added item " + item + " must implement Movable"));
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording addition of item {} in container {}", new Object[]{this, item, parentContainer});
        }
        this.subscriptions().subscribe(item, this.metric, this.eventHandler);
        boolean immovable = (Boolean)JavaGroovyEquivalents.elvis((Object)item.getConfig(Movable.IMMOVABLE), (Object)false);
        Number currentValue = (Number)item.getAttribute(this.metric);
        this.model.onItemAdded(item, parentContainer, immovable);
        if (currentValue != null) {
            this.model.onItemWorkrateUpdated(item, currentValue.doubleValue());
        }
        if (rebalanceNow) {
            this.scheduleRebalance();
        }
    }

    private void onItemRemoved(ItemType item, NodeType parentContainer, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording removal of item {}", (Object)this, item);
        }
        this.subscriptions().unsubscribe(item);
        this.model.onItemRemoved(item);
        if (rebalanceNow) {
            this.scheduleRebalance();
        }
    }

    private void onItemMoved(ItemType item, NodeType parentContainer, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording moving of item {} to {}", new Object[]{this, item, parentContainer});
        }
        this.model.onItemMoved(item, parentContainer);
        if (rebalanceNow) {
            this.scheduleRebalance();
        }
    }

    private void onItemMetricUpdate(ItemType item, double newValue, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording metric update for item {}, new value {}", new Object[]{this, item, newValue});
        }
        this.model.onItemWorkrateUpdated(item, newValue);
        if (rebalanceNow) {
            this.scheduleRebalance();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + (JavaGroovyEquivalents.groovyTruth((String)this.name) ? "(" + this.name + ")" : "");
    }

    private static enum TemperatureStates {
        COLD,
        HOT;

    }
}

