/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.SoftwareProcessDriverLifecycleEffectorTasks;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

public interface SoftwareProcess
extends Entity,
Startable {
    public static final AttributeSensor<String> HOSTNAME = Attributes.HOSTNAME;
    public static final AttributeSensor<String> ADDRESS = Attributes.ADDRESS;
    public static final AttributeSensor<String> SUBNET_HOSTNAME = Attributes.SUBNET_HOSTNAME;
    public static final AttributeSensor<String> SUBNET_ADDRESS = Attributes.SUBNET_ADDRESS;
    public static final ConfigKey<Collection<Integer>> REQUIRED_OPEN_LOGIN_PORTS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Collection<Integer>>(){}, (String)"requiredOpenLoginPorts", (String)"The port(s) to be opened (also see 'inboundPorts.autoInfer')", (Object)ImmutableSet.of((Object)22));
    public static final ConfigKey<String> INBOUND_PORTS_CONFIG_REGEX = ConfigKeys.newStringConfigKey((String)"inboundPorts.configRegex", (String)"Regex governing the opening of ports based on config names (see 'inboundPorts.autoInfer')", (String)".*\\.port");
    public static final ConfigKey<Boolean> INBOUND_PORTS_AUTO_INFER = ConfigKeys.newBooleanConfigKey((String)"inboundPorts.autoInfer", (String)"By default, the ports to open in iptables and security group is inferred from the config keys. This follows a naming convention (defaulting to all config keys matching the name '*.\\.port', but customizable with the config key 'inboundPorts.configRegex'), and also including all config keys of type 'PortRange'. This behaviour is turned off by setting it to 'false'.", (Boolean)true);
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = BrooklynConfigKeys.START_TIMEOUT;
    @SetFromFlag(value="startLatch")
    public static final ConfigKey<Boolean> START_LATCH = BrooklynConfigKeys.START_LATCH;
    @SetFromFlag(value="stopLatch")
    public static final ConfigKey<Boolean> STOP_LATCH = BrooklynConfigKeys.STOP_LATCH;
    @SetFromFlag(value="setupLatch")
    public static final ConfigKey<Boolean> SETUP_LATCH = BrooklynConfigKeys.SETUP_LATCH;
    @SetFromFlag(value="installResourcesLatch")
    public static final ConfigKey<Boolean> INSTALL_RESOURCES_LATCH = BrooklynConfigKeys.INSTALL_RESOURCES_LATCH;
    @SetFromFlag(value="installLatch")
    public static final ConfigKey<Boolean> INSTALL_LATCH = BrooklynConfigKeys.INSTALL_LATCH;
    @SetFromFlag(value="runtimeResourcesLatch")
    public static final ConfigKey<Boolean> RUNTIME_RESOURCES_LATCH = BrooklynConfigKeys.RUNTIME_RESOURCES_LATCH;
    @SetFromFlag(value="customizeLatch")
    public static final ConfigKey<Boolean> CUSTOMIZE_LATCH = BrooklynConfigKeys.CUSTOMIZE_LATCH;
    @SetFromFlag(value="launchLatch")
    public static final ConfigKey<Boolean> LAUNCH_LATCH = BrooklynConfigKeys.LAUNCH_LATCH;
    @SetFromFlag(value="skipStart")
    public static final ConfigKey<Boolean> ENTITY_STARTED = BrooklynConfigKeys.SKIP_ENTITY_START;
    @SetFromFlag(value="skipStartIfRunning")
    public static final ConfigKey<Boolean> SKIP_ENTITY_START_IF_RUNNING = BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING;
    @SetFromFlag(value="skipInstall")
    public static final ConfigKey<Boolean> SKIP_INSTALLATION = BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION;
    @SetFromFlag(value="preInstallCommand")
    public static final ConfigKey<String> PRE_INSTALL_COMMAND = BrooklynConfigKeys.PRE_INSTALL_COMMAND;
    @SetFromFlag(value="postInstallCommand")
    public static final ConfigKey<String> POST_INSTALL_COMMAND = BrooklynConfigKeys.POST_INSTALL_COMMAND;
    @SetFromFlag(value="preCustomizeCommand")
    public static final ConfigKey<String> PRE_CUSTOMIZE_COMMAND = BrooklynConfigKeys.PRE_CUSTOMIZE_COMMAND;
    @SetFromFlag(value="postCustomizeCommand")
    public static final ConfigKey<String> POST_CUSTOMIZE_COMMAND = BrooklynConfigKeys.POST_CUSTOMIZE_COMMAND;
    @SetFromFlag(value="preLaunchCommand")
    public static final ConfigKey<String> PRE_LAUNCH_COMMAND = BrooklynConfigKeys.PRE_LAUNCH_COMMAND;
    @SetFromFlag(value="postLaunchCommand")
    public static final ConfigKey<String> POST_LAUNCH_COMMAND = BrooklynConfigKeys.POST_LAUNCH_COMMAND;
    @SetFromFlag(value="env")
    public static final MapConfigKey<Object> SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = BrooklynConfigKeys.SUGGESTED_VERSION;
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = Attributes.DOWNLOAD_URL;
    @SetFromFlag(value="downloadAddonUrls")
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOWNLOAD_ADDON_URLS = Attributes.DOWNLOAD_ADDON_URLS;
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newStringConfigKey((String)"archive.nameFormat", (String)"The format for the directory created when the installation archive is extracted, if required. The version string will be passed in as the first argument, replacing the %s format specifier");
    @SetFromFlag(value="installLabel")
    public static final ConfigKey<String> INSTALL_UNIQUE_LABEL = BrooklynConfigKeys.INSTALL_UNIQUE_LABEL;
    @SetFromFlag(value="expandedInstallDir")
    public static final AttributeSensorAndConfigKey<String, String> EXPANDED_INSTALL_DIR = BrooklynConfigKeys.EXPANDED_INSTALL_DIR;
    @SetFromFlag(value="installDir")
    public static final AttributeSensorAndConfigKey<String, String> INSTALL_DIR = BrooklynConfigKeys.INSTALL_DIR;
    @SetFromFlag(value="runDir")
    public static final AttributeSensorAndConfigKey<String, String> RUN_DIR = BrooklynConfigKeys.RUN_DIR;
    public static final ConfigKey<Boolean> ADD_OPEN_INBOUND_PORTS_EFFECTOR = ConfigKeys.newBooleanConfigKey((String)"effector.add.openInboundPorts", (String)"Whether to add an effector to the entity for opening ports through Cloud security groups", (Boolean)false);
    public static final ConfigKey<Boolean> OPEN_IPTABLES = ConfigKeys.newBooleanConfigKey((String)"openIptables", (String)"Whether to open the INBOUND_PORTS via iptables rules; if true then ssh in to run iptables commands, as part of machine provisioning", (Boolean)false);
    public static final ConfigKey<Boolean> STOP_IPTABLES = ConfigKeys.newBooleanConfigKey((String)"stopIptables", (String)"Whether to stop iptables entirely; if true then ssh in to stop the iptables service, as part of machine provisioning", (Boolean)false);
    public static final ConfigKey<Boolean> DONT_REQUIRE_TTY_FOR_SUDO = ConfigKeys.newBooleanConfigKey((String)"dontRequireTtyForSudo", (String)"Whether to explicitly set /etc/sudoers, so don't need tty (will leave unchanged if 'false'); some machines require a tty for sudo; brooklyn by default does not use a tty (so that it can get separate error+stdout streams); you can enable a tty as an option to every ssh command, or you can do it once and modify the machine so that a tty is not subsequently required.", (Boolean)false);
    @SetFromFlag(value="substitutions")
    public static final MapConfigKey<Object> TEMPLATE_SUBSTITUTIONS = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(Object.class, "template.substitutions").description("Map of values to be substituted for the keys in any templated files used by the entity")).defaultValue((Object)ImmutableMap.of())).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).build();
    @SetFromFlag(value="preInstallFiles")
    @Beta
    public static final MapConfigKey<String> PRE_INSTALL_FILES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "files.preinstall").description("Files to be copied before pre-install; mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="preInstallTemplates")
    @Beta
    public static final MapConfigKey<String> PRE_INSTALL_TEMPLATES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "templates.preinstall").description("Templated files to be filled in and copied before pre-install; mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="installFiles")
    @Beta
    public static final MapConfigKey<String> INSTALL_FILES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "files.install").description("Files to be copied before install; mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="installTemplates")
    @Beta
    public static final MapConfigKey<String> INSTALL_TEMPLATES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "templates.install").description("Templated files to be filled in and copied before install; mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="customizeFiles")
    @Beta
    public static final MapConfigKey<String> CUSTOMIZE_FILES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "files.customize").description("Files to be copied before customize; mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="customizeTemplates")
    @Beta
    public static final MapConfigKey<String> CUSTOMIZE_TEMPLATES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "templates.customize").description("Templated files to be filled in and copied before customize; mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="runtimeFiles")
    @Beta
    public static final MapConfigKey<String> RUNTIME_FILES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "files.runtime").description("Files to be copied before launch (and before pre-launch); mapping from resource to the destination name relative to runDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="runtimeTemplates")
    @Beta
    public static final MapConfigKey<String> RUNTIME_TEMPLATES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(String.class, "templates.runtime").description("Templated files to be filled in and copied before launch (and before pre-launch); mapping from resource to the destination name relative to installDir")).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    @SetFromFlag(value="provisioningProperties")
    public static final MapConfigKey<Object> PROVISIONING_PROPERTIES = BrooklynConfigKeys.PROVISIONING_PROPERTIES;
    @SetFromFlag(value="maxRebindSensorsDelay")
    public static final ConfigKey<Duration> MAXIMUM_REBIND_SENSOR_CONNECT_DELAY = ConfigKeys.newConfigKey(Duration.class, (String)"softwareProcess.maxSensorRebindDelay", (String)"The maximum delay to apply when reconnecting sensors when rebinding to this entity. Brooklyn will wait a random amount of time, up to the value of this config key, to avoid a thundering herd problem when the entity shares its machine with several others. Set to null or to 0 to disable any delay.", (Object)Duration.TEN_SECONDS);
    public static final ConfigKey<Duration> SERVICE_PROCESS_IS_RUNNING_POLL_PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"softwareProcess.serviceProcessIsRunningPollPeriod", (String)"The period for polling for whether the process is running; applies only if the entity wires up the connectServiceUpIsRunning.", (Object)Duration.FIVE_SECONDS);
    @SetFromFlag(value="lifecycleEffectorTasks")
    @Beta
    public static final ConfigKey<SoftwareProcessDriverLifecycleEffectorTasks> LIFECYCLE_EFFECTOR_TASKS = ConfigKeys.newConfigKey(SoftwareProcessDriverLifecycleEffectorTasks.class, (String)"softwareProcess.lifecycleTasks", (String)"An object that handles lifecycle of an entity's associated machine.", (Object)new SoftwareProcessDriverLifecycleEffectorTasks());
    public static final ConfigKey<Boolean> RETRIEVE_USAGE_METRICS = ConfigKeys.newBooleanConfigKey((String)"metrics.usage.retrieve", (String)"Whether to retrieve the usage (e.g. performance) metrics", (Boolean)true);
    @SetFromFlag(value="childStartMode")
    public static final ConfigKey<ChildStartableMode> CHILDREN_STARTABLE_MODE = ConfigKeys.newConfigKey(ChildStartableMode.class, (String)"children.startable.mode", (String)"Controls behaviour when starting Startable children as part of this entity's lifecycle.", (Object)((Object)ChildStartableMode.NONE));
    public static final AttributeSensor<MachineProvisioningLocation> PROVISIONING_LOCATION = Sensors.newSensor(MachineProvisioningLocation.class, (String)"softwareservice.provisioningLocation", (String)"Location used to provision a machine where this is running");
    public static final AttributeSensor<Boolean> SERVICE_PROCESS_IS_RUNNING = Sensors.newBooleanSensor((String)"service.process.isRunning", (String)"Whether the process for the service is confirmed as running");
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = Attributes.SERVICE_STATE_ACTUAL;
    public static final AttributeSensor<Lifecycle.Transition> SERVICE_STATE_EXPECTED = Attributes.SERVICE_STATE_EXPECTED;
    public static final AttributeSensor<String> PID_FILE = Sensors.newStringSensor((String)"softwareprocess.pid.file", (String)"PID file");

    @Effector(description="Populates the attribute service.notUp.diagnostics, with any available health indicators")
    @Beta
    public void populateServiceNotUpDiagnostics();

    @Beta
    public static class StopSoftwareParameters {
        @Beta
        public static final ConfigKey<StopMode> STOP_PROCESS_MODE = ConfigKeys.newConfigKey(StopMode.class, (String)"stopProcessMode", (String)"When to stop the process with regard to the entity state. ALWAYS will try to stop the process even if the entity is marked as stopped, IF_NOT_STOPPED stops the process only if the entity is not marked as stopped, NEVER doesn't stop the process.", (Object)((Object)StopMode.IF_NOT_STOPPED));
        @Beta
        public static final ConfigKey<StopMode> STOP_MACHINE_MODE = ConfigKeys.newConfigKey(StopMode.class, (String)"stopMachineMode", (String)"When to stop the machine with regard to the entity state. ALWAYS will try to stop the machine even if the entity is marked as stopped, IF_NOT_STOPPED stops the machine only if the entity is not marked as stopped, NEVER doesn't stop the machine.", (Object)((Object)StopMode.IF_NOT_STOPPED));

        public static enum StopMode {
            ALWAYS,
            IF_NOT_STOPPED,
            NEVER;

        }
    }

    @Beta
    public static class RestartSoftwareParameters {
        @Beta
        public static final ConfigKey<Boolean> RESTART_CHILDREN = ConfigKeys.newConfigKey(Boolean.class, (String)"restartChildren", (String)"Whether to restart children; default false", (Object)false);
        @Beta
        public static final ConfigKey<Object> RESTART_MACHINE = ConfigKeys.newConfigKey(Object.class, (String)"restartMachine", (String)"Whether to restart/replace the machine provisioned for this entity:  'true', 'false', or 'auto' are supported, with the default being 'auto' which means to restart or reprovision the machine if there is no simpler way known to restart the entity (for example, if the machine is unhealthy, it would not be possible to restart the process, not even via a stop-then-start sequence); if the machine was not provisioned for this entity, this parameter has no effect", (Object)RestartMachineMode.AUTO.toString().toLowerCase());
        @Beta
        public static final ConfigKey<RestartMachineMode> RESTART_MACHINE_TYPED = ConfigKeys.newConfigKey(RestartMachineMode.class, (String)"restartMachine");

        public static enum RestartMachineMode {
            TRUE,
            FALSE,
            AUTO;

        }
    }

    public static enum ChildStartableMode {
        NONE(true, false, false),
        FOREGROUND(false, false, false),
        FOREGROUND_LATE(false, false, true),
        BACKGROUND(false, true, false),
        BACKGROUND_LATE(false, true, true);

        public final boolean isDisabled;
        public final boolean isBackground;
        public final boolean isLate;

        private ChildStartableMode(boolean isDisabled, boolean isBackground, boolean isLate) {
            this.isDisabled = isDisabled;
            this.isBackground = isBackground;
            this.isLate = isLate;
        }
    }
}

