/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.config;

import io.swagger.config.FilterFactory;
import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs.config.DefaultJaxrsScanner;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import javax.servlet.ServletConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXMLReader
implements SwaggerConfig {
    protected String basePath;
    protected String host;
    protected String filterClass;
    protected String apiVersion;
    protected String title;
    protected String scheme = "http";
    private Logger LOGGER = LoggerFactory.getLogger(WebXMLReader.class);

    public WebXMLReader(ServletConfig servletConfig) {
        String[] parts;
        String shouldPrettyPrint;
        DefaultJaxrsScanner scanner = new DefaultJaxrsScanner();
        ScannerFactory.setScanner((Scanner)scanner);
        this.apiVersion = servletConfig.getInitParameter("api.version");
        if (this.apiVersion == null) {
            this.apiVersion = "Swagger Server";
        }
        if ((shouldPrettyPrint = servletConfig.getInitParameter("swagger.pretty.print")) != null) {
            scanner.setPrettyPrint(Boolean.parseBoolean(shouldPrettyPrint));
        }
        this.basePath = servletConfig.getInitParameter("swagger.api.basepath");
        this.title = servletConfig.getInitParameter("swagger.api.title");
        if (this.title == null) {
            this.title = "";
        }
        if (this.basePath != null && (parts = this.basePath.split("://")).length > 1) {
            int pos = parts[1].indexOf("/");
            if (pos >= 0) {
                this.scheme = parts[0];
                this.basePath = parts[1].substring(pos);
                this.host = parts[1].substring(0, pos);
            } else {
                this.scheme = parts[0];
                this.basePath = null;
                this.host = parts[1];
            }
        }
        this.filterClass = servletConfig.getInitParameter("swagger.filter");
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter((SwaggerSpecFilter)filter);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public Swagger configure(Swagger swagger) {
        if (swagger != null) {
            Info info = swagger.getInfo();
            if (info == null) {
                swagger.info(new Info());
            }
            swagger.basePath(this.basePath).host(this.host).scheme(Scheme.forValue((String)this.scheme)).getInfo().title(this.title).version(this.apiVersion);
        }
        return swagger;
    }
}

