/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.DeprecatedKeysMappingBuilder;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.LocationPropertiesFromBrooklynProperties;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.StringPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsPropertiesFromBrooklynProperties
extends LocationPropertiesFromBrooklynProperties {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsPropertiesFromBrooklynProperties.class);
    private static final Map<String, String> DEPRECATED_JCLOUDS_KEYS_MAPPING = new DeprecatedKeysMappingBuilder(LOG).putAll(LocationPropertiesFromBrooklynProperties.DEPRECATED_KEYS_MAPPING).camelToHyphen(JcloudsLocation.IMAGE_ID).camelToHyphen(JcloudsLocation.IMAGE_NAME_REGEX).camelToHyphen(JcloudsLocation.IMAGE_DESCRIPTION_REGEX).camelToHyphen(JcloudsLocation.HARDWARE_ID).build();

    public Map<String, Object> getLocationProperties(String provider, String namedLocation, Map<String, ?> properties) {
        throw new UnsupportedOperationException("Instead use getJcloudsProperties(String,String,String,Map)");
    }

    public Map<String, Object> getJcloudsProperties(String providerOrApi, String regionOrEndpoint, String namedLocation, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)namedLocation) && Strings.isNullOrEmpty((String)providerOrApi)) {
            throw new IllegalArgumentException("Neither cloud provider/API nor location name have been specified correctly");
        }
        ConfigBag jcloudsProperties = ConfigBag.newInstance();
        String provider = this.getProviderName(providerOrApi, namedLocation, properties);
        jcloudsProperties.put(LocationConfigKeys.CLOUD_PROVIDER, (Object)provider);
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericLocationSingleWordProperties(properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericLocationKnownProperties(properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericJcloudsSingleWordProperties(providerOrApi, properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericJcloudsKnownProperties(properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericJcloudsPropertiesPrefixedJclouds(providerOrApi, properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getProviderOrApiJcloudsProperties(providerOrApi, properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getRegionJcloudsProperties(providerOrApi, regionOrEndpoint, properties)));
        if (!Strings.isNullOrEmpty((String)namedLocation)) {
            jcloudsProperties.putAll(this.transformDeprecated(this.getNamedJcloudsProperties(namedLocation, properties)));
        }
        JcloudsPropertiesFromBrooklynProperties.setLocalTempDir(properties, (ConfigBag)jcloudsProperties);
        return jcloudsProperties.getAllConfigRaw();
    }

    protected String getProviderName(String providerOrApi, String namedLocationName, Map<String, ?> properties) {
        String providerDefinition;
        String provider = providerOrApi;
        if (!Strings.isNullOrEmpty((String)namedLocationName) && (providerDefinition = (String)properties.get(String.format("brooklyn.location.named.%s", namedLocationName))) != null) {
            String provider2 = this.getProviderFromDefinition(providerDefinition);
            if (provider == null) {
                LOG.warn(JavaClassNames.niceClassAndMethod() + " NOT set with provider, inferring from locationName " + namedLocationName + " as " + provider2);
                provider = provider2;
            } else if (!provider.equals(provider2)) {
                LOG.trace(JavaClassNames.niceClassAndMethod() + " NOT changing provider from " + provider + " to candidate " + provider2);
            }
        }
        return provider;
    }

    protected String getProviderFromDefinition(String definition) {
        Iterable parts = Splitter.on((String)":").split((CharSequence)definition);
        if (Iterables.size((Iterable)parts) <= 1) {
            return definition;
        }
        if ("jclouds".equalsIgnoreCase((String)Iterables.get((Iterable)parts, (int)0)) || "jcloudsByon".equalsIgnoreCase((String)Iterables.get((Iterable)parts, (int)0))) {
            return (String)Iterables.get((Iterable)parts, (int)1);
        }
        return (String)Iterables.get((Iterable)parts, (int)0);
    }

    private Map<String, ?> getGenericLocationKnownProperties(Map<String, ?> properties) {
        return this.getMatchingPropertiesWithoutPrefixInSet("brooklyn.location.", ConfigUtils.getStaticKeysOnClass(JcloudsLocationConfig.class), properties);
    }

    private Map<String, ?> getGenericJcloudsKnownProperties(Map<String, ?> properties) {
        return this.getMatchingPropertiesWithoutPrefixInSet("brooklyn.location.jclouds.", ConfigUtils.getStaticKeysOnClass(JcloudsLocationConfig.class), properties);
    }

    private Map<String, ?> getMatchingPropertiesWithoutPrefixInSet(String prefix, Set<ConfigKey.HasConfigKey<?>> keysToKeep, Map<String, ?> properties) {
        BrooklynProperties filteredProperties = ConfigUtils.filterForPrefixAndStrip(properties, (String)prefix);
        MutableSet keysToKeepStrings = MutableSet.of();
        for (ConfigKey.HasConfigKey<?> key : keysToKeep) {
            keysToKeepStrings.add(key.getConfigKey().getName());
        }
        return ConfigUtils.filterFor((BrooklynProperties)filteredProperties, (Predicate)StringPredicates.equalToAny((Iterable)keysToKeepStrings)).asMapWithStringKeys();
    }

    protected Map<String, Object> getGenericJcloudsSingleWordProperties(String providerOrApi, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi)) {
            return Maps.newHashMap();
        }
        String deprecatedPrefix = "brooklyn.jclouds.";
        String preferredPrefix = "brooklyn.location.jclouds.";
        return this.getMatchingSingleWordProperties(preferredPrefix, deprecatedPrefix, properties);
    }

    protected Map<String, Object> getGenericJcloudsPropertiesPrefixedJclouds(String providerOrApi, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi)) {
            return Maps.newHashMap();
        }
        String prefixToStrip = "brooklyn.location.jclouds.";
        String prefixToKeep = "jclouds.";
        return this.getMatchingConcatenatedPrefixesPropertiesFirstPrefixRemoved(prefixToStrip, prefixToKeep, properties);
    }

    protected Map<String, Object> getProviderOrApiJcloudsProperties(String providerOrApi, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi)) {
            return Maps.newHashMap();
        }
        String preferredPrefix = String.format("brooklyn.location.jclouds.%s.", providerOrApi);
        String deprecatedPrefix = String.format("brooklyn.jclouds.%s.", providerOrApi);
        return this.getMatchingProperties(preferredPrefix, deprecatedPrefix, properties);
    }

    protected Map<String, Object> getRegionJcloudsProperties(String providerOrApi, String regionName, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi) || Strings.isNullOrEmpty((String)regionName)) {
            return Maps.newHashMap();
        }
        String preferredPrefix = String.format("brooklyn.location.jclouds.%s@%s.", providerOrApi, regionName);
        String deprecatedPrefix = String.format("brooklyn.jclouds.%s@%s.", providerOrApi, regionName);
        return this.getMatchingProperties(preferredPrefix, deprecatedPrefix, properties);
    }

    protected Map<String, Object> getNamedJcloudsProperties(String locationName, Map<String, ?> properties) {
        if (locationName == null) {
            return Maps.newHashMap();
        }
        String prefix = String.format("brooklyn.location.named.%s.", locationName);
        return ConfigUtils.filterForPrefixAndStrip(properties, (String)prefix).asMapWithStringKeys();
    }

    protected Map<String, String> getDeprecatedKeysMapping() {
        return DEPRECATED_JCLOUDS_KEYS_MAPPING;
    }
}

