/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class AddServerOptions
extends BaseHttpRequestOptions {
    public AddServerOptions withDescription(String description) {
        Preconditions.checkArgument((description.length() <= 500 ? 1 : 0) != 0, (Object)"Description cannot be longer than 500 characters");
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"description") ? 1 : 0) != 0, (Object)"Can't have duplicate server description");
        this.queryParameters.put((Object)"description", (Object)description);
        return this;
    }

    public AddServerOptions asSandboxType() {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"isSandbox") ? 1 : 0) != 0, (Object)"Can only have one sandbox option per server");
        this.queryParameters.put((Object)"isSandbox", (Object)"true");
        return this;
    }

    public static class Builder {
        public static AddServerOptions withDescription(String description) {
            AddServerOptions options = new AddServerOptions();
            return options.withDescription(description);
        }

        public static AddServerOptions asSandboxType() {
            AddServerOptions options = new AddServerOptions();
            return options.asSandboxType();
        }
    }
}

