/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.internal.BrooklynPropertiesImpl;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BrooklynProperties
extends StringConfigMap {
    public BrooklynProperties addEnvironmentVars();

    public BrooklynProperties addSystemProperties();

    public BrooklynProperties addFrom(ConfigBag var1);

    public BrooklynProperties addFrom(Map var1);

    public BrooklynProperties addFrom(InputStream var1);

    public BrooklynProperties addFrom(File var1);

    public BrooklynProperties addFrom(URL var1);

    public BrooklynProperties addFromUrl(String var1);

    public BrooklynProperties addFromUrlProperty(String var1);

    public BrooklynProperties addFromMap(Map var1);

    public boolean putIfAbsent(String var1, Object var2);

    @Deprecated
    public String get(Map var1, String var2);

    public String getFirst(String ... var1);

    public String getFirst(Map var1, String ... var2);

    public Object put(Object var1, Object var2);

    public void putAll(Map var1);

    public <T> Object put(ConfigKey.HasConfigKey<T> var1, T var2);

    public <T> Object put(ConfigKey<T> var1, T var2);

    public <T> boolean putIfAbsent(ConfigKey<T> var1, T var2);

    @Beta
    public boolean containsKey(String var1);

    @Beta
    public boolean containsKey(ConfigKey<?> var1);

    @Beta
    public boolean remove(String var1);

    @Beta
    public boolean remove(ConfigKey<?> var1);

    @Beta
    public Object getConfig(String var1);

    public <T> T getConfig(ConfigKey<T> var1);

    public <T> T getConfig(ConfigKey.HasConfigKey<T> var1);

    public <T> T getConfig(ConfigKey.HasConfigKey<T> var1, T var2);

    public <T> T getConfig(ConfigKey<T> var1, T var2);

    public Maybe<Object> getConfigRaw(ConfigKey<?> var1);

    @Deprecated
    public Maybe<Object> getConfigRaw(ConfigKey<?> var1, boolean var2);

    @Deprecated
    public Map<ConfigKey<?>, Object> getAllConfig();

    public BrooklynProperties submap(Predicate<ConfigKey<?>> var1);

    @Beta
    public BrooklynProperties submapByName(Predicate<? super String> var1);

    public Map<String, Object> asMapWithStringKeys();

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        public static BrooklynProperties newEmpty() {
            return new BrooklynPropertiesImpl();
        }

        public static BrooklynProperties newDefault() {
            return new Builder(true).build();
        }

        public static Builder builderDefault() {
            return new Builder(true);
        }

        public static Builder builderEmpty() {
            return new Builder(false);
        }

        private static void addPropertiesFromUrl(BrooklynProperties p, String url, boolean warnIfNotFound) {
            block4: {
                if (url == null) {
                    return;
                }
                try {
                    p.addFrom(ResourceUtils.create(BrooklynProperties.class).getResourceFromUrl(url));
                }
                catch (Exception e) {
                    if (warnIfNotFound) {
                        LOG.warn("Could not load {}; continuing", (Object)url);
                    }
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("Could not load " + url + "; continuing", (Throwable)e);
                }
            }
        }

        private static void addPropertiesFromFile(BrooklynProperties p, String file) {
            if (file == null) {
                return;
            }
            String fileTidied = Os.tidyPath((String)file);
            File f = new File(fileTidied);
            if (f.exists()) {
                p.addFrom(f);
            }
        }

        private static void addPropertiesFromMapSupplier(BrooklynProperties p, Supplier<Map<?, ?>> propertiesSupplier) {
            Map newProps;
            if (propertiesSupplier != null && (newProps = (Map)propertiesSupplier.get()) != null) {
                p.addFrom(newProps);
            }
        }

        public static class Builder {
            private String defaultLocationMetadataUrl;
            private String globalLocationMetadataFile = null;
            private String globalPropertiesFile = null;
            private String localPropertiesFile = null;
            private Supplier<Map<?, ?>> propertiesSupplier;
            private BrooklynProperties originalProperties = null;

            private Builder(boolean setGlobalFileDefaults) {
                this.resetDefaultLocationMetadataUrl();
                if (setGlobalFileDefaults) {
                    this.resetGlobalFiles();
                }
            }

            public Builder resetDefaultLocationMetadataUrl() {
                this.defaultLocationMetadataUrl = "classpath://brooklyn/location-metadata.properties";
                return this;
            }

            public Builder resetGlobalFiles() {
                this.defaultLocationMetadataUrl = "classpath://brooklyn/location-metadata.properties";
                this.globalLocationMetadataFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "location-metadata.properties"});
                this.globalPropertiesFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "brooklyn.properties"});
                return this;
            }

            private Builder(BrooklynProperties originalProperties) {
                this.originalProperties = new BrooklynPropertiesImpl().addFromMap(originalProperties.asMapWithStringKeys());
            }

            public Builder defaultLocationMetadataUrl(String val) {
                this.defaultLocationMetadataUrl = (String)Preconditions.checkNotNull((Object)val, (Object)"file");
                return this;
            }

            public Builder globalLocationMetadataFile(String val) {
                this.globalLocationMetadataFile = (String)Preconditions.checkNotNull((Object)val, (Object)"file");
                return this;
            }

            public Builder globalPropertiesFile(String val) {
                this.globalPropertiesFile = val;
                return this;
            }

            public Builder propertiesSupplier(Supplier<Map<?, ?>> propertiesSupplier) {
                this.propertiesSupplier = propertiesSupplier;
                return this;
            }

            @Beta
            public boolean hasDelegateOriginalProperties() {
                return this.originalProperties != null;
            }

            public Builder localPropertiesFile(String val) {
                this.localPropertiesFile = val;
                return this;
            }

            public BrooklynProperties build() {
                if (this.originalProperties != null) {
                    return new BrooklynPropertiesImpl().addFromMap(this.originalProperties.asMapWithStringKeys());
                }
                BrooklynPropertiesImpl properties = new BrooklynPropertiesImpl();
                Factory.addPropertiesFromUrl(properties, this.defaultLocationMetadataUrl, false);
                Factory.addPropertiesFromMapSupplier(properties, this.propertiesSupplier);
                Factory.addPropertiesFromFile(properties, this.globalLocationMetadataFile);
                Factory.addPropertiesFromFile(properties, this.globalPropertiesFile);
                Factory.addPropertiesFromFile(properties, this.localPropertiesFile);
                properties.addEnvironmentVars();
                properties.addSystemProperties();
                return properties;
            }

            public static Builder fromProperties(BrooklynProperties brooklynProperties) {
                return new Builder(brooklynProperties);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).omitNullValues().add("originalProperties", (Object)this.originalProperties).add("defaultLocationMetadataUrl", (Object)this.defaultLocationMetadataUrl).add("globalLocationMetadataUrl", (Object)this.globalLocationMetadataFile).add("globalPropertiesFile", (Object)this.globalPropertiesFile).add("localPropertiesFile", (Object)this.localPropertiesFile).add("propertiesSupplier", this.propertiesSupplier).toString();
            }
        }
    }
}

