/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableList<V>
extends ArrayList<V> {
    private static final long serialVersionUID = -5533940507175152491L;
    private static final Logger log = LoggerFactory.getLogger(MutableList.class);

    public static <V> MutableList<V> of() {
        return new MutableList<V>();
    }

    public static <V> MutableList<V> of(V v1) {
        MutableList<V> result = new MutableList<V>();
        result.add(v1);
        return result;
    }

    public static <V> MutableList<V> of(V v1, V v2) {
        MutableList<V> result = new MutableList<V>();
        result.add(v1);
        result.add(v2);
        return result;
    }

    public static <V> MutableList<V> of(V v1, V v2, V ... vv) {
        MutableList<V> result = new MutableList<V>();
        result.add(v1);
        result.add(v2);
        for (V v : vv) {
            result.add(v);
        }
        return result;
    }

    public static <V> MutableList<V> copyOf(@Nullable Iterable<? extends V> orig) {
        return orig instanceof Collection ? new MutableList<V>((Collection)orig) : (orig != null ? new MutableList<V>(orig) : new MutableList<V>());
    }

    public static <E> MutableList<E> copyOf(Iterator<? extends E> elements) {
        if (!elements.hasNext()) {
            return MutableList.of();
        }
        return new Builder<E>().addAll(elements).build();
    }

    public MutableList() {
    }

    public MutableList(Collection<? extends V> source) {
        super(source);
    }

    public MutableList(Iterable<? extends V> source) {
        for (V s : source) {
            this.add(s);
        }
    }

    public List<V> asImmutableCopy() {
        try {
            return ImmutableList.copyOf((Collection)this);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            log.warn("Error converting list to Immutable, using unmodifiable instead: " + e, (Throwable)e);
            return this.asUnmodifiableCopy();
        }
    }

    public List<V> asUnmodifiable() {
        return Collections.unmodifiableList(this);
    }

    public List<V> asUnmodifiableCopy() {
        return Collections.unmodifiableList(MutableList.copyOf(this));
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public MutableList<V> append(V item) {
        this.add(item);
        return this;
    }

    public MutableList<V> appendIfNotNull(V item) {
        if (item != null) {
            this.add(item);
        }
        return this;
    }

    public MutableList<V> append(V item1, V item2, V ... items) {
        this.add(item1);
        this.add(item2);
        for (V item : items) {
            this.add(item);
        }
        return this;
    }

    public MutableList<V> appendIfNotNull(V item1, V item2, V ... items) {
        if (item1 != null) {
            this.add(item1);
        }
        if (item2 != null) {
            this.add(item2);
        }
        for (V item : items) {
            if (item == null) continue;
            this.add(item);
        }
        return this;
    }

    public MutableList<V> appendAll(Iterable<? extends V> items) {
        if (items != null) {
            for (V item : items) {
                this.add(item);
            }
        }
        return this;
    }

    public MutableList<V> appendAll(Iterator<? extends V> items) {
        this.addAll(items);
        return this;
    }

    @Override
    public boolean addAll(Iterable<? extends V> setToAdd) {
        if (setToAdd == null) {
            return false;
        }
        return this.addAll(setToAdd.iterator());
    }

    @Override
    public boolean addAll(Iterator<? extends V> setToAdd) {
        if (setToAdd == null) {
            return false;
        }
        boolean modified = false;
        while (setToAdd.hasNext()) {
            if (!this.add(setToAdd.next())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeIfNotNull(V item) {
        if (item == null) {
            return false;
        }
        return this.remove(item);
    }

    public static class Builder<V> {
        final MutableList<V> result = new MutableList();

        public Builder<V> addIfNotNull(V value) {
            if (value != null) {
                this.result.add(value);
            }
            return this;
        }

        public Builder<V> add(V value) {
            this.result.add(value);
            return this;
        }

        public Builder<V> add(V value1, V value2, V ... values) {
            this.result.add(value1);
            this.result.add(value2);
            for (V v : values) {
                this.result.add(v);
            }
            return this;
        }

        public Builder<V> remove(V val) {
            this.result.remove(val);
            return this;
        }

        public Builder<V> addAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                ((ArrayList)this.result).addAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.add(v);
                }
            }
            return this;
        }

        public Builder<V> addAll(Iterator<? extends V> iter) {
            while (iter.hasNext()) {
                this.add(iter.next());
            }
            return this;
        }

        public Builder<V> addAll(V[] vals) {
            for (V v : vals) {
                this.result.add(v);
            }
            return this;
        }

        public Builder<V> removeAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.removeAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.remove(v);
                }
            }
            return this;
        }

        public Builder<V> retainAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.retainAll((Collection)iterable);
            } else {
                ArrayList toretain = Lists.newArrayList(iterable);
                this.result.retainAll(toretain);
            }
            return this;
        }

        public MutableList<V> build() {
            return new MutableList<V>(this.result);
        }

        public ImmutableList<V> buildImmutable() {
            return ImmutableList.copyOf(this.result);
        }

        public Builder<V> addLists(Iterable<? extends V> ... items) {
            for (Iterable<? extends V> item : items) {
                this.addAll(item);
            }
            return this;
        }
    }
}

