/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSource;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSource;
import io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource;
import io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluentImpl;

public class VolumeFluentImpl<A extends VolumeFluent<A>>
extends BaseFluent<A>
implements VolumeFluent<A> {
    private VisitableBuilder<? extends AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    private VisitableBuilder<? extends AzureFileVolumeSource, ?> azureFile;
    private VisitableBuilder<? extends CephFSVolumeSource, ?> cephfs;
    private VisitableBuilder<? extends CinderVolumeSource, ?> cinder;
    private VisitableBuilder<? extends ConfigMapVolumeSource, ?> configMap;
    private VisitableBuilder<? extends DownwardAPIVolumeSource, ?> downwardAPI;
    private VisitableBuilder<? extends EmptyDirVolumeSource, ?> emptyDir;
    private VisitableBuilder<? extends FCVolumeSource, ?> fc;
    private VisitableBuilder<? extends FlexVolumeSource, ?> flexVolume;
    private VisitableBuilder<? extends FlockerVolumeSource, ?> flocker;
    private VisitableBuilder<? extends GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    private VisitableBuilder<? extends GitRepoVolumeSource, ?> gitRepo;
    private VisitableBuilder<? extends GlusterfsVolumeSource, ?> glusterfs;
    private VisitableBuilder<? extends HostPathVolumeSource, ?> hostPath;
    private VisitableBuilder<? extends ISCSIVolumeSource, ?> iscsi;
    private VisitableBuilder<? extends DeprecatedDownwardAPIVolumeSource, ?> metadata;
    private String name;
    private VisitableBuilder<? extends NFSVolumeSource, ?> nfs;
    private VisitableBuilder<? extends PersistentVolumeClaimVolumeSource, ?> persistentVolumeClaim;
    private VisitableBuilder<? extends RBDVolumeSource, ?> rbd;
    private VisitableBuilder<? extends SecretVolumeSource, ?> secret;
    private VisitableBuilder<? extends VsphereVirtualDiskVolumeSource, ?> vsphereVolume;

    public VolumeFluentImpl() {
    }

    public VolumeFluentImpl(Volume instance) {
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureFile(instance.getAzureFile());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withConfigMap(instance.getConfigMap());
        this.withDownwardAPI(instance.getDownwardAPI());
        this.withEmptyDir(instance.getEmptyDir());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withMetadata(instance.getMetadata());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withRbd(instance.getRbd());
        this.withSecret(instance.getSecret());
        this.withVsphereVolume(instance.getVsphereVolume());
    }

    @Override
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    @Override
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this._visitables.remove(this.awsElasticBlockStore);
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNestedImpl();
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNestedImpl(item);
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore() != null ? this.getAwsElasticBlockStore() : new AWSElasticBlockStoreVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore() != null ? this.getAwsElasticBlockStore() : item);
    }

    @Override
    public A withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    @Override
    public AzureFileVolumeSource getAzureFile() {
        return this.azureFile != null ? (AzureFileVolumeSource)this.azureFile.build() : null;
    }

    @Override
    public A withAzureFile(AzureFileVolumeSource azureFile) {
        this._visitables.remove(this.azureFile);
        if (azureFile != null) {
            this.azureFile = new AzureFileVolumeSourceBuilder(azureFile);
            this._visitables.add(this.azureFile);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.AzureFileNested<A> withNewAzureFile() {
        return new AzureFileNestedImpl();
    }

    @Override
    public VolumeFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item) {
        return new AzureFileNestedImpl(item);
    }

    @Override
    public VolumeFluent.AzureFileNested<A> editAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile());
    }

    @Override
    public VolumeFluent.AzureFileNested<A> editOrNewAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile() != null ? this.getAzureFile() : new AzureFileVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item) {
        return this.withNewAzureFileLike(this.getAzureFile() != null ? this.getAzureFile() : item);
    }

    @Override
    public A withNewAzureFile(Boolean readOnly, String secretName, String shareName) {
        return this.withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    @Override
    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? (CephFSVolumeSource)this.cephfs.build() : null;
    }

    @Override
    public A withCephfs(CephFSVolumeSource cephfs) {
        this._visitables.remove(this.cephfs);
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.CephfsNested<A> withNewCephfs() {
        return new CephfsNestedImpl();
    }

    @Override
    public VolumeFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNestedImpl(item);
    }

    @Override
    public VolumeFluent.CephfsNested<A> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    @Override
    public VolumeFluent.CephfsNested<A> editOrNewCephfs() {
        return this.withNewCephfsLike(this.getCephfs() != null ? this.getCephfs() : new CephFSVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item) {
        return this.withNewCephfsLike(this.getCephfs() != null ? this.getCephfs() : item);
    }

    @Override
    public CinderVolumeSource getCinder() {
        return this.cinder != null ? (CinderVolumeSource)this.cinder.build() : null;
    }

    @Override
    public A withCinder(CinderVolumeSource cinder) {
        this._visitables.remove(this.cinder);
        if (cinder != null) {
            this.cinder = new CinderVolumeSourceBuilder(cinder);
            this._visitables.add(this.cinder);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.CinderNested<A> withNewCinder() {
        return new CinderNestedImpl();
    }

    @Override
    public VolumeFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item) {
        return new CinderNestedImpl(item);
    }

    @Override
    public VolumeFluent.CinderNested<A> editCinder() {
        return this.withNewCinderLike(this.getCinder());
    }

    @Override
    public VolumeFluent.CinderNested<A> editOrNewCinder() {
        return this.withNewCinderLike(this.getCinder() != null ? this.getCinder() : new CinderVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item) {
        return this.withNewCinderLike(this.getCinder() != null ? this.getCinder() : item);
    }

    @Override
    public A withNewCinder(String fsType, Boolean readOnly, String volumeID) {
        return this.withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    @Override
    public ConfigMapVolumeSource getConfigMap() {
        return this.configMap != null ? (ConfigMapVolumeSource)this.configMap.build() : null;
    }

    @Override
    public A withConfigMap(ConfigMapVolumeSource configMap) {
        this._visitables.remove(this.configMap);
        if (configMap != null) {
            this.configMap = new ConfigMapVolumeSourceBuilder(configMap);
            this._visitables.add(this.configMap);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNestedImpl();
    }

    @Override
    public VolumeFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMapVolumeSource item) {
        return new ConfigMapNestedImpl(item);
    }

    @Override
    public VolumeFluent.ConfigMapNested<A> editConfigMap() {
        return this.withNewConfigMapLike(this.getConfigMap());
    }

    @Override
    public VolumeFluent.ConfigMapNested<A> editOrNewConfigMap() {
        return this.withNewConfigMapLike(this.getConfigMap() != null ? this.getConfigMap() : new ConfigMapVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapVolumeSource item) {
        return this.withNewConfigMapLike(this.getConfigMap() != null ? this.getConfigMap() : item);
    }

    @Override
    public DownwardAPIVolumeSource getDownwardAPI() {
        return this.downwardAPI != null ? (DownwardAPIVolumeSource)this.downwardAPI.build() : null;
    }

    @Override
    public A withDownwardAPI(DownwardAPIVolumeSource downwardAPI) {
        this._visitables.remove(this.downwardAPI);
        if (downwardAPI != null) {
            this.downwardAPI = new DownwardAPIVolumeSourceBuilder(downwardAPI);
            this._visitables.add(this.downwardAPI);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPI() {
        return new DownwardAPINestedImpl();
    }

    @Override
    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIVolumeSource item) {
        return new DownwardAPINestedImpl(item);
    }

    @Override
    public VolumeFluent.DownwardAPINested<A> editDownwardAPI() {
        return this.withNewDownwardAPILike(this.getDownwardAPI());
    }

    @Override
    public VolumeFluent.DownwardAPINested<A> editOrNewDownwardAPI() {
        return this.withNewDownwardAPILike(this.getDownwardAPI() != null ? this.getDownwardAPI() : new DownwardAPIVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.DownwardAPINested<A> editOrNewDownwardAPILike(DownwardAPIVolumeSource item) {
        return this.withNewDownwardAPILike(this.getDownwardAPI() != null ? this.getDownwardAPI() : item);
    }

    @Override
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir != null ? (EmptyDirVolumeSource)this.emptyDir.build() : null;
    }

    @Override
    public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
        this._visitables.remove(this.emptyDir);
        if (emptyDir != null) {
            this.emptyDir = new EmptyDirVolumeSourceBuilder(emptyDir);
            this._visitables.add(this.emptyDir);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.EmptyDirNested<A> withNewEmptyDir() {
        return new EmptyDirNestedImpl();
    }

    @Override
    public VolumeFluent.EmptyDirNested<A> withNewEmptyDirLike(EmptyDirVolumeSource item) {
        return new EmptyDirNestedImpl(item);
    }

    @Override
    public VolumeFluent.EmptyDirNested<A> editEmptyDir() {
        return this.withNewEmptyDirLike(this.getEmptyDir());
    }

    @Override
    public VolumeFluent.EmptyDirNested<A> editOrNewEmptyDir() {
        return this.withNewEmptyDirLike(this.getEmptyDir() != null ? this.getEmptyDir() : new EmptyDirVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.EmptyDirNested<A> editOrNewEmptyDirLike(EmptyDirVolumeSource item) {
        return this.withNewEmptyDirLike(this.getEmptyDir() != null ? this.getEmptyDir() : item);
    }

    @Override
    public A withNewEmptyDir(String medium) {
        return this.withEmptyDir(new EmptyDirVolumeSource(medium));
    }

    @Override
    public FCVolumeSource getFc() {
        return this.fc != null ? (FCVolumeSource)this.fc.build() : null;
    }

    @Override
    public A withFc(FCVolumeSource fc) {
        this._visitables.remove(this.fc);
        if (fc != null) {
            this.fc = new FCVolumeSourceBuilder(fc);
            this._visitables.add(this.fc);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.FcNested<A> withNewFc() {
        return new FcNestedImpl();
    }

    @Override
    public VolumeFluent.FcNested<A> withNewFcLike(FCVolumeSource item) {
        return new FcNestedImpl(item);
    }

    @Override
    public VolumeFluent.FcNested<A> editFc() {
        return this.withNewFcLike(this.getFc());
    }

    @Override
    public VolumeFluent.FcNested<A> editOrNewFc() {
        return this.withNewFcLike(this.getFc() != null ? this.getFc() : new FCVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item) {
        return this.withNewFcLike(this.getFc() != null ? this.getFc() : item);
    }

    @Override
    public FlexVolumeSource getFlexVolume() {
        return this.flexVolume != null ? (FlexVolumeSource)this.flexVolume.build() : null;
    }

    @Override
    public A withFlexVolume(FlexVolumeSource flexVolume) {
        this._visitables.remove(this.flexVolume);
        if (flexVolume != null) {
            this.flexVolume = new FlexVolumeSourceBuilder(flexVolume);
            this._visitables.add(this.flexVolume);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolume() {
        return new FlexVolumeNestedImpl();
    }

    @Override
    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item) {
        return new FlexVolumeNestedImpl(item);
    }

    @Override
    public VolumeFluent.FlexVolumeNested<A> editFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume());
    }

    @Override
    public VolumeFluent.FlexVolumeNested<A> editOrNewFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume() != null ? this.getFlexVolume() : new FlexVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item) {
        return this.withNewFlexVolumeLike(this.getFlexVolume() != null ? this.getFlexVolume() : item);
    }

    @Override
    public FlockerVolumeSource getFlocker() {
        return this.flocker != null ? (FlockerVolumeSource)this.flocker.build() : null;
    }

    @Override
    public A withFlocker(FlockerVolumeSource flocker) {
        this._visitables.remove(this.flocker);
        if (flocker != null) {
            this.flocker = new FlockerVolumeSourceBuilder(flocker);
            this._visitables.add(this.flocker);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.FlockerNested<A> withNewFlocker() {
        return new FlockerNestedImpl();
    }

    @Override
    public VolumeFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
        return new FlockerNestedImpl(item);
    }

    @Override
    public VolumeFluent.FlockerNested<A> editFlocker() {
        return this.withNewFlockerLike(this.getFlocker());
    }

    @Override
    public VolumeFluent.FlockerNested<A> editOrNewFlocker() {
        return this.withNewFlockerLike(this.getFlocker() != null ? this.getFlocker() : new FlockerVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item) {
        return this.withNewFlockerLike(this.getFlocker() != null ? this.getFlocker() : item);
    }

    @Override
    public A withNewFlocker(String datasetName) {
        return this.withFlocker(new FlockerVolumeSource(datasetName));
    }

    @Override
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    @Override
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this._visitables.remove(this.gcePersistentDisk);
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
        return new GcePersistentDiskNestedImpl();
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNestedImpl(item);
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<A> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk() != null ? this.getGcePersistentDisk() : new GCEPersistentDiskVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk() != null ? this.getGcePersistentDisk() : item);
    }

    @Override
    public A withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    @Override
    public GitRepoVolumeSource getGitRepo() {
        return this.gitRepo != null ? (GitRepoVolumeSource)this.gitRepo.build() : null;
    }

    @Override
    public A withGitRepo(GitRepoVolumeSource gitRepo) {
        this._visitables.remove(this.gitRepo);
        if (gitRepo != null) {
            this.gitRepo = new GitRepoVolumeSourceBuilder(gitRepo);
            this._visitables.add(this.gitRepo);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.GitRepoNested<A> withNewGitRepo() {
        return new GitRepoNestedImpl();
    }

    @Override
    public VolumeFluent.GitRepoNested<A> withNewGitRepoLike(GitRepoVolumeSource item) {
        return new GitRepoNestedImpl(item);
    }

    @Override
    public VolumeFluent.GitRepoNested<A> editGitRepo() {
        return this.withNewGitRepoLike(this.getGitRepo());
    }

    @Override
    public VolumeFluent.GitRepoNested<A> editOrNewGitRepo() {
        return this.withNewGitRepoLike(this.getGitRepo() != null ? this.getGitRepo() : new GitRepoVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.GitRepoNested<A> editOrNewGitRepoLike(GitRepoVolumeSource item) {
        return this.withNewGitRepoLike(this.getGitRepo() != null ? this.getGitRepo() : item);
    }

    @Override
    public A withNewGitRepo(String directory, String repository, String revision) {
        return this.withGitRepo(new GitRepoVolumeSource(directory, repository, revision));
    }

    @Override
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    @Override
    public A withGlusterfs(GlusterfsVolumeSource glusterfs) {
        this._visitables.remove(this.glusterfs);
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.GlusterfsNested<A> withNewGlusterfs() {
        return new GlusterfsNestedImpl();
    }

    @Override
    public VolumeFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNestedImpl(item);
    }

    @Override
    public VolumeFluent.GlusterfsNested<A> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    @Override
    public VolumeFluent.GlusterfsNested<A> editOrNewGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs() != null ? this.getGlusterfs() : new GlusterfsVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item) {
        return this.withNewGlusterfsLike(this.getGlusterfs() != null ? this.getGlusterfs() : item);
    }

    @Override
    public A withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    @Override
    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    @Override
    public A withHostPath(HostPathVolumeSource hostPath) {
        this._visitables.remove(this.hostPath);
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.HostPathNested<A> withNewHostPath() {
        return new HostPathNestedImpl();
    }

    @Override
    public VolumeFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNestedImpl(item);
    }

    @Override
    public VolumeFluent.HostPathNested<A> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    @Override
    public VolumeFluent.HostPathNested<A> editOrNewHostPath() {
        return this.withNewHostPathLike(this.getHostPath() != null ? this.getHostPath() : new HostPathVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item) {
        return this.withNewHostPathLike(this.getHostPath() != null ? this.getHostPath() : item);
    }

    @Override
    public A withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    @Override
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    @Override
    public A withIscsi(ISCSIVolumeSource iscsi) {
        this._visitables.remove(this.iscsi);
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.IscsiNested<A> withNewIscsi() {
        return new IscsiNestedImpl();
    }

    @Override
    public VolumeFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNestedImpl(item);
    }

    @Override
    public VolumeFluent.IscsiNested<A> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    @Override
    public VolumeFluent.IscsiNested<A> editOrNewIscsi() {
        return this.withNewIscsiLike(this.getIscsi() != null ? this.getIscsi() : new ISCSIVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item) {
        return this.withNewIscsiLike(this.getIscsi() != null ? this.getIscsi() : item);
    }

    @Override
    public DeprecatedDownwardAPIVolumeSource getMetadata() {
        return this.metadata != null ? (DeprecatedDownwardAPIVolumeSource)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(DeprecatedDownwardAPIVolumeSource metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new DeprecatedDownwardAPIVolumeSourceBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public VolumeFluent.MetadataNested<A> withNewMetadataLike(DeprecatedDownwardAPIVolumeSource item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public VolumeFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public VolumeFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new DeprecatedDownwardAPIVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.MetadataNested<A> editOrNewMetadataLike(DeprecatedDownwardAPIVolumeSource item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    @Override
    public A withNfs(NFSVolumeSource nfs) {
        this._visitables.remove(this.nfs);
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.NfsNested<A> withNewNfs() {
        return new NfsNestedImpl();
    }

    @Override
    public VolumeFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNestedImpl(item);
    }

    @Override
    public VolumeFluent.NfsNested<A> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    @Override
    public VolumeFluent.NfsNested<A> editOrNewNfs() {
        return this.withNewNfsLike(this.getNfs() != null ? this.getNfs() : new NFSVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item) {
        return this.withNewNfsLike(this.getNfs() != null ? this.getNfs() : item);
    }

    @Override
    public A withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    @Override
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null ? (PersistentVolumeClaimVolumeSource)this.persistentVolumeClaim.build() : null;
    }

    @Override
    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        this._visitables.remove(this.persistentVolumeClaim);
        if (persistentVolumeClaim != null) {
            this.persistentVolumeClaim = new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim);
            this._visitables.add(this.persistentVolumeClaim);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNestedImpl();
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item) {
        return new PersistentVolumeClaimNestedImpl(item);
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(this.getPersistentVolumeClaim());
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(this.getPersistentVolumeClaim() != null ? this.getPersistentVolumeClaim() : new PersistentVolumeClaimVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item) {
        return this.withNewPersistentVolumeClaimLike(this.getPersistentVolumeClaim() != null ? this.getPersistentVolumeClaim() : item);
    }

    @Override
    public A withNewPersistentVolumeClaim(String claimName, Boolean readOnly) {
        return this.withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    @Override
    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    @Override
    public A withRbd(RBDVolumeSource rbd) {
        this._visitables.remove(this.rbd);
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.RbdNested<A> withNewRbd() {
        return new RbdNestedImpl();
    }

    @Override
    public VolumeFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNestedImpl(item);
    }

    @Override
    public VolumeFluent.RbdNested<A> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    @Override
    public VolumeFluent.RbdNested<A> editOrNewRbd() {
        return this.withNewRbdLike(this.getRbd() != null ? this.getRbd() : new RBDVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item) {
        return this.withNewRbdLike(this.getRbd() != null ? this.getRbd() : item);
    }

    @Override
    public SecretVolumeSource getSecret() {
        return this.secret != null ? (SecretVolumeSource)this.secret.build() : null;
    }

    @Override
    public A withSecret(SecretVolumeSource secret) {
        this._visitables.remove(this.secret);
        if (secret != null) {
            this.secret = new SecretVolumeSourceBuilder(secret);
            this._visitables.add(this.secret);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public VolumeFluent.SecretNested<A> withNewSecretLike(SecretVolumeSource item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public VolumeFluent.SecretNested<A> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public VolumeFluent.SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : new SecretVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.SecretNested<A> editOrNewSecretLike(SecretVolumeSource item) {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : item);
    }

    @Override
    public VsphereVirtualDiskVolumeSource getVsphereVolume() {
        return this.vsphereVolume != null ? (VsphereVirtualDiskVolumeSource)this.vsphereVolume.build() : null;
    }

    @Override
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume) {
        this._visitables.remove(this.vsphereVolume);
        if (vsphereVolume != null) {
            this.vsphereVolume = new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume);
            this._visitables.add(this.vsphereVolume);
        }
        return (A)this;
    }

    @Override
    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolume() {
        return new VsphereVolumeNestedImpl();
    }

    @Override
    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
        return new VsphereVolumeNestedImpl(item);
    }

    @Override
    public VolumeFluent.VsphereVolumeNested<A> editVsphereVolume() {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume());
    }

    @Override
    public VolumeFluent.VsphereVolumeNested<A> editOrNewVsphereVolume() {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume() != null ? this.getVsphereVolume() : new VsphereVirtualDiskVolumeSourceBuilder().build());
    }

    @Override
    public VolumeFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume() != null ? this.getVsphereVolume() : item);
    }

    @Override
    public A withNewVsphereVolume(String fsType, String volumePath) {
        return this.withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, volumePath));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeFluentImpl that = (VolumeFluentImpl)o;
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.azureFile != null ? !this.azureFile.equals(that.azureFile) : that.azureFile != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.cinder != null ? !this.cinder.equals(that.cinder) : that.cinder != null) {
            return false;
        }
        if (this.configMap != null ? !this.configMap.equals(that.configMap) : that.configMap != null) {
            return false;
        }
        if (this.downwardAPI != null ? !this.downwardAPI.equals(that.downwardAPI) : that.downwardAPI != null) {
            return false;
        }
        if (this.emptyDir != null ? !this.emptyDir.equals(that.emptyDir) : that.emptyDir != null) {
            return false;
        }
        if (this.fc != null ? !this.fc.equals(that.fc) : that.fc != null) {
            return false;
        }
        if (this.flexVolume != null ? !this.flexVolume.equals(that.flexVolume) : that.flexVolume != null) {
            return false;
        }
        if (this.flocker != null ? !this.flocker.equals(that.flocker) : that.flocker != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.gitRepo != null ? !this.gitRepo.equals(that.gitRepo) : that.gitRepo != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeClaim != null ? !this.persistentVolumeClaim.equals(that.persistentVolumeClaim) : that.persistentVolumeClaim != null) {
            return false;
        }
        if (this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        return !(this.vsphereVolume != null ? !this.vsphereVolume.equals(that.vsphereVolume) : that.vsphereVolume != null);
    }

    public class VsphereVolumeNestedImpl<N>
    extends VsphereVirtualDiskVolumeSourceFluentImpl<VolumeFluent.VsphereVolumeNested<N>>
    implements VolumeFluent.VsphereVolumeNested<N>,
    Nested<N> {
        private final VsphereVirtualDiskVolumeSourceBuilder builder;

        VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item) {
            this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
        }

        VsphereVolumeNestedImpl() {
            this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withVsphereVolume(this.builder.build());
        }

        @Override
        public N endVsphereVolume() {
            return this.and();
        }
    }

    public class SecretNestedImpl<N>
    extends SecretVolumeSourceFluentImpl<VolumeFluent.SecretNested<N>>
    implements VolumeFluent.SecretNested<N>,
    Nested<N> {
        private final SecretVolumeSourceBuilder builder;

        SecretNestedImpl(SecretVolumeSource item) {
            this.builder = new SecretVolumeSourceBuilder(this, item);
        }

        SecretNestedImpl() {
            this.builder = new SecretVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class RbdNestedImpl<N>
    extends RBDVolumeSourceFluentImpl<VolumeFluent.RbdNested<N>>
    implements VolumeFluent.RbdNested<N>,
    Nested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNestedImpl(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        RbdNestedImpl() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withRbd(this.builder.build());
        }

        @Override
        public N endRbd() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimNestedImpl<N>
    extends PersistentVolumeClaimVolumeSourceFluentImpl<VolumeFluent.PersistentVolumeClaimNested<N>>
    implements VolumeFluent.PersistentVolumeClaimNested<N>,
    Nested<N> {
        private final PersistentVolumeClaimVolumeSourceBuilder builder;

        PersistentVolumeClaimNestedImpl(PersistentVolumeClaimVolumeSource item) {
            this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
        }

        PersistentVolumeClaimNestedImpl() {
            this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withPersistentVolumeClaim(this.builder.build());
        }

        @Override
        public N endPersistentVolumeClaim() {
            return this.and();
        }
    }

    public class NfsNestedImpl<N>
    extends NFSVolumeSourceFluentImpl<VolumeFluent.NfsNested<N>>
    implements VolumeFluent.NfsNested<N>,
    Nested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNestedImpl(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        NfsNestedImpl() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withNfs(this.builder.build());
        }

        @Override
        public N endNfs() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends DeprecatedDownwardAPIVolumeSourceFluentImpl<VolumeFluent.MetadataNested<N>>
    implements VolumeFluent.MetadataNested<N>,
    Nested<N> {
        private final DeprecatedDownwardAPIVolumeSourceBuilder builder;

        MetadataNestedImpl(DeprecatedDownwardAPIVolumeSource item) {
            this.builder = new DeprecatedDownwardAPIVolumeSourceBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new DeprecatedDownwardAPIVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class IscsiNestedImpl<N>
    extends ISCSIVolumeSourceFluentImpl<VolumeFluent.IscsiNested<N>>
    implements VolumeFluent.IscsiNested<N>,
    Nested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNestedImpl(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        IscsiNestedImpl() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withIscsi(this.builder.build());
        }

        @Override
        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNestedImpl<N>
    extends HostPathVolumeSourceFluentImpl<VolumeFluent.HostPathNested<N>>
    implements VolumeFluent.HostPathNested<N>,
    Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNestedImpl(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        HostPathNestedImpl() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withHostPath(this.builder.build());
        }

        @Override
        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNestedImpl<N>
    extends GlusterfsVolumeSourceFluentImpl<VolumeFluent.GlusterfsNested<N>>
    implements VolumeFluent.GlusterfsNested<N>,
    Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNestedImpl(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        GlusterfsNestedImpl() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withGlusterfs(this.builder.build());
        }

        @Override
        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GitRepoNestedImpl<N>
    extends GitRepoVolumeSourceFluentImpl<VolumeFluent.GitRepoNested<N>>
    implements VolumeFluent.GitRepoNested<N>,
    Nested<N> {
        private final GitRepoVolumeSourceBuilder builder;

        GitRepoNestedImpl(GitRepoVolumeSource item) {
            this.builder = new GitRepoVolumeSourceBuilder(this, item);
        }

        GitRepoNestedImpl() {
            this.builder = new GitRepoVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withGitRepo(this.builder.build());
        }

        @Override
        public N endGitRepo() {
            return this.and();
        }
    }

    public class GcePersistentDiskNestedImpl<N>
    extends GCEPersistentDiskVolumeSourceFluentImpl<VolumeFluent.GcePersistentDiskNested<N>>
    implements VolumeFluent.GcePersistentDiskNested<N>,
    Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        GcePersistentDiskNestedImpl() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withGcePersistentDisk(this.builder.build());
        }

        @Override
        public N endGcePersistentDisk() {
            return this.and();
        }
    }

    public class FlockerNestedImpl<N>
    extends FlockerVolumeSourceFluentImpl<VolumeFluent.FlockerNested<N>>
    implements VolumeFluent.FlockerNested<N>,
    Nested<N> {
        private final FlockerVolumeSourceBuilder builder;

        FlockerNestedImpl(FlockerVolumeSource item) {
            this.builder = new FlockerVolumeSourceBuilder(this, item);
        }

        FlockerNestedImpl() {
            this.builder = new FlockerVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withFlocker(this.builder.build());
        }

        @Override
        public N endFlocker() {
            return this.and();
        }
    }

    public class FlexVolumeNestedImpl<N>
    extends FlexVolumeSourceFluentImpl<VolumeFluent.FlexVolumeNested<N>>
    implements VolumeFluent.FlexVolumeNested<N>,
    Nested<N> {
        private final FlexVolumeSourceBuilder builder;

        FlexVolumeNestedImpl(FlexVolumeSource item) {
            this.builder = new FlexVolumeSourceBuilder(this, item);
        }

        FlexVolumeNestedImpl() {
            this.builder = new FlexVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withFlexVolume(this.builder.build());
        }

        @Override
        public N endFlexVolume() {
            return this.and();
        }
    }

    public class FcNestedImpl<N>
    extends FCVolumeSourceFluentImpl<VolumeFluent.FcNested<N>>
    implements VolumeFluent.FcNested<N>,
    Nested<N> {
        private final FCVolumeSourceBuilder builder;

        FcNestedImpl(FCVolumeSource item) {
            this.builder = new FCVolumeSourceBuilder(this, item);
        }

        FcNestedImpl() {
            this.builder = new FCVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withFc(this.builder.build());
        }

        @Override
        public N endFc() {
            return this.and();
        }
    }

    public class EmptyDirNestedImpl<N>
    extends EmptyDirVolumeSourceFluentImpl<VolumeFluent.EmptyDirNested<N>>
    implements VolumeFluent.EmptyDirNested<N>,
    Nested<N> {
        private final EmptyDirVolumeSourceBuilder builder;

        EmptyDirNestedImpl(EmptyDirVolumeSource item) {
            this.builder = new EmptyDirVolumeSourceBuilder(this, item);
        }

        EmptyDirNestedImpl() {
            this.builder = new EmptyDirVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withEmptyDir(this.builder.build());
        }

        @Override
        public N endEmptyDir() {
            return this.and();
        }
    }

    public class DownwardAPINestedImpl<N>
    extends DownwardAPIVolumeSourceFluentImpl<VolumeFluent.DownwardAPINested<N>>
    implements VolumeFluent.DownwardAPINested<N>,
    Nested<N> {
        private final DownwardAPIVolumeSourceBuilder builder;

        DownwardAPINestedImpl(DownwardAPIVolumeSource item) {
            this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
        }

        DownwardAPINestedImpl() {
            this.builder = new DownwardAPIVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withDownwardAPI(this.builder.build());
        }

        @Override
        public N endDownwardAPI() {
            return this.and();
        }
    }

    public class ConfigMapNestedImpl<N>
    extends ConfigMapVolumeSourceFluentImpl<VolumeFluent.ConfigMapNested<N>>
    implements VolumeFluent.ConfigMapNested<N>,
    Nested<N> {
        private final ConfigMapVolumeSourceBuilder builder;

        ConfigMapNestedImpl(ConfigMapVolumeSource item) {
            this.builder = new ConfigMapVolumeSourceBuilder(this, item);
        }

        ConfigMapNestedImpl() {
            this.builder = new ConfigMapVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withConfigMap(this.builder.build());
        }

        @Override
        public N endConfigMap() {
            return this.and();
        }
    }

    public class CinderNestedImpl<N>
    extends CinderVolumeSourceFluentImpl<VolumeFluent.CinderNested<N>>
    implements VolumeFluent.CinderNested<N>,
    Nested<N> {
        private final CinderVolumeSourceBuilder builder;

        CinderNestedImpl(CinderVolumeSource item) {
            this.builder = new CinderVolumeSourceBuilder(this, item);
        }

        CinderNestedImpl() {
            this.builder = new CinderVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withCinder(this.builder.build());
        }

        @Override
        public N endCinder() {
            return this.and();
        }
    }

    public class CephfsNestedImpl<N>
    extends CephFSVolumeSourceFluentImpl<VolumeFluent.CephfsNested<N>>
    implements VolumeFluent.CephfsNested<N>,
    Nested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNestedImpl(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        CephfsNestedImpl() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withCephfs(this.builder.build());
        }

        @Override
        public N endCephfs() {
            return this.and();
        }
    }

    public class AzureFileNestedImpl<N>
    extends AzureFileVolumeSourceFluentImpl<VolumeFluent.AzureFileNested<N>>
    implements VolumeFluent.AzureFileNested<N>,
    Nested<N> {
        private final AzureFileVolumeSourceBuilder builder;

        AzureFileNestedImpl(AzureFileVolumeSource item) {
            this.builder = new AzureFileVolumeSourceBuilder(this, item);
        }

        AzureFileNestedImpl() {
            this.builder = new AzureFileVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withAzureFile(this.builder.build());
        }

        @Override
        public N endAzureFile() {
            return this.and();
        }
    }

    public class AwsElasticBlockStoreNestedImpl<N>
    extends AWSElasticBlockStoreVolumeSourceFluentImpl<VolumeFluent.AwsElasticBlockStoreNested<N>>
    implements VolumeFluent.AwsElasticBlockStoreNested<N>,
    Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        AwsElasticBlockStoreNestedImpl() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withAwsElasticBlockStore(this.builder.build());
        }

        @Override
        public N endAwsElasticBlockStore() {
            return this.and();
        }
    }
}

