/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.geo;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.net.InetAddress;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.AddressableLocation;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.geo.HasHostGeoInfo;
import org.apache.brooklyn.core.location.geo.HostGeoLookup;
import org.apache.brooklyn.core.location.geo.MaxMind2HostGeoLookup;
import org.apache.brooklyn.core.location.geo.UtraceHostGeoLookup;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.internal.BrooklynSystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostGeoInfo
implements Serializable {
    private static final long serialVersionUID = -5866759901535266181L;
    public static final Logger log = LoggerFactory.getLogger(HostGeoInfo.class);
    public final String address;
    public final String displayName;
    public final double latitude;
    public final double longitude;
    private static Maybe<HostGeoLookup> cachedLookup = null;
    @Deprecated
    private static boolean warnedLegacy = false;

    public static HostGeoInfo create(String address, String displayName, double latitude, double longitude) {
        return new HostGeoInfo(address, displayName, latitude, longitude);
    }

    public static HostGeoInfo fromIpAddress(InetAddress address) {
        block3: {
            try {
                HostGeoLookup lookup = HostGeoInfo.getDefaultLookup();
                if (lookup != null) {
                    return lookup.getHostGeoInfo(address);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("unable to look up geo DNS info for " + address, (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static HostGeoLookup getDefaultLookup() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (cachedLookup == null) {
            cachedLookup = Maybe.of((Object)HostGeoInfo.findHostGeoLookupImpl());
        }
        return (HostGeoLookup)cachedLookup.get();
    }

    public static void clearCachedLookup() {
        cachedLookup = null;
    }

    public static HostGeoInfo fromLocation(Location l) {
        Location la;
        if (l == null) {
            return null;
        }
        HostGeoInfo resultFromLocation = null;
        for (la = l; !(la == null || la instanceof HasHostGeoInfo && (resultFromLocation = ((HasHostGeoInfo)l).getHostGeoInfo()) != null); la = la.getParent()) {
        }
        if (resultFromLocation != null && l == la) {
            return resultFromLocation;
        }
        InetAddress address = HostGeoInfo.findIpAddress(l);
        Object latitude = l.getConfig(LocationConfigKeys.LATITUDE);
        Object longitude = l.getConfig(LocationConfigKeys.LONGITUDE);
        if (resultFromLocation != null && (latitude == null || longitude == null)) {
            latitude = resultFromLocation.latitude;
            longitude = resultFromLocation.longitude;
        }
        if (address != null && (latitude == null || longitude == null)) {
            HostGeoInfo geo = HostGeoInfo.fromIpAddress(address);
            if (geo == null) {
                return null;
            }
            latitude = geo.latitude;
            longitude = geo.longitude;
        }
        if (latitude == null || longitude == null) {
            return null;
        }
        Exception error = null;
        try {
            latitude = TypeCoercions.castPrimitive(latitude, Double.class);
            longitude = TypeCoercions.castPrimitive(longitude, Double.class);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            error = e;
        }
        if (error != null || !(latitude instanceof Double) || !(longitude instanceof Double)) {
            throw new IllegalArgumentException("Location " + l + " specifies invalid type of lat/long: lat=" + latitude + " (type " + (latitude == null ? null : latitude.getClass()) + "); lon=" + longitude + " (type " + (longitude == null ? null : longitude.getClass()) + ")", error);
        }
        HostGeoInfo result = new HostGeoInfo(address != null ? address.getHostAddress() : null, l.getDisplayName(), (Double)latitude, (Double)longitude);
        if (l instanceof AbstractLocation) {
            ((AbstractLocation)l).setHostGeoInfo(result);
        }
        return result;
    }

    private static HostGeoLookup findHostGeoLookupImpl() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String type = BrooklynSystemProperties.HOST_GEO_LOOKUP_IMPL.getValue();
        if (type == null && (type = BrooklynSystemProperties.HOST_GEO_LOOKUP_IMPL_LEGACY.getValue()) != null && !warnedLegacy) {
            warnedLegacy = true;
            log.warn("Using deprecated host-geo-lookup property " + BrooklynSystemProperties.HOST_GEO_LOOKUP_IMPL_LEGACY + "; set " + BrooklynSystemProperties.HOST_GEO_LOOKUP_IMPL + " instead");
        }
        if (type == null) {
            if (MaxMind2HostGeoLookup.getDatabaseReader() != null) {
                return new MaxMind2HostGeoLookup();
            }
            log.debug("Using Utrace remote for geo lookup because MaxMind2 is not available");
            return new UtraceHostGeoLookup();
        }
        if (type.isEmpty()) {
            return null;
        }
        return (HostGeoLookup)new ClassLoaderUtils(HostGeoInfo.class).loadClass(type).newInstance();
    }

    public static HostGeoInfo fromEntity(Entity e) {
        for (Location l : e.getLocations()) {
            HostGeoInfo hgi = HostGeoInfo.fromLocation(l);
            if (hgi == null) continue;
            return hgi;
        }
        return null;
    }

    public static InetAddress findIpAddress(Location l) {
        if (l == null) {
            return null;
        }
        if (l instanceof AddressableLocation) {
            return ((AddressableLocation)l).getAddress();
        }
        return HostGeoInfo.findIpAddress(l.getParent());
    }

    public HostGeoInfo(String address, String displayName, double latitude, double longitude) {
        this.address = address;
        this.displayName = displayName == null ? "" : displayName;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getAddress() {
        return this.address;
    }

    public String toString() {
        return "HostGeoInfo[" + this.displayName + ": " + (this.address != null ? this.address : "(no-address)") + " at (" + this.latitude + "," + this.longitude + ")]";
    }

    public boolean equals(Object o) {
        return o instanceof HostGeoInfo && Objects.equal((Object)this.address, (Object)((HostGeoInfo)o).address) && Objects.equal((Object)this.displayName, (Object)((HostGeoInfo)o).displayName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address, this.displayName});
    }
}

