/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.password;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensor;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Identifiers;

public class CreatePasswordSensor
extends AddSensor<String> {
    public static final ConfigKey<Integer> PASSWORD_LENGTH = ConfigKeys.newIntegerConfigKey("password.length", "The length of the password to be created", 12);
    public static final ConfigKey<String> ACCEPTABLE_CHARS = ConfigKeys.newStringConfigKey("password.chars", "The characters allowed in password");
    public static final ConfigKey<List<String>> CHARACTER_GROUPS = ConfigKeys.newConfigKey(new TypeToken<List<String>>(){}, "password.character.groups", "A list of strings, where each string is a character group (such as letters, or numbers). The password will be constructed using only characters from these strings, and will use at least one character from each group. When using this option, `password.length` must be at least as long as the number of character groups given.");
    private Integer passwordLength;
    private String acceptableChars;
    private List<String> characterGroups;

    public CreatePasswordSensor(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public CreatePasswordSensor(ConfigBag params) {
        super(params);
        this.passwordLength = params.get(PASSWORD_LENGTH);
        this.acceptableChars = params.get(ACCEPTABLE_CHARS);
        this.characterGroups = params.get(CHARACTER_GROUPS);
    }

    @Override
    public void apply(EntityLocal entity) {
        super.apply(entity);
        boolean isCharacterGroupsPresent = this.characterGroups != null && this.characterGroups.size() > 0;
        boolean isCharacterGroupsValid = isCharacterGroupsPresent && !Iterables.contains(this.characterGroups, (Object)Predicates.isNull()) && !Iterables.contains(this.characterGroups, (Object)Predicates.equalTo((Object)""));
        boolean isAcceptableCharsPresentAndValid = this.acceptableChars != null && !this.acceptableChars.isEmpty();
        Preconditions.checkArgument((!isCharacterGroupsPresent || isCharacterGroupsValid ? 1 : 0) != 0, (Object)"password.character.groups config key was given but does not contain any valid groups");
        Preconditions.checkArgument((!isCharacterGroupsPresent || !isAcceptableCharsPresentAndValid ? 1 : 0) != 0, (Object)"password.chars and password.character.groups both provided - please provide only ONE of them");
        Preconditions.checkArgument((!isCharacterGroupsValid || this.characterGroups.size() <= this.passwordLength ? 1 : 0) != 0, (Object)"password.length must be longer than the number of entries in password.character.groups");
        String password = isCharacterGroupsValid ? Identifiers.makeRandomPassword((int)this.passwordLength, (String[])this.characterGroups.toArray(new String[0])) : (isAcceptableCharsPresentAndValid ? Identifiers.makeRandomPassword((int)this.passwordLength, (String[])new String[]{this.acceptableChars}) : Identifiers.makeRandomPassword((int)this.passwordLength));
        entity.sensors().set(this.sensor, (Object)password);
    }
}

