/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.geronimo.components.jaspi.impl.ConfigProviderImpl;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.JaspiType;
import org.apache.geronimo.components.jaspi.model.JaspiXmlUtil;
import org.apache.geronimo.components.jaspi.model.ObjectFactory;
import org.xml.sax.SAXException;

public class AuthConfigFactoryImpl
extends AuthConfigFactory {
    public static final String JASPI_CONFIGURATION_FILE = "org.apache.geronimo.jaspic.configurationFile";
    private static final File DEFAULT_CONFIG_FILE = new File("var/config/security/jaspic/jaspic.xml");
    public static CallbackHandler staticCallbackHandler;
    private static ClassLoader contextClassLoader;
    private Map<String, ConfigProviderInfo> configProviders = new HashMap<String, ConfigProviderInfo>();
    private final CallbackHandler callbackHandler;
    private final File configFile;

    public AuthConfigFactoryImpl(CallbackHandler callbackHandler, File configFile) {
        JaspiXmlUtil.initialize(callbackHandler);
        this.callbackHandler = callbackHandler;
        this.configFile = configFile;
        this.loadConfig();
    }

    public AuthConfigFactoryImpl() {
        this(staticCallbackHandler, AuthConfigFactoryImpl.getConfigFile());
    }

    private static File getConfigFile() {
        String fileLocation = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(AuthConfigFactoryImpl.JASPI_CONFIGURATION_FILE);
            }
        });
        File file = fileLocation == null ? DEFAULT_CONFIG_FILE : new File(fileLocation);
        return file;
    }

    public AuthConfigFactoryImpl(JaspiType jaspiType, CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.configFile = null;
        this.initialize(jaspiType);
    }

    public synchronized String[] detachListener(RegistrationListener listener, String layer, String appContext) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("detachAuthListener"));
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (Map.Entry<String, ConfigProviderInfo> entry : this.getRegistrations().entrySet()) {
            ConfigProviderInfo ctx = entry.getValue();
            if (layer != null && !layer.equals(ctx.getMessageLayer()) || appContext != null && !appContext.equals(ctx.getAppContext()) || !ctx.getListeners().remove(listener)) continue;
            ids.add(entry.getKey());
        }
        return ids.toArray(new String[ids.size()]);
    }

    private Map<String, ConfigProviderInfo> getRegistrations() {
        return this.configProviders;
    }

    public synchronized AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        if (layer == null) {
            throw new NullPointerException("messageLayer");
        }
        if (appContext == null) {
            throw new NullPointerException("appContext");
        }
        ConfigProviderInfo ctx = this.getRegistrations().get(ConfigProviderType.getRegistrationKey(layer, appContext));
        if (ctx == null) {
            ctx = this.getRegistrations().get(ConfigProviderType.getRegistrationKey(null, appContext));
        }
        if (ctx == null) {
            ctx = this.getRegistrations().get(ConfigProviderType.getRegistrationKey(layer, null));
        }
        if (ctx == null) {
            ctx = this.getRegistrations().get(ConfigProviderType.getRegistrationKey(null, null));
        }
        if (ctx != null) {
            if (listener != null) {
                ctx.getListeners().add(listener);
            }
            return ctx.getAuthConfigProvider();
        }
        return null;
    }

    public synchronized AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return this.getRegistrations().get(registrationID);
    }

    public synchronized String[] getRegistrationIDs(AuthConfigProvider provider) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Map.Entry<String, ConfigProviderInfo> entry : this.getRegistrations().entrySet()) {
            ConfigProviderInfo ctx = entry.getValue();
            if (provider != null && !provider.getClass().getName().equals(ctx.getAuthConfigProvider().getClass().getName())) continue;
            ids.add(entry.getKey());
        }
        return ids.toArray(new String[ids.size()]);
    }

    public synchronized void refresh() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("refreshAuth"));
        }
        this.loadConfig();
    }

    public String registerConfigProvider(AuthConfigProvider authConfigProvider, String layer, String appContext, String description) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("registerAuthConfigProvider"));
        }
        return this.registerConfigProvider(authConfigProvider, layer, appContext, description, false, null, null);
    }

    public synchronized String registerConfigProvider(String className, Map constructorParam, String layer, String appContext, String description) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("registerAuthConfigProvider"));
        }
        String key = this.registerConfigProvider(null, layer, appContext, description, true, constructorParam, className);
        this.saveConfig();
        return key;
    }

    private String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description, boolean persistent, Map<String, String> constructorParam, String className) {
        List<Object> listeners;
        String key = ConfigProviderType.getRegistrationKey(layer, appContext);
        ConfigProviderInfo info = this.getRegistrations().get(key);
        if (info == null) {
            listeners = new ArrayList();
        } else {
            if (persistent != info.isPersistent()) {
                throw new IllegalArgumentException("Cannot change the persistence state");
            }
            listeners = info.getListeners();
        }
        ConfigProviderType ctx = new ConfigProviderType(layer, appContext, persistent, persistent ? null : this);
        ctx.setDescription(description);
        if (persistent) {
            if (provider != null) {
                throw new IllegalStateException("Config provider supplied but should be created");
            }
            ctx.setClassName(className);
            ctx.setProperties(constructorParam);
            provider = ConfigProviderImpl.newConfigProvider(this, ctx);
        } else if (provider == null) {
            throw new IllegalStateException("No config provider to set");
        }
        info = new ConfigProviderInfo(provider, ctx, listeners, persistent);
        this.getRegistrations().put(key, info);
        for (RegistrationListener registrationListener : listeners) {
            registrationListener.notify(info.getMessageLayer(), info.getAppContext());
        }
        return key;
    }

    public synchronized boolean removeRegistration(String registrationID) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("removeAuthRegistration"));
        }
        ConfigProviderInfo ctx = this.getRegistrations().remove(registrationID);
        this.saveConfig();
        if (ctx != null) {
            List<RegistrationListener> listeners = ctx.getListeners();
            for (RegistrationListener listener : listeners) {
                listener.notify(ctx.getMessageLayer(), ctx.getAppContext());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        if (this.configFile != null && this.configFile.length() > 0L) {
            JaspiType jaspiType;
            try {
                FileReader in = new FileReader(this.configFile);
                try {
                    jaspiType = JaspiXmlUtil.loadJaspi(in);
                }
                finally {
                    in.close();
                }
            }
            catch (ParserConfigurationException e) {
                throw new SecurityException("Could not read config", e);
            }
            catch (IOException e) {
                throw new SecurityException("Could not read config", e);
            }
            catch (SAXException e) {
                throw new SecurityException("Could not read config", e);
            }
            catch (JAXBException e) {
                throw new SecurityException("Could not read config", e);
            }
            catch (XMLStreamException e) {
                throw new SecurityException("Could not read config", e);
            }
            this.initialize(jaspiType);
        }
    }

    private void initialize(JaspiType jaspiType) {
        HashMap<String, ConfigProviderInfo> configProviderInfos = new HashMap<String, ConfigProviderInfo>();
        try {
            for (ConfigProviderType configProviderType : jaspiType.getConfigProvider()) {
                AuthConfigProvider authConfigProvider = ConfigProviderImpl.newConfigProvider(this, configProviderType);
                ConfigProviderInfo info = new ConfigProviderInfo(authConfigProvider, configProviderType, true);
                configProviderInfos.put(configProviderType.getKey(), info);
            }
        }
        catch (Exception e) {
            throw new SecurityException("Could not map config providers", e);
        }
        this.configProviders = configProviderInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig() {
        if (this.configFile != null) {
            JaspiType jaspiType = new ObjectFactory().createJaspiType();
            try {
                for (ConfigProviderInfo info : this.configProviders.values()) {
                    if (!info.isPersistent()) continue;
                    jaspiType.getConfigProvider().add(info.getConfigProviderType());
                }
                FileWriter out = new FileWriter(this.configFile);
                try {
                    JaspiXmlUtil.writeJaspi(jaspiType, out);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new SecurityException("Could not write config", e);
            }
            catch (XMLStreamException e) {
                throw new SecurityException("Could not write config", e);
            }
            catch (JAXBException e) {
                throw new SecurityException("Could not write config", e);
            }
            catch (Exception e) {
                throw new SecurityException("Could not write config", e);
            }
        }
    }

    static {
        contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static class ConfigProviderInfo
    implements AuthConfigFactory.RegistrationContext {
        private final AuthConfigProvider authConfigProvider;
        private final ConfigProviderType configProviderType;
        private final boolean persistent;
        private final List<RegistrationListener> listeners;

        private ConfigProviderInfo(AuthConfigProvider authConfigProvider, ConfigProviderType configProviderType, boolean persistent) {
            this.authConfigProvider = authConfigProvider;
            this.configProviderType = configProviderType;
            this.persistent = persistent;
            this.listeners = new ArrayList<RegistrationListener>();
        }

        private ConfigProviderInfo(AuthConfigProvider authConfigProvider, ConfigProviderType configProviderType, List<RegistrationListener> listeners, boolean persistent) {
            this.authConfigProvider = authConfigProvider;
            this.configProviderType = configProviderType;
            this.listeners = listeners;
            this.persistent = persistent;
        }

        public AuthConfigProvider getAuthConfigProvider() {
            return this.authConfigProvider;
        }

        public ConfigProviderType getConfigProviderType() {
            return this.configProviderType;
        }

        public List<RegistrationListener> getListeners() {
            return this.listeners;
        }

        public String getAppContext() {
            return this.configProviderType.getAppContext();
        }

        public String getDescription() {
            return this.configProviderType.getDescription();
        }

        public String getMessageLayer() {
            return this.configProviderType.getMessageLayer();
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }
}

