/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.ansible;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.entity.drivers.DriverDependentEntity;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.external.SshWorkflowStep;
import org.apache.brooklyn.entity.cm.ansible.AnsibleConfig;
import org.apache.brooklyn.entity.cm.ansible.AnsiblePlaybookTasks;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;

public class AnsibleSshWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "${playbook_url} [ \" named \" ${playbook_name} ]";
    public static final ConfigKey<String> RUN_DIR = ConfigKeys.newStringConfigKey((String)"run_dir");
    public static final ConfigKey<String> INSTALL_DIR = ConfigKeys.newStringConfigKey((String)"install_dir");
    public static final ConfigKey<Boolean> INSTALL_ANSIBLE = ConfigKeys.newBooleanConfigKey((String)"install");
    public static final ConfigKey<String> ANSIBLE_PLAYBOOK = ConfigKeys.newStringConfigKey((String)"playbook_name", (String)"Local filename to use when installing the playbook");
    public static final ConfigKey<Object> ANSIBLE_PLAYBOOK_YAML = ConfigKeys.newConfigKey(Object.class, (String)"playbook_yaml");
    public static final ConfigKey<String> ANSIBLE_PLAYBOOK_URL = ConfigKeys.newStringConfigKey((String)"playbook_url");
    public static final ConfigKey<Object> ANSIBLE_VARS = ConfigKeys.newConfigKey(Object.class, (String)"vars");
    public static final ConfigKey<DslPredicates.DslPredicate<Integer>> EXIT_CODE = ConfigKeys.newConfigKey((TypeToken)new TypeToken<DslPredicates.DslPredicate<Integer>>(){}, (String)"exit_code");
    public static final ConfigKey<Integer> OUTPUT_MAX_SIZE = ConfigKeys.newIntegerConfigKey((String)"output_max_size", (String)"Maximum size for stdout and stderr, or -1 for no limit", (Integer)100000);

    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        String playbookYaml;
        SshMachineLocation machine = (SshMachineLocation)Locations.findUniqueSshMachineLocation((Iterable)context.getEntity().getLocations()).orThrow("No SSH location available for workflow at " + context.getEntity());
        Object extraVars = context.getInput(ANSIBLE_VARS);
        String playbookName = (String)context.getInput(ANSIBLE_PLAYBOOK);
        String playbookUrl = (String)context.getInput(ANSIBLE_PLAYBOOK_URL);
        Object playbookYamlO = context.getInput(ANSIBLE_PLAYBOOK_YAML);
        if (playbookUrl != null && playbookYamlO != null) {
            throw new IllegalArgumentException("You cannot specify both " + AnsibleConfig.ANSIBLE_PLAYBOOK_URL.getName() + " and " + AnsibleConfig.ANSIBLE_PLAYBOOK_YAML.getName() + " as arguments.");
        }
        if (playbookUrl == null && playbookYamlO == null) {
            throw new IllegalArgumentException("You have to specify either " + AnsibleConfig.ANSIBLE_PLAYBOOK_URL.getName() + " or " + AnsibleConfig.ANSIBLE_PLAYBOOK_YAML.getName() + " as arguments.");
        }
        try {
            playbookYaml = playbookYamlO == null ? null : (playbookYamlO instanceof String ? (String)playbookYamlO : BeanWithTypeUtils.newYamlMapper((ManagementContext)context.getManagementContext(), (boolean)false, null, (boolean)false).writeValueAsString(playbookYamlO));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagateAnnotated((String)"Invalid YAML supplied for playbook", (Throwable)e);
        }
        if (playbookName == null) {
            playbookName = "playbook-" + Strings.firstNonNull((Object[])new Object[]{playbookUrl, playbookYaml}).hashCode();
        }
        if (!Boolean.FALSE.equals(context.getInput(INSTALL_ANSIBLE))) {
            DynamicTasks.queue(AnsiblePlaybookTasks.installAnsible(this.getInstallDir(context), false));
            DynamicTasks.queue(AnsiblePlaybookTasks.setUpHostsFile(false));
        }
        if (extraVars != null) {
            DynamicTasks.queue(AnsiblePlaybookTasks.configureExtraVars(this.getRunDir(context), extraVars, false));
        }
        if (Strings.isNonBlank((CharSequence)playbookUrl)) {
            DynamicTasks.queue(AnsiblePlaybookTasks.installPlaybook(this.getRunDir(context), playbookName, playbookUrl));
        }
        if (Strings.isNonBlank((CharSequence)playbookYaml)) {
            DynamicTasks.queue(AnsiblePlaybookTasks.buildPlaybookFile(this.getRunDir(context), playbookName, playbookYaml));
        }
        ProcessTaskFactory tf = SshWorkflowStep.customizeProcessTaskFactory((WorkflowStepInstanceExecutionContext)context, AnsiblePlaybookTasks.runAnsible(this.getRunDir(context), extraVars, playbookName));
        return ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)tf)).asTask().getUnchecked();
    }

    private String getRunDir(WorkflowStepInstanceExecutionContext context) {
        EntityDriver driver;
        String candidate = (String)context.getInput(RUN_DIR);
        if (candidate != null) {
            return candidate;
        }
        if (context.getEntity() instanceof DriverDependentEntity && (driver = ((DriverDependentEntity)context.getEntity()).getDriver()) instanceof AbstractSoftwareProcessDriver) {
            return ((AbstractSoftwareProcessDriver)driver).getRunDir();
        }
        return "./brooklyn-managed-ansible/install/";
    }

    private String getInstallDir(WorkflowStepInstanceExecutionContext context) {
        EntityDriver driver;
        String candidate = (String)context.getInput(INSTALL_DIR);
        if (candidate != null) {
            return candidate;
        }
        if (context.getEntity() instanceof DriverDependentEntity && (driver = ((DriverDependentEntity)context.getEntity()).getDriver()) instanceof AbstractSoftwareProcessDriver) {
            return ((AbstractSoftwareProcessDriver)driver).getInstallDir();
        }
        return "./brooklyn-managed-ansible/run-" + context.getEntity().getApplicationId() + "-" + context.getEntity().getId() + "/";
    }

    protected Boolean isDefaultIdempotent() {
        return false;
    }
}

