/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.aws;

import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.aws.AbstractEbsVolumeCustomizer;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.features.ElasticBlockStoreApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbsVolumeCustomizers {
    private static final Logger LOG = LoggerFactory.getLogger(EbsVolumeCustomizers.class);

    private EbsVolumeCustomizers() {
    }

    public static class WithExistingVolume
    extends AbstractEbsVolumeCustomizer {
        private String region;
        private String volumeId;

        public void setRegion(String region) {
            this.region = region;
        }

        public void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
            if (computeService instanceof EC2ComputeService) {
                AWSEC2Api ec2Client = (AWSEC2Api)computeService.getContext().unwrapApi(AWSEC2Api.class);
                ElasticBlockStoreApi ebsClient = (ElasticBlockStoreApi)ec2Client.getElasticBlockStoreApi().get();
                ebsClient.attachVolumeInRegion(this.region, this.volumeId, machine.getJcloudsId(), this.ec2DeviceName);
                this.mountFilesystem((JcloudsSshMachineLocation)machine);
            } else {
                LOG.debug("Skipping configuration of non-EC2 ComputeService {}", (Object)computeService);
            }
        }
    }

    public static class WithExistingSnapshot
    extends AbstractEbsVolumeCustomizer {
        private String snapshotId;
        private int sizeInGib;
        private boolean deleteOnTermination;

        public void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public void setSizeInGib(int sizeInGib) {
            this.sizeInGib = sizeInGib;
        }

        public void setDeleteOnTermination(boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public void customize(JcloudsLocation location, ComputeService computeService, TemplateOptions templateOptions) {
            if (templateOptions instanceof EC2TemplateOptions) {
                ((EC2TemplateOptions)templateOptions).mapEBSSnapshotToDeviceName(this.ec2DeviceName, this.snapshotId, Integer.valueOf(this.sizeInGib), this.deleteOnTermination);
            } else {
                LOG.debug("Skipping configuration of non-EC2 TemplateOptions {}", (Object)templateOptions);
            }
        }

        @Override
        public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
            if (computeService instanceof EC2ComputeService) {
                this.mountFilesystem((JcloudsSshMachineLocation)machine);
            } else {
                LOG.debug("Skipping configuration of non-EC2 ComputeService {}", (Object)computeService);
            }
        }
    }

    public static class WithNewVolume
    extends AbstractEbsVolumeCustomizer {
        private String filesystemType;
        private int sizeInGib;
        private boolean deleteOnTermination;

        public void setFilesystemType(String filesystemType) {
            this.filesystemType = filesystemType;
        }

        public void setSizeInGib(int sizeInGib) {
            this.sizeInGib = sizeInGib;
        }

        public void setDeleteOnTermination(boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public void customize(JcloudsLocation location, ComputeService computeService, TemplateOptions templateOptions) {
            if (templateOptions instanceof EC2TemplateOptions) {
                ((EC2TemplateOptions)templateOptions).mapNewVolumeToDeviceName(this.ec2DeviceName, this.sizeInGib, this.deleteOnTermination);
            } else {
                LOG.debug("Skipping configuration of non-EC2 TemplateOptions {}", (Object)templateOptions);
            }
        }

        @Override
        public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
            if (computeService instanceof EC2ComputeService) {
                this.createFilesystem((JcloudsSshMachineLocation)machine, this.filesystemType);
                this.mountFilesystem((JcloudsSshMachineLocation)machine);
            } else {
                LOG.debug("Skipping configuration of non-EC2 ComputeService {}", (Object)computeService);
            }
        }
    }
}

