/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.encryption;

import io.cloudsoft.winrm4j.client.PayloadEncryptionMode;
import io.cloudsoft.winrm4j.client.encryption.ByteArrayUtils;
import io.cloudsoft.winrm4j.client.encryption.WinrmEncryptionUtils;
import io.cloudsoft.winrm4j.client.ntlm.NTCredentialsWithEncryption;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Function;
import java.util.zip.CRC32;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Message;
import org.apache.http.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmEncryptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NtlmEncryptionUtils.class);
    public static final String ENCRYPTED_BOUNDARY_PREFIX = "--Encrypted Boundary";
    public static final String ENCRYPTED_BOUNDARY_CR = "--Encrypted Boundary\r\n";
    public static final String ENCRYPTED_BOUNDARY_END = "--Encrypted Boundary--\r\n";
    protected final NTCredentialsWithEncryption credentials;
    protected final PayloadEncryptionMode payloadEncryptionMode;

    public NtlmEncryptionUtils(NTCredentialsWithEncryption credentials, PayloadEncryptionMode payloadEncryptionMode) {
        this.credentials = credentials;
        this.payloadEncryptionMode = payloadEncryptionMode;
    }

    public static NtlmEncryptionUtils of(Credentials credentials, PayloadEncryptionMode payloadEncryptionMode) {
        if (!(credentials instanceof NTCredentialsWithEncryption)) {
            if (payloadEncryptionMode.isRequired()) {
                throw new IllegalStateException("NTCredentials required to use encryption; instead have " + credentials);
            }
            return null;
        }
        return new NtlmEncryptionUtils((NTCredentialsWithEncryption)credentials, payloadEncryptionMode);
    }

    public static NtlmEncryptionUtils of(Message message, PayloadEncryptionMode payloadEncryptionMode) {
        Credentials credentials = (Credentials)message.getExchange().get((Object)Credentials.class.getName());
        return NtlmEncryptionUtils.of(credentials, payloadEncryptionMode);
    }

    public byte[] encryptAndSign(Message message, byte[] messageBody) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encrypting message, seq=" + this.credentials.getSequenceNumberOutgoing() + " key=" + ByteArrayUtils.formatHexDump(this.credentials.getClientSigningKey()) + "; body:\n" + new String(messageBody));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(ENCRYPTED_BOUNDARY_CR.getBytes());
            out.write("\tContent-Type: application/HTTP-SPNEGO-session-encrypted\r\n".getBytes());
            out.write(("\tOriginalContent: type=application/soap+xml;charset=UTF-8;Length=" + messageBody.length + "\r\n").getBytes());
            out.write(ENCRYPTED_BOUNDARY_CR.getBytes());
            out.write("\tContent-Type: application/octet-stream\r\n".getBytes());
            this.writeNtlmEncrypted(messageBody, out);
            out.write(ENCRYPTED_BOUNDARY_END.getBytes());
            message.put((Object)"Content-Type", (Object)"multipart/encrypted;protocol=\"application/HTTP-SPNEGO-session-encrypted\";boundary=\"Encrypted Boundary\"");
            message.put((Object)Message.ENCODING, null);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encrypted message: " + ByteArrayUtils.formatHexDump(out.toByteArray()));
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot encrypt WinRM message", e);
        }
    }

    private byte[] seal(byte[] in) {
        return this.credentials.getStatefulEncryptor().update(in);
    }

    private void writeNtlmEncrypted(byte[] messageBody, ByteArrayOutputStream encrypted) throws IOException {
        long seqNum = this.credentials.getSequenceNumberOutgoing().incrementAndGet();
        ByteArrayOutputStream signature = new ByteArrayOutputStream();
        ByteArrayOutputStream sealed = new ByteArrayOutputStream();
        sealed.write(this.seal(messageBody));
        NtlmEncryptionUtils.calculateSignature(messageBody, seqNum, signature, this.credentials, NTCredentialsWithEncryption::getClientSigningKey, this::seal);
        encrypted.write(ByteArrayUtils.getLittleEndianUnsignedInt(signature.size()));
        encrypted.write(signature.toByteArray());
        encrypted.write(sealed.toByteArray());
    }

    public void decrypt(Message message) {
        new Decryptor(this.credentials, this.payloadEncryptionMode).handle(message);
    }

    static void calculateSignature(byte[] messageBody, long seqNum, ByteArrayOutputStream signature, NTCredentialsWithEncryption credentials, Function<NTCredentialsWithEncryption, byte[]> signingKeyFunction, Function<byte[], byte[]> sealer) throws IOException {
        if (credentials.hasNegotiateFlag(524288L)) {
            byte[] checksum = WinrmEncryptionUtils.hmacMd5(signingKeyFunction.apply(credentials), ByteArrayUtils.concat(ByteArrayUtils.getLittleEndianUnsignedInt(seqNum), messageBody));
            checksum = Arrays.copyOfRange(checksum, 0, 8);
            if (credentials.hasNegotiateFlag(0x40000000L)) {
                checksum = sealer.apply(checksum);
            }
            signature.write(new byte[]{1, 0, 0, 0});
            signature.write(checksum);
            signature.write(ByteArrayUtils.getLittleEndianUnsignedInt(seqNum));
        } else {
            CRC32 crc = new CRC32();
            crc.update(messageBody);
            long messageCrc = crc.getValue();
            signature.write(new byte[]{1, 0, 0, 0});
            signature.write(sealer.apply(ByteArrayUtils.getLittleEndianUnsignedInt(0L)));
            signature.write(sealer.apply(ByteArrayUtils.getLittleEndianUnsignedInt(messageCrc)));
            signature.write(sealer.apply(ByteArrayUtils.getLittleEndianUnsignedInt(seqNum)));
        }
    }

    public static class Decryptor {
        private final PayloadEncryptionMode payloadEncryptionMode;
        NTCredentialsWithEncryption credentials;
        private byte[] rawBytes;
        private byte[] encryptedPayloadBytes;
        int index;
        int lastBlockStart;
        int lastBlockEnd;
        private byte[] signatureBytes;
        private byte[] sealedBytes;
        private String newHeaders;
        private byte[] unsealedBytes;

        public Decryptor(NTCredentialsWithEncryption credentials, PayloadEncryptionMode payloadEncryptionMode) {
            this.credentials = credentials;
            this.payloadEncryptionMode = payloadEncryptionMode;
        }

        public void handle(Message message) {
            boolean isEncrypted;
            Object contentType = message.get((Object)"Content-Type");
            boolean bl = isEncrypted = contentType == null ? false : contentType.toString().startsWith("multipart/encrypted");
            if (isEncrypted) {
                if (this.credentials == null) {
                    throw new IllegalStateException("Encrypted payload from server when no credentials with encryption known");
                }
                if (!this.credentials.isAuthenticated()) {
                    throw new IllegalStateException("Encrypted payload from server when not authenticated");
                }
                try {
                    this.decrypt(message);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else if (this.payloadEncryptionMode.isRequired() && this.credentials != null && this.credentials.isAuthenticated()) {
                throw new IllegalStateException("Unencrypted payload from server when authenticated and encryption is required");
            }
        }

        void decrypt(Message message) throws IOException {
            InputStream in = (InputStream)message.getContent(InputStream.class);
            this.rawBytes = IOUtils.readBytesFromStream((InputStream)in);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Decrypting message, seq=" + this.credentials.getSequenceNumberIncoming() + " key=" + ByteArrayUtils.formatHexDump(this.credentials.getServerSigningKey()) + "; body:\n" + ByteArrayUtils.formatHexDump(this.rawBytes));
            }
            this.unwrap();
            int signatureLength = (int)ByteArrayUtils.readLittleEndianUnsignedInt(this.encryptedPayloadBytes, 0);
            this.signatureBytes = Arrays.copyOfRange(this.encryptedPayloadBytes, 4, 4 + signatureLength);
            this.sealedBytes = Arrays.copyOfRange(this.encryptedPayloadBytes, 4 + signatureLength, this.encryptedPayloadBytes.length);
            this.unseal();
            this.verify();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Decrypted message: {}", (Object)new String(this.unsealedBytes));
            }
            message.setContent(InputStream.class, (Object)new ByteArrayInputStream(this.unsealedBytes));
        }

        private void verify() throws IOException {
            long seqNum = ByteArrayUtils.readLittleEndianUnsignedInt(this.signatureBytes, 12);
            int checkSumOffset = this.credentials.hasNegotiateFlag(524288L) ? 4 : 8;
            byte[] checksum = Arrays.copyOfRange(this.signatureBytes, checkSumOffset, 12);
            ByteArrayOutputStream signature = new ByteArrayOutputStream();
            NtlmEncryptionUtils.calculateSignature(this.unsealedBytes, seqNum, signature, this.credentials, NTCredentialsWithEncryption::getServerSigningKey, this.credentials.getStatefulDecryptor()::update);
            byte[] expected_checksum = Arrays.copyOfRange(signature.toByteArray(), checkSumOffset, 12);
            long expected_seq_num = ByteArrayUtils.readLittleEndianUnsignedInt(signature.toByteArray(), 12);
            if (!Arrays.equals(checksum, expected_checksum)) {
                throw new IllegalStateException("Checksum mismatch\n" + ByteArrayUtils.formatHexDump(checksum) + "--\n" + ByteArrayUtils.formatHexDump(expected_checksum));
            }
            if (expected_seq_num != seqNum) {
                throw new IllegalStateException("Sequence number mismatch: " + seqNum + " != " + expected_seq_num);
            }
            this.credentials.getSequenceNumberIncoming().incrementAndGet();
        }

        void unwrap() {
            this.index = 0;
            this.skipOver(NtlmEncryptionUtils.ENCRYPTED_BOUNDARY_CR);
            this.skipUntil("\n--Encrypted Boundary\r\n");
            this.newHeaders = new String(Arrays.copyOfRange(this.rawBytes, this.lastBlockStart, this.lastBlockEnd)).trim();
            this.skipUntil("\r\n");
            String secondHeaders = new String(Arrays.copyOfRange(this.rawBytes, this.lastBlockStart, this.lastBlockEnd)).trim();
            this.lastBlockStart = this.index;
            this.index = this.lastBlockEnd = this.rawBytes.length - NtlmEncryptionUtils.ENCRYPTED_BOUNDARY_END.length();
            this.skipOver(NtlmEncryptionUtils.ENCRYPTED_BOUNDARY_END);
            this.encryptedPayloadBytes = Arrays.copyOfRange(this.rawBytes, this.lastBlockStart, this.lastBlockEnd);
        }

        void skipOver(String s) {
            this.skipOver(s.getBytes());
        }

        void skipOver(byte[] expected) {
            int i = 0;
            while (i < expected.length) {
                if (this.index >= this.rawBytes.length) {
                    throw new IllegalStateException("Invalid format for response from server; terminated early (" + i + ") when expecting '" + new String(expected) + "'\n" + ByteArrayUtils.formatHexDump(this.rawBytes));
                }
                if (expected[i++] == this.rawBytes[this.index++]) continue;
                throw new IllegalStateException("Invalid format for response from server; mismatch at position " + this.index + " (" + i + ") when expecting '" + new String(expected) + "'\n" + ByteArrayUtils.formatHexDump(this.rawBytes));
            }
        }

        void skipUntil(String s) {
            this.skipUntil(s.getBytes());
        }

        void skipUntil(byte[] expected) {
            int nextBlock = this.index;
            while (true) {
                for (int i = 0; i < expected.length && nextBlock + i < this.rawBytes.length; ++i) {
                    if (nextBlock + i >= this.rawBytes.length) {
                        throw new IllegalStateException("Invalid format for response from server; terminated early (" + i + ") when looking for '" + new String(expected) + "'\n" + ByteArrayUtils.formatHexDump(this.rawBytes));
                    }
                    if (expected[i] == this.rawBytes[nextBlock + i]) continue;
                    ++nextBlock;
                }
                break;
            }
            this.lastBlockStart = this.index;
            this.lastBlockEnd = nextBlock;
            this.index = nextBlock + expected.length;
        }

        private void unseal() {
            this.unsealedBytes = this.credentials.getStatefulDecryptor().update(this.sealedBytes);
        }
    }
}

