/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.failover;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.time.Duration;

@Beta
public interface ElectPrimaryConfig {
    public static final ConfigKey<TargetMode> TARGET_MODE = ConfigKeys.builder(TargetMode.class, (String)"primary.target.mode").description("where should the policy look for primary candidates; one of 'children', 'members', or 'auto' (members if it's a group)").defaultValue((Object)TargetMode.AUTO).build();
    public static final ConfigKey<SelectionMode> SELECTION_MODE = ConfigKeys.builder(SelectionMode.class, (String)"primary.selection.mode").description("under what circumstances should the primary change:  `failover` to change only if an existing primary is unhealthy, `best` to change so one with the highest weight is always selected, or `strict` to act as `best` but fail if several advertise the highest weight (for use when the weight sensor is updated by the nodes and should tell us unambiguously who was elected)").defaultValue((Object)SelectionMode.FAILOVER).build();
    public static final ConfigKey<Duration> BEST_WAIT_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"primary.stopped.wait.timeout", (String)"if the highest-ranking primary is not starting, the effector will wait this long for it to be starting before picking a less highly-weighted primary; default 5s, typically long enough to avoid races where multiple children are started concurrently but they complete extremely quickly and one completes before a better one starts, the short duration is sufficient for the theoretical best to become waiting where the `primary.starting.wait.timeout` applies", (Duration)Duration.seconds((Number)5));
    public static final ConfigKey<Duration> BEST_STARTING_WAIT_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"primary.starting.wait.timeout", (String)"if the highest-ranking primary is starting, the effector will wait this long for it to be running before picking a less highly-weighted primary (or in the case of `strict` before failing if there are ties); default 5m, typically long enough to avoid races where multiple children are started and a sub-optimal one comes online before the best one", (Duration)Duration.minutes((Number)5));
    public static final ConfigKey<String> PRIMARY_SENSOR_NAME = ConfigKeys.newStringConfigKey((String)"primary.sensor.name", (String)"name of sensor to publish, defaulting to 'primary'", (String)PrimaryDefaultSensorsAndEffectors.PRIMARY.getName());
    public static final ConfigKey<String> PRIMARY_WEIGHT_NAME = ConfigKeys.newStringConfigKey((String)"primary.weight.name", (String)"config key or sensor to scan from candidate nodes to determine who should be primary", (String)PrimaryDefaultSensorsAndEffectors.PRIMARY_WEIGHT_SENSOR.getName());
    public static final ConfigKey<String> PROMOTE_EFFECTOR_NAME = ConfigKeys.newStringConfigKey((String)"primary.promote.effector.name", (String)"effector to invoke on promotion, trying on this entity or if not present then at new primary, default `promote` and with no error if not present at either entity (but if set explicitly it will cause an error if not present)", (String)PrimaryDefaultSensorsAndEffectors.PROMOTE.getName());
    public static final ConfigKey<String> DEMOTE_EFFECTOR_NAME = ConfigKeys.newStringConfigKey((String)"primary.demote.effector.name", (String)"effector to invoke on demotion, trying on this entity or if not present then at old primary, default `demote` and with no error if not present at either entity (but if set explicitly it will cause an error if not present)", (String)PrimaryDefaultSensorsAndEffectors.DEMOTE.getName());

    public static interface PrimaryDefaultSensorsAndEffectors {
        public static final AttributeSensor<Entity> PRIMARY = Sensors.newSensor(Entity.class, (String)"primary");
        public static final ConfigKey<Double> PRIMARY_WEIGHT_CONFIG = ConfigKeys.newDoubleConfigKey((String)"ha.primary.weight");
        public static final AttributeSensor<Double> PRIMARY_WEIGHT_SENSOR = Sensors.newDoubleSensor((String)"ha.primary.weight");
        public static final Effector<String> PROMOTE = Effectors.effector(String.class, (String)"promote").buildAbstract();
        public static final Effector<String> DEMOTE = Effectors.effector(String.class, (String)"demote").buildAbstract();
    }

    public static enum SelectionMode {
        FAILOVER,
        BEST,
        STRICT;

    }

    public static enum TargetMode {
        CHILDREN,
        MEMBERS,
        AUTO;

    }
}

