/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.zookeeper;

import com.google.common.net.HostAndPort;
import java.net.URI;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.zookeeper.AbstractZooKeeperImpl;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperDriver;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;

public class ZooKeeperNodeImpl
extends AbstractZooKeeperImpl
implements ZooKeeperNode {
    public void init() {
        super.init();
        Integer myId = (Integer)this.config().get((ConfigKey.HasConfigKey)MY_ID);
        if (myId == null) {
            throw new NullPointerException("Require value for " + MY_ID.getName());
        }
        this.sensors().set((AttributeSensor)MY_ID, (Object)myId);
    }

    public Class<?> getDriverInterface() {
        return ZooKeeperDriver.class;
    }

    protected void postStart() {
        super.postStart();
        HostAndPort hap = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.sensors().get((AttributeSensor)ZOOKEEPER_PORT)));
        this.sensors().set(ZooKeeperNode.ZOOKEEPER_ENDPOINT, (Object)hap.toString());
        this.sensors().set(Attributes.MAIN_URI, (Object)URI.create("zk://" + hap.toString()));
    }
}

