/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskWrapper;
import org.apache.brooklyn.location.winrm.WinRmPutTaskFactory;
import org.apache.brooklyn.location.winrm.WinRmPutTaskStub;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmPutTaskWrapper
extends WinRmPutTaskStub
implements TaskWrapper<Void> {
    private static final Logger log = LoggerFactory.getLogger(WinRmPutTaskWrapper.class);
    private final Task<Void> task;
    protected Integer exitCodeOfCopy = null;
    protected Exception exception = null;
    protected boolean successful = false;

    WinRmPutTaskWrapper(WinRmPutTaskFactory constructor) {
        super(constructor);
        TaskBuilder tb = TaskBuilder.builder().dynamic(false).displayName(this.getSummary());
        this.task = tb.body((Callable)new WinRmPutJob()).build();
    }

    public Task<Void> asTask() {
        return this.getTask();
    }

    public Task<Void> getTask() {
        return this.task;
    }

    public String toString() {
        return super.toString() + "[" + this.task + "]";
    }

    public Void get() {
        return (Void)this.getTask().getUnchecked();
    }

    public Integer getExitCode() {
        return this.exitCodeOfCopy;
    }

    public Exception getException() {
        return this.exception;
    }

    public WinRmPutTaskWrapper block() {
        this.getTask().blockUntilEnded();
        return this;
    }

    public boolean isDone() {
        return this.getTask().isDone();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    private class WinRmPutJob
    implements Callable<Void> {
        private WinRmPutJob() {
        }

        @Override
        public Void call() throws Exception {
            try {
                Preconditions.checkNotNull((Object)((Object)WinRmPutTaskWrapper.this.getMachine()), (Object)"machine");
                String remoteFile = WinRmPutTaskWrapper.this.getRemoteFile();
                if (WinRmPutTaskWrapper.this.createDirectory) {
                    String remoteDir = remoteFile;
                    int exitCodeOfCreate = -1;
                    try {
                        int li = remoteDir.lastIndexOf("/");
                        if (li >= 0) {
                            remoteDir = remoteDir.substring(0, li + 1);
                            exitCodeOfCreate = WinRmPutTaskWrapper.this.getMachine().execCommands((Map<String, ?>)ImmutableMap.of(), "creating directory for " + WinRmPutTaskWrapper.this.getSummary(), Arrays.asList("md " + remoteDir), (Map<String, ?>)ImmutableMap.of());
                        } else {
                            exitCodeOfCreate = 0;
                        }
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("WinRM put " + WinRmPutTaskWrapper.this.getRemoteFile() + " (create dir, in task " + WinRmPutTaskWrapper.this.getSummary() + ") to " + (Object)((Object)WinRmPutTaskWrapper.this.getMachine()) + " threw exception: " + e);
                        }
                        WinRmPutTaskWrapper.this.exception = e;
                    }
                    if (WinRmPutTaskWrapper.this.exception != null || !Integer.valueOf(0).equals(exitCodeOfCreate)) {
                        if (!WinRmPutTaskWrapper.this.allowFailure) {
                            if (WinRmPutTaskWrapper.this.exception != null) {
                                throw new IllegalStateException(WinRmPutTaskWrapper.this.getSummary() + " (creating dir " + remoteDir + " for WinRM put task) ended with exception, in " + Tasks.current() + ": " + WinRmPutTaskWrapper.this.exception, WinRmPutTaskWrapper.this.exception);
                            }
                            if (exitCodeOfCreate != 0) {
                                WinRmPutTaskWrapper.this.exception = new IllegalStateException(WinRmPutTaskWrapper.this.getSummary() + " (creating dir " + remoteDir + " WinRM put task) ended with exit code " + exitCodeOfCreate + ", in " + Tasks.current());
                                throw WinRmPutTaskWrapper.this.exception;
                            }
                        }
                        return null;
                    }
                }
                ConfigBag config = ConfigBag.newInstanceCopying((ConfigBag)WinRmPutTaskWrapper.this.getConfig());
                if (WinRmPutTaskWrapper.this.permissions != null) {
                    config.put(SshTool.PROP_PERMISSIONS, (Object)WinRmPutTaskWrapper.this.permissions);
                }
                WinRmPutTaskWrapper.this.exitCodeOfCopy = WinRmPutTaskWrapper.this.getMachine().copyTo(config.getAllConfig(), (InputStream)WinRmPutTaskWrapper.this.contents.get(), remoteFile);
                if (log.isDebugEnabled()) {
                    log.debug("WinRM put " + WinRmPutTaskWrapper.this.getRemoteFile() + " (task " + WinRmPutTaskWrapper.this.getSummary() + ") to " + (Object)((Object)WinRmPutTaskWrapper.this.getMachine()) + " completed with exit code " + WinRmPutTaskWrapper.this.exitCodeOfCopy);
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("WinRM put " + WinRmPutTaskWrapper.this.getRemoteFile() + " (task " + WinRmPutTaskWrapper.this.getSummary() + ") to " + (Object)((Object)WinRmPutTaskWrapper.this.getMachine()) + " threw exception: " + e);
                }
                WinRmPutTaskWrapper.this.exception = e;
            }
            if (WinRmPutTaskWrapper.this.exception != null || !Integer.valueOf(0).equals(WinRmPutTaskWrapper.this.exitCodeOfCopy)) {
                if (!WinRmPutTaskWrapper.this.allowFailure) {
                    if (WinRmPutTaskWrapper.this.exception != null) {
                        throw new IllegalStateException(WinRmPutTaskWrapper.this.getSummary() + " (WinRM put task) ended with exception, in " + Tasks.current() + ": " + WinRmPutTaskWrapper.this.exception, WinRmPutTaskWrapper.this.exception);
                    }
                    if (WinRmPutTaskWrapper.this.exitCodeOfCopy != 0) {
                        WinRmPutTaskWrapper.this.exception = new IllegalStateException(WinRmPutTaskWrapper.this.getSummary() + " (WinRM put task) ended with exit code " + WinRmPutTaskWrapper.this.exitCodeOfCopy + ", in " + Tasks.current());
                        throw WinRmPutTaskWrapper.this.exception;
                    }
                }
                return null;
            }
            WinRmPutTaskWrapper.this.successful = WinRmPutTaskWrapper.this.exception == null && Integer.valueOf(0).equals(WinRmPutTaskWrapper.this.exitCodeOfCopy);
            return null;
        }
    }
}

