/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.LocationPropertiesFromBrooklynProperties;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(AbstractLocationResolver.class);
    protected volatile ManagementContext managementContext;
    protected volatile SpecParser specParser;

    protected abstract Class<? extends Location> getLocationType();

    protected abstract SpecParser getSpecParser();

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        this.specParser = this.getSpecParser();
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec(this, spec, true);
    }

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled(this.managementContext, this.getPrefix());
    }

    public LocationSpec<?> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        ConfigBag config = this.extractConfig(locationFlags, spec, registry);
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        if (registry != null) {
            LocationPropertiesFromBrooklynProperties.setLocalTempDir(globalProperties, config);
        }
        return (LocationSpec)((LocationSpec)LocationSpec.create(this.getLocationType()).configure(config.getAllConfig())).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation));
    }

    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        Map globalProperties = registry.getProperties();
        ParsedSpec parsedSpec = this.specParser.parse(spec);
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        ConfigBag flags = ConfigBag.newInstance(parsedSpec.argsMap).putIfAbsent(locationFlags);
        Map<String, Object> filteredProperties = this.getFilteredLocationProperties(this.getPrefix(), namedLocation, flags.getAllConfig(), globalProperties);
        flags.putIfAbsent(filteredProperties);
        return flags;
    }

    protected Map<String, Object> getFilteredLocationProperties(String provider, String namedLocation, Map<String, ?> prioritisedProperties, Map<String, ?> globalProperties) {
        return this.getFilteredLocationProperties(provider, namedLocation, globalProperties);
    }

    @Deprecated
    protected Map<String, Object> getFilteredLocationProperties(String provider, String namedLocation, Map<String, ?> globalProperties) {
        return new LocationPropertiesFromBrooklynProperties().getLocationProperties(this.getPrefix(), namedLocation, globalProperties);
    }

    protected static class SpecParser {
        protected final String prefix;
        protected final Pattern pattern;
        private String exampleUsage;

        public SpecParser(String prefix) {
            this.prefix = prefix;
            this.pattern = Pattern.compile("(" + prefix + "|" + prefix.toLowerCase() + "|" + prefix.toUpperCase() + ")(:)?(\\((.*)\\))?$");
        }

        public SpecParser(String prefix, Pattern pattern) {
            this.prefix = prefix;
            this.pattern = pattern;
        }

        public SpecParser setExampleUsage(String exampleUsage) {
            this.exampleUsage = exampleUsage;
            return this;
        }

        protected String getUsage(String spec) {
            if (this.exampleUsage == null) {
                return "Spec should be in the form " + this.pattern;
            }
            return "for example, " + this.exampleUsage;
        }

        protected void checkParsedSpec(ParsedSpec parsedSpec) {
            for (String key : parsedSpec.argsMap.keySet()) {
                if (!key.contains(":") && !key.contains("{") && !key.contains("}") && !key.contains("(") && !key.contains(")")) continue;
                throw new IllegalArgumentException("Invalid byon spec: " + parsedSpec.spec + " (key=" + key + ")");
            }
            String name = parsedSpec.argsMap.get("name");
            if (parsedSpec.argsMap.containsKey("name") && (name == null || name.isEmpty())) {
                throw new IllegalArgumentException("Invalid location '" + parsedSpec.spec + "'; if name supplied then value must be non-empty");
            }
            String displayName = parsedSpec.argsMap.get("displayName");
            if (parsedSpec.argsMap.containsKey("displayName") && (displayName == null || displayName.isEmpty())) {
                throw new IllegalArgumentException("Invalid location '" + parsedSpec.spec + "'; if displayName supplied then value must be non-empty");
            }
        }

        public ParsedSpec parse(String spec) {
            Matcher matcher = this.pattern.matcher(spec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid location '" + spec + "'; " + this.getUsage(spec));
            }
            String argsPart = matcher.group(3);
            if (argsPart != null && argsPart.startsWith("(") && argsPart.endsWith(")")) {
                argsPart = argsPart.substring(1, argsPart.length() - 1);
            }
            Map argsMap = KeyValueParser.parseMap((String)argsPart);
            ParsedSpec result = new ParsedSpec(spec, (List<String>)ImmutableList.of(), argsMap);
            this.checkParsedSpec(result);
            return result;
        }
    }

    protected static class ParsedSpec {
        public final String spec;
        public final List<String> partsList;
        public final Map<String, String> argsMap;

        ParsedSpec(String spec, List<String> partsList, Map<String, String> argsMap) {
            this.spec = spec;
            this.partsList = ImmutableList.copyOf(partsList);
            this.argsMap = Collections.unmodifiableMap(MutableMap.copyOf(argsMap));
        }
    }
}

