/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Locations {
    private static final Logger log = LoggerFactory.getLogger(Locations.class);
    public static final LocationsFilter USE_FIRST_LOCATION = new LocationsFilter(){
        private static final long serialVersionUID = 3100091615409115890L;

        @Override
        public List<Location> filterForContext(List<Location> locations, Object context) {
            if (locations.size() <= 1) {
                return locations;
            }
            return ImmutableList.of((Object)locations.get(0));
        }
    };

    public static Maybe<MachineLocation> findUniqueMachineLocation(Iterable<? extends Location> locations) {
        return Machines.findUniqueMachineLocation(locations);
    }

    public static Maybe<SshMachineLocation> findUniqueSshMachineLocation(Iterable<? extends Location> locations) {
        return Machines.findUniqueMachineLocation(locations, SshMachineLocation.class);
    }

    public static Collection<? extends Location> getLocationsCheckingAncestors(Collection<? extends Location> locations, Entity entity) {
        for (Entity ancestor = entity; (locations == null || locations.isEmpty()) && ancestor != null; ancestor = ancestor.getParent()) {
            locations = ancestor.getLocations();
        }
        return locations;
    }

    public static boolean isManaged(Location loc) {
        ManagementContext mgmt = ((LocationInternal)loc).getManagementContext();
        return mgmt != null && mgmt.isRunning() && mgmt.getLocationManager().isManaged(loc);
    }

    public static void unmanage(Location loc) {
        if (Locations.isManaged(loc)) {
            ManagementContext mgmt = ((LocationInternal)loc).getManagementContext();
            mgmt.getLocationManager().unmanage(loc);
        }
    }

    @Deprecated
    public static void manage(Location loc, ManagementContext managementContext) {
        if (!managementContext.getLocationManager().isManaged(loc)) {
            log.warn("Deprecated use of unmanaged location (" + loc + "); will be managed automatically now but not supported in future versions");
            log.debug("Stack trace for location of: Deprecated use of unmanaged location; will be managed automatically now but not supported in future versions", (Throwable)new Exception("TRACE for: Deprecated use of unmanaged location"));
            managementContext.getLocationManager().manage(loc);
        }
    }

    public static Location coerceToLocationManaged(ManagementContext mgmt, Object rawO) {
        String name;
        if (rawO == null) {
            return null;
        }
        if (rawO instanceof Location) {
            return (Location)rawO;
        }
        Object raw = rawO;
        if (raw instanceof String) {
            raw = Yamls.parseAll((String)((String)raw)).iterator().next();
        }
        Map flags = null;
        if (raw instanceof Map) {
            Map tm = (Map)raw;
            if (tm.size() != 1) {
                throw new IllegalArgumentException("Location " + rawO + " is invalid; maps must have only one key, being the location spec string");
            }
            name = (String)tm.keySet().iterator().next();
            flags = (Map)tm.values().iterator().next();
        } else if (raw instanceof String) {
            name = (String)raw;
        } else {
            throw new IllegalArgumentException("Location " + rawO + " is invalid; can only parse strings or maps");
        }
        return mgmt.getLocationRegistry().getLocationManaged(name, flags);
    }

    public static Collection<? extends Location> coerceToCollectionOfLocationsManaged(ManagementContext mgmt, Object rawO) {
        if (rawO == null) {
            return null;
        }
        Object raw = rawO;
        if (raw instanceof Collection) {
            MutableList result = MutableList.of();
            for (Object o : (Collection)raw) {
                result.add(Locations.coerceToLocationManaged(mgmt, o));
            }
            return result;
        }
        if (raw instanceof String && (raw = Yamls.parseAll((String)((String)raw)).iterator().next()) instanceof Collection) {
            return Locations.coerceToCollectionOfLocationsManaged(mgmt, raw);
        }
        return Collections.singletonList(Locations.coerceToLocationManaged(mgmt, raw));
    }

    public static interface LocationsFilter
    extends Serializable {
        public List<Location> filterForContext(List<Location> var1, Object var2);
    }
}

