/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;

public class PasswordData {
    protected final String instanceId;
    protected final Date timestamp;
    protected final String passwordData;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromPasswordData(this);
    }

    protected PasswordData(String instanceId, Date timestamp, String passwordData) {
        this.instanceId = (String)Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId");
        this.timestamp = (Date)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.passwordData = (String)Preconditions.checkNotNull((Object)passwordData, (Object)"passwordData");
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getPasswordData() {
        return this.passwordData;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordData other = (PasswordData)PasswordData.class.cast(obj);
        return Objects.equal((Object)this.instanceId, (Object)other.instanceId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("instanceId", (Object)this.instanceId).add("timestamp", (Object)this.timestamp).add("passwordData", (Object)this.passwordData).toString();
    }

    public static class Builder {
        protected String instanceId;
        protected Date timestamp;
        protected String passwordData;

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder passwordData(String passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public PasswordData build() {
            return new PasswordData(this.instanceId, this.timestamp, this.passwordData);
        }

        public Builder fromPasswordData(PasswordData in) {
            return this.instanceId(in.getInstanceId()).timestamp(in.getTimestamp()).passwordData(in.getPasswordData());
        }
    }
}

