/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EnricherMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.FeedMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.ManagedBundleMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.PolicyMemento;
import org.apache.brooklyn.api.objs.BrooklynObjectType;

public class PersisterDeltaImpl
implements BrooklynMementoPersister.Delta,
BrooklynMementoPersister.MutableDelta {
    String planeId;
    Collection<LocationMemento> locations = Sets.newLinkedHashSet();
    Collection<EntityMemento> entities = Sets.newLinkedHashSet();
    Collection<PolicyMemento> policies = Sets.newLinkedHashSet();
    Collection<EnricherMemento> enrichers = Sets.newLinkedHashSet();
    Collection<FeedMemento> feeds = Sets.newLinkedHashSet();
    Collection<CatalogItemMemento> catalogItems = Sets.newLinkedHashSet();
    Collection<ManagedBundleMemento> bundles = Sets.newLinkedHashSet();
    Collection<String> removedLocationIds = Sets.newLinkedHashSet();
    Collection<String> removedEntityIds = Sets.newLinkedHashSet();
    Collection<String> removedPolicyIds = Sets.newLinkedHashSet();
    Collection<String> removedEnricherIds = Sets.newLinkedHashSet();
    Collection<String> removedFeedIds = Sets.newLinkedHashSet();
    Collection<String> removedCatalogItemIds = Sets.newLinkedHashSet();
    Collection<String> removedBundleIds = Sets.newLinkedHashSet();

    public String planeId() {
        return this.planeId;
    }

    public Collection<LocationMemento> locations() {
        return Collections.unmodifiableCollection(this.locations);
    }

    public Collection<EntityMemento> entities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    public Collection<PolicyMemento> policies() {
        return Collections.unmodifiableCollection(this.policies);
    }

    public Collection<EnricherMemento> enrichers() {
        return Collections.unmodifiableCollection(this.enrichers);
    }

    public Collection<FeedMemento> feeds() {
        return Collections.unmodifiableCollection(this.feeds);
    }

    public Collection<CatalogItemMemento> catalogItems() {
        return Collections.unmodifiableCollection(this.catalogItems);
    }

    public Collection<ManagedBundleMemento> bundles() {
        return Collections.unmodifiableCollection(this.bundles);
    }

    public Collection<String> removedLocationIds() {
        return Collections.unmodifiableCollection(this.removedLocationIds);
    }

    public Collection<String> removedEntityIds() {
        return Collections.unmodifiableCollection(this.removedEntityIds);
    }

    public Collection<String> removedPolicyIds() {
        return Collections.unmodifiableCollection(this.removedPolicyIds);
    }

    public Collection<String> removedEnricherIds() {
        return Collections.unmodifiableCollection(this.removedEnricherIds);
    }

    public Collection<String> removedFeedIds() {
        return Collections.unmodifiableCollection(this.removedFeedIds);
    }

    public Collection<String> removedCatalogItemIds() {
        return Collections.unmodifiableCollection(this.removedCatalogItemIds);
    }

    public Collection<String> removedBundleIds() {
        return Collections.unmodifiableCollection(this.removedBundleIds);
    }

    public Collection<? extends Memento> getObjectsOfType(BrooklynObjectType type) {
        return Collections.unmodifiableCollection(this.getMutableObjectsOfType(type));
    }

    @Beta
    private Collection<Memento> getMutableUncheckedObjectsOfType(BrooklynObjectType type) {
        return this.getMutableObjectsOfType(type);
    }

    private Collection<? extends Memento> getMutableObjectsOfType(BrooklynObjectType type) {
        switch (type) {
            case ENTITY: {
                return this.entities;
            }
            case LOCATION: {
                return this.locations;
            }
            case POLICY: {
                return this.policies;
            }
            case ENRICHER: {
                return this.enrichers;
            }
            case FEED: {
                return this.feeds;
            }
            case CATALOG_ITEM: {
                return this.catalogItems;
            }
            case MANAGED_BUNDLE: {
                return this.bundles;
            }
        }
        throw new IllegalArgumentException(type + " not supported");
    }

    public Collection<String> getRemovedIdsOfType(BrooklynObjectType type) {
        return Collections.unmodifiableCollection(this.getRemovedIdsOfTypeMutable(type));
    }

    private Collection<String> getRemovedIdsOfTypeMutable(BrooklynObjectType type) {
        switch (type) {
            case ENTITY: {
                return this.removedEntityIds;
            }
            case LOCATION: {
                return this.removedLocationIds;
            }
            case POLICY: {
                return this.removedPolicyIds;
            }
            case ENRICHER: {
                return this.removedEnricherIds;
            }
            case FEED: {
                return this.removedFeedIds;
            }
            case CATALOG_ITEM: {
                return this.removedCatalogItemIds;
            }
            case MANAGED_BUNDLE: {
                return this.removedBundleIds;
            }
        }
        throw new IllegalArgumentException(type + " not supported");
    }

    public void add(BrooklynObjectType type, Memento memento) {
        this.getMutableUncheckedObjectsOfType(type).add(memento);
    }

    public void addAll(BrooklynObjectType type, Iterable<? extends Memento> mementos) {
        Iterables.addAll(this.getMutableUncheckedObjectsOfType(type), mementos);
    }

    public void removed(BrooklynObjectType type, Set<String> removedIdsOfType) {
        this.getRemovedIdsOfTypeMutable(type).addAll(removedIdsOfType);
    }
}

