/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.dto;

import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.camp.server.dto.LinkDto;
import org.apache.brooklyn.camp.server.dto.ResourceDto;
import org.apache.brooklyn.camp.server.rest.util.DtoFactory;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.ApplicationComponentTemplate;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.Link;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;

public class AssemblyTemplateDto
extends ResourceDto {
    private List<LinkDto> platformComponentTemplates;
    private List<LinkDto> applicationComponentTemplates;

    protected AssemblyTemplateDto() {
    }

    protected AssemblyTemplateDto(DtoFactory dtoFactory, AssemblyTemplate x) {
        super(dtoFactory, (AbstractResource)x);
        this.platformComponentTemplates = new ArrayList<LinkDto>();
        for (Link t : x.getPlatformComponentTemplates().links()) {
            this.platformComponentTemplates.add(LinkDto.newInstance(dtoFactory, PlatformComponentTemplate.class, t));
        }
        this.applicationComponentTemplates = new ArrayList<LinkDto>();
        for (Link t : x.getApplicationComponentTemplates().links()) {
            this.applicationComponentTemplates.add(LinkDto.newInstance(dtoFactory, ApplicationComponentTemplate.class, t));
        }
    }

    public List<LinkDto> getPlatformComponentTemplates() {
        return this.platformComponentTemplates;
    }

    public List<LinkDto> getApplicationComponentTemplates() {
        return this.applicationComponentTemplates;
    }

    public static AssemblyTemplateDto newInstance(DtoFactory dtoFactory, AssemblyTemplate x) {
        return new AssemblyTemplateDto(dtoFactory, x);
    }
}

