/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import java.util.Objects;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;

public class WinRmClientContext {
    private final Bus bus;
    private final boolean cleanupBus;

    public static WinRmClientContext newInstance() {
        Bus bus = WinRmClientContext.configureBus(BusFactory.newInstance().createBus());
        return new WinRmClientContext(bus, true);
    }

    public static WinRmClientContext newInstance(Bus bus) {
        return new WinRmClientContext(bus, false);
    }

    static Bus configureBus(Bus bus) {
        bus.getProperties().put("use.async.http.conduit", Boolean.TRUE);
        bus.getProperties().put("org.apache.cxf.transport.http.async.usePolicy", AsyncHTTPConduitFactory.UseAsyncPolicy.ALWAYS);
        return bus;
    }

    private WinRmClientContext(Bus bus, boolean cleanupBus) {
        this.bus = Objects.requireNonNull(bus, "bus");
        this.cleanupBus = cleanupBus;
    }

    public void shutdown() {
        if (this.cleanupBus) {
            this.bus.shutdown(true);
        }
    }

    Bus getBus() {
        return this.bus;
    }
}

