/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.functions.ReuseOrAssociateNewPublicIPAddress;
import org.jclouds.logging.Logger;

public class StaticNATVirtualMachineInNetwork
implements Function<VirtualMachine, PublicIPAddress> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackApi client;
    private final ReuseOrAssociateNewPublicIPAddress reuseOrAssociate;
    private final Network network;

    @Inject
    public StaticNATVirtualMachineInNetwork(CloudStackApi client, ReuseOrAssociateNewPublicIPAddress reuseOrAssociate, @Assisted Network network) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.reuseOrAssociate = (ReuseOrAssociateNewPublicIPAddress)Preconditions.checkNotNull((Object)reuseOrAssociate, (Object)"reuseOrAssociate");
        this.network = (Network)Preconditions.checkNotNull((Object)network, (Object)"network");
    }

    public PublicIPAddress apply(VirtualMachine vm) {
        PublicIPAddress ip = this.reuseOrAssociate.apply(this.network);
        while (!ip.isStaticNAT() || !Objects.equal((Object)ip.getVirtualMachineId(), (Object)vm.getId())) {
            if (ip.getVirtualMachineId() == null || ip.getVirtualMachineId().equals(vm.getId())) {
                try {
                    this.logger.debug(">> static NATing IPAddress(%s) to virtualMachine(%s)", new Object[]{ip.getId(), vm.getId()});
                    this.client.getNATApi().enableStaticNATForVirtualMachine(vm.getId(), ip.getId());
                    ip = this.client.getAddressApi().getPublicIPAddress(ip.getId());
                    if (ip.isStaticNAT() && ip.getVirtualMachineId().equals(vm.getId())) {
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return ip;
            }
            ip = this.reuseOrAssociate.apply(this.network);
        }
        return ip;
    }

    public static interface Factory {
        public StaticNATVirtualMachineInNetwork create(Network var1);
    }
}

