/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_Server;
import org.jclouds.profitbricks.domain.AutoValue_Server_Request_CreatePayload;
import org.jclouds.profitbricks.domain.AutoValue_Server_Request_UpdatePayload;
import org.jclouds.profitbricks.domain.AvailabilityZone;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.util.Preconditions;

public abstract class Server {
    @Nullable
    public abstract DataCenter dataCenter();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract Integer cores();

    @Nullable
    public abstract Integer ram();

    @Nullable
    public abstract Boolean hasInternetAccess();

    @Nullable
    public abstract ProvisioningState state();

    @Nullable
    public abstract Status status();

    @Nullable
    public abstract OsType osType();

    @Nullable
    public abstract AvailabilityZone availabilityZone();

    @Nullable
    public abstract Date creationTime();

    @Nullable
    public abstract Date lastModificationTime();

    @Nullable
    public abstract List<Storage> storages();

    @Nullable
    public abstract List<Nic> nics();

    @Nullable
    public abstract String balancedNicId();

    @Nullable
    public abstract Boolean loadBalanced();

    @Nullable
    public abstract Boolean isCpuHotPlug();

    @Nullable
    public abstract Boolean isCpuHotUnPlug();

    @Nullable
    public abstract Boolean isRamHotPlug();

    @Nullable
    public abstract Boolean isRamHotUnPlug();

    @Nullable
    public abstract Boolean isNicHotPlug();

    @Nullable
    public abstract Boolean isNicHotUnPlug();

    @Nullable
    public abstract Boolean isDiscVirtioHotPlug();

    @Nullable
    public abstract Boolean isDiscVirtioHotUnPlug();

    @Nullable
    public abstract String hostname();

    public static Builder builder() {
        return new AutoValue_Server.Builder().storages((List<Storage>)ImmutableList.of()).nics((List<Nic>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    public static final class Request {
        public static CreatePayload.Builder creatingBuilder() {
            return new AutoValue_Server_Request_CreatePayload.Builder();
        }

        public static UpdatePayload.Builder updatingBuilder() {
            return new AutoValue_Server_Request_UpdatePayload.Builder();
        }

        public static abstract class UpdatePayload {
            public abstract String id();

            @Nullable
            public abstract Integer cores();

            @Nullable
            public abstract Integer ram();

            @Nullable
            public abstract String name();

            @Nullable
            public abstract String bootFromStorageId();

            @Nullable
            public abstract String bootFromImageId();

            @Nullable
            public abstract AvailabilityZone availabilityZone();

            @Nullable
            public abstract OsType osType();

            @Nullable
            public abstract Boolean isCpuHotPlug();

            @Nullable
            public abstract Boolean isCpuHotUnPlug();

            @Nullable
            public abstract Boolean isRamHotPlug();

            @Nullable
            public abstract Boolean isRamHotUnPlug();

            @Nullable
            public abstract Boolean isNicHotPlug();

            @Nullable
            public abstract Boolean isNicHotUnPlug();

            @Nullable
            public abstract Boolean isDiscVirtioHotPlug();

            @Nullable
            public abstract Boolean isDiscVirtioHotUnPlug();

            public static abstract class Builder {
                public abstract Builder id(String var1);

                public abstract Builder cores(Integer var1);

                public abstract Builder ram(Integer var1);

                public abstract Builder name(String var1);

                public abstract Builder bootFromStorageId(String var1);

                public abstract Builder bootFromImageId(String var1);

                public abstract Builder availabilityZone(AvailabilityZone var1);

                public abstract Builder osType(OsType var1);

                public abstract Builder isCpuHotPlug(Boolean var1);

                public abstract Builder isCpuHotUnPlug(Boolean var1);

                public abstract Builder isRamHotPlug(Boolean var1);

                public abstract Builder isRamHotUnPlug(Boolean var1);

                public abstract Builder isNicHotPlug(Boolean var1);

                public abstract Builder isNicHotUnPlug(Boolean var1);

                public abstract Builder isDiscVirtioHotPlug(Boolean var1);

                public abstract Builder isDiscVirtioHotUnPlug(Boolean var1);

                abstract UpdatePayload autoBuild();

                public UpdatePayload build() {
                    UpdatePayload payload = this.autoBuild();
                    if (payload.cores() != null) {
                        Preconditions.checkCores(payload.cores());
                    }
                    if (payload.ram() != null) {
                        Preconditions.checkRam(payload.ram(), payload.isRamHotUnPlug());
                    }
                    return payload;
                }
            }
        }

        public static abstract class CreatePayload {
            public abstract int cores();

            public abstract int ram();

            public abstract String dataCenterId();

            public abstract String name();

            @Nullable
            public abstract String bootFromStorageId();

            @Nullable
            public abstract String bootFromImageId();

            @Nullable
            public abstract Integer lanId();

            @Nullable
            public abstract Boolean hasInternetAccess();

            @Nullable
            public abstract AvailabilityZone availabilityZone();

            @Nullable
            public abstract OsType osType();

            @Nullable
            public abstract Boolean isCpuHotPlug();

            @Nullable
            public abstract Boolean isCpuHotUnPlug();

            @Nullable
            public abstract Boolean isRamHotPlug();

            @Nullable
            public abstract Boolean isRamHotUnPlug();

            @Nullable
            public abstract Boolean isNicHotPlug();

            @Nullable
            public abstract Boolean isNicHotUnPlug();

            @Nullable
            public abstract Boolean isDiscVirtioHotPlug();

            @Nullable
            public abstract Boolean isDiscVirtioHotUnPlug();

            public static abstract class Builder {
                public abstract Builder cores(int var1);

                public abstract Builder ram(int var1);

                public abstract Builder dataCenterId(String var1);

                public abstract Builder name(String var1);

                public abstract Builder bootFromStorageId(String var1);

                public abstract Builder bootFromImageId(String var1);

                public abstract Builder lanId(Integer var1);

                public abstract Builder hasInternetAccess(Boolean var1);

                public abstract Builder availabilityZone(AvailabilityZone var1);

                public abstract Builder osType(OsType var1);

                public abstract Builder isCpuHotPlug(Boolean var1);

                public abstract Builder isCpuHotUnPlug(Boolean var1);

                public abstract Builder isRamHotPlug(Boolean var1);

                public abstract Builder isRamHotUnPlug(Boolean var1);

                public abstract Builder isNicHotPlug(Boolean var1);

                public abstract Builder isNicHotUnPlug(Boolean var1);

                public abstract Builder isDiscVirtioHotPlug(Boolean var1);

                public abstract Builder isDiscVirtioHotUnPlug(Boolean var1);

                abstract CreatePayload autoBuild();

                public CreatePayload build() {
                    CreatePayload payload = this.autoBuild();
                    Preconditions.checkCores(payload.cores());
                    Preconditions.checkRam(payload.ram(), payload.isRamHotUnPlug());
                    return payload;
                }
            }
        }
    }

    public static abstract class Builder {
        public abstract Builder dataCenter(DataCenter var1);

        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder cores(Integer var1);

        public abstract Builder ram(Integer var1);

        public abstract Builder hasInternetAccess(Boolean var1);

        public abstract Builder state(ProvisioningState var1);

        public abstract Builder status(Status var1);

        public abstract Builder osType(OsType var1);

        public abstract Builder availabilityZone(AvailabilityZone var1);

        public abstract Builder creationTime(Date var1);

        public abstract Builder lastModificationTime(Date var1);

        public abstract Builder storages(List<Storage> var1);

        public abstract Builder nics(List<Nic> var1);

        public abstract Builder balancedNicId(String var1);

        public abstract Builder loadBalanced(Boolean var1);

        public abstract Builder isCpuHotPlug(Boolean var1);

        public abstract Builder isCpuHotUnPlug(Boolean var1);

        public abstract Builder isRamHotPlug(Boolean var1);

        public abstract Builder isRamHotUnPlug(Boolean var1);

        public abstract Builder isNicHotPlug(Boolean var1);

        public abstract Builder isNicHotUnPlug(Boolean var1);

        public abstract Builder isDiscVirtioHotPlug(Boolean var1);

        public abstract Builder isDiscVirtioHotUnPlug(Boolean var1);

        public abstract Builder hostname(String var1);

        abstract Server autoBuild();

        public Server build() {
            Server server = this.autoBuild();
            if (server.cores() != null) {
                Preconditions.checkCores(server.cores());
            }
            if (server.ram() != null) {
                Preconditions.checkRam(server.ram(), server.isRamHotUnPlug());
            }
            return server.toBuilder().storages((List<Storage>)ImmutableList.copyOf(server.storages())).nics((List<Nic>)ImmutableList.copyOf(server.nics())).autoBuild();
        }
    }

    public static enum Status {
        NOSTATE,
        RUNNING,
        BLOCKED,
        PAUSED,
        SHUTDOWN,
        SHUTOFF,
        CRASHED,
        UNRECOGNIZED;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            return (Status)((Object)Enums.getIfPresent(Status.class, (String)v).or((Object)UNRECOGNIZED));
        }
    }
}

