/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.Backup;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.DropletCreate;
import org.jclouds.digitalocean2.domain.Kernel;
import org.jclouds.digitalocean2.domain.Snapshot;
import org.jclouds.digitalocean2.domain.internal.PaginatedCollection;
import org.jclouds.digitalocean2.domain.options.CreateDropletOptions;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.functions.BaseToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/droplets")
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface DropletApi
extends Closeable {
    @Named(value="droplet:list")
    @GET
    @ResponseParser(value=ParseDroplets.class)
    @Transform(value=ParseDroplets.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Droplet> list();

    @Named(value="droplet:list")
    @GET
    @ResponseParser(value=ParseDroplets.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Droplet> list(ListOptions var1);

    @Named(value="droplet:listkernels")
    @GET
    @Path(value="/{id}/kernels")
    @ResponseParser(value=ParseKernels.class)
    @Transform(value=ParseKernels.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Kernel> listKernels(@PathParam(value="id") int var1);

    @Named(value="droplet:listkernels")
    @GET
    @Path(value="/{id}/kernels")
    @ResponseParser(value=ParseKernels.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Kernel> listKernels(@PathParam(value="id") int var1, ListOptions var2);

    @Named(value="droplet:listsnapshots")
    @GET
    @Path(value="/{id}/snapshots")
    @ResponseParser(value=ParseSnapshots.class)
    @Transform(value=ParseSnapshots.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Snapshot> listSnapshots(@PathParam(value="id") int var1);

    @Named(value="droplet:listsnapshots")
    @GET
    @Path(value="/{id}/snapshots")
    @ResponseParser(value=ParseSnapshots.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Snapshot> listSnapshots(@PathParam(value="id") int var1, ListOptions var2);

    @Named(value="droplet:listbackups")
    @GET
    @Path(value="/{id}/backups")
    @ResponseParser(value=ParseBackups.class)
    @Transform(value=ParseBackups.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Backup> listBackups(@PathParam(value="id") int var1);

    @Named(value="droplet:listbackups")
    @GET
    @Path(value="/{id}/backups")
    @ResponseParser(value=ParseBackups.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Backup> listBackups(@PathParam(value="id") int var1, ListOptions var2);

    @Named(value="droplet:actions")
    @GET
    @Path(value="/{id}/actions")
    @ResponseParser(value=ParseDropletActions.class)
    @Transform(value=ParseDropletActions.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Action> listActions(@PathParam(value="id") int var1);

    @Named(value="droplet:actions")
    @GET
    @Path(value="/{id}/actions")
    @ResponseParser(value=ParseDropletActions.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Action> listActions(@PathParam(value="id") int var1, ListOptions var2);

    @Named(value="droplet:create")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public DropletCreate create(@PayloadParam(value="name") String var1, @PayloadParam(value="region") String var2, @PayloadParam(value="size") String var3, @PayloadParam(value="image") String var4);

    @Named(value="droplet:create")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=CreateDropletOptions.class)
    public DropletCreate create(@PayloadParam(value="name") String var1, @PayloadParam(value="region") String var2, @PayloadParam(value="size") String var3, @PayloadParam(value="image") String var4, CreateDropletOptions var5);

    @Named(value="droplet:get")
    @GET
    @SelectJson(value={"droplet"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Droplet get(@PathParam(value="id") int var1);

    @Named(value="droplet:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") int var1);

    @Named(value="droplet:reboot")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"action"})
    @Path(value="/{id}/actions")
    @Payload(value="{\"type\":\"reboot\"}")
    public Action reboot(@PathParam(value="id") int var1);

    @Named(value="droplet:powercycle")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"action"})
    @Path(value="/{id}/actions")
    @Payload(value="{\"type\":\"power_cycle\"}")
    public Action powerCycle(@PathParam(value="id") int var1);

    @Named(value="droplet:shutdown")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"action"})
    @Path(value="/{id}/actions")
    @Payload(value="{\"type\":\"shutdown\"}")
    public Action shutdown(@PathParam(value="id") int var1);

    @Named(value="droplet:poweroff")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"action"})
    @Path(value="/{id}/actions")
    @Payload(value="{\"type\":\"power_off\"}")
    public Action powerOff(@PathParam(value="id") int var1);

    @Named(value="droplet:poweron")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"action"})
    @Path(value="/{id}/actions")
    @Payload(value="{\"type\":\"power_on\"}")
    public Action powerOn(@PathParam(value="id") int var1);

    @Named(value="droplet:snapshot")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"action"})
    @Path(value="/{id}/actions")
    @Payload(value="%7B\"type\":\"snapshot\",\"name\":\"{name}\"%7D")
    public Action snapshot(@PathParam(value="id") int var1, @PayloadParam(value="name") String var2);

    public static final class ParseDropletActions
    extends ParseJson<DropletActions> {
        @Inject
        ParseDropletActions(Json json) {
            super(json, TypeLiteral.get(DropletActions.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Action, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Action> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.dropletApi().listActions((Integer)arg0.get(), options);
            }
        }

        private static class DropletActions
        extends PaginatedCollection<Action> {
            @ConstructorProperties(value={"actions", "meta", "links"})
            public DropletActions(List<Action> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }

    public static final class ParseBackups
    extends ParseJson<Backups> {
        @Inject
        ParseBackups(Json json) {
            super(json, TypeLiteral.get(Backups.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Backup, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Backup> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.dropletApi().listBackups((Integer)arg0.get(), options);
            }
        }

        private static class Backups
        extends PaginatedCollection<Backup> {
            @ConstructorProperties(value={"backups", "meta", "links"})
            public Backups(List<Backup> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }

    public static final class ParseSnapshots
    extends ParseJson<Snapshots> {
        @Inject
        ParseSnapshots(Json json) {
            super(json, TypeLiteral.get(Snapshots.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Snapshot, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Snapshot> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.dropletApi().listSnapshots((Integer)arg0.get(), options);
            }
        }

        private static class Snapshots
        extends PaginatedCollection<Snapshot> {
            @ConstructorProperties(value={"snapshots", "meta", "links"})
            public Snapshots(List<Snapshot> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }

    public static final class ParseKernels
    extends ParseJson<Kernels> {
        @Inject
        ParseKernels(Json json) {
            super(json, TypeLiteral.get(Kernels.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Kernel, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Kernel> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.dropletApi().listKernels((Integer)arg0.get(), options);
            }
        }

        private static class Kernels
        extends PaginatedCollection<Kernel> {
            @ConstructorProperties(value={"kernels", "meta", "links"})
            public Kernels(List<Kernel> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }

    public static final class ParseDroplets
    extends ParseJson<Droplets> {
        @Inject
        ParseDroplets(Json json) {
            super(json, TypeLiteral.get(Droplets.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Droplet, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Droplet> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.dropletApi().list(options);
            }
        }

        private static class Droplets
        extends PaginatedCollection<Droplet> {
            @ConstructorProperties(value={"droplets", "meta", "links"})
            public Droplets(List<Droplet> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }
}

